/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.controls.CCombo3;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.IConfigurablePropertyObject;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractComboPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.IValueSourcePropertyEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;

public class StaticFieldPropertyEditor
extends AbstractComboPropertyEditor
implements IConfigurablePropertyObject,
IValueSourcePropertyEditor,
IClipboardSourceProvider {
    private Class<?> m_class;
    private String m_classSourceName;
    private String[] m_names;
    private String[] m_titles;
    private Object[] m_values;

    /*
     * WARNING - void declaration
     */
    public void setValue(Property property, Object value) throws Exception {
        Property property2 = property;
        if (property2 instanceof GenericProperty) {
            void genericProperty;
            GenericProperty genericProperty2 = (GenericProperty)property2;
            GenericProperty cfr_ignored_0 = (GenericProperty)property2;
            String source = this.getValueSource(value);
            genericProperty.setExpression(source, value);
        } else {
            property.setValue(value);
        }
    }

    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value != Property.UNKNOWN_VALUE) {
            int i = 0;
            while (i < this.m_values.length) {
                Object fieldValue = this.m_values[i];
                if (ObjectUtils.equals((Object)fieldValue, (Object)value)) {
                    return this.m_titles[i];
                }
                ++i;
            }
        }
        return null;
    }

    public String getValueSource(Object value) throws Exception {
        if (value != Property.UNKNOWN_VALUE) {
            int i = 0;
            while (i < this.m_values.length) {
                Object fieldValue = this.m_values[i];
                if (ObjectUtils.equals((Object)fieldValue, (Object)value)) {
                    String fieldName = this.m_names[i];
                    if (fieldName == null) {
                        return null;
                    }
                    return String.valueOf(this.m_classSourceName) + "." + fieldName;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String getClipboardSource(GenericProperty property) throws Exception {
        Object value = property.getValue();
        return this.getValueSource(value);
    }

    protected void addItems(Property property, CCombo3 combo) throws Exception {
        String[] stringArray = this.m_titles;
        int n = this.m_titles.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            combo.add(title);
            ++n2;
        }
    }

    protected void selectItem(Property property, CCombo3 combo) throws Exception {
        combo.setText(this.getText(property));
    }

    /*
     * WARNING - void declaration
     */
    protected void toPropertyEx(Property property, CCombo3 combo, int index) throws Exception {
        Object value = this.m_values[index];
        Property property2 = property;
        if (property2 instanceof GenericProperty) {
            void genericProperty;
            GenericProperty genericProperty2 = (GenericProperty)property2;
            GenericProperty cfr_ignored_0 = (GenericProperty)property2;
            String source = this.getValueSource(value);
            genericProperty.setExpression(source, value);
        } else {
            property.setValue(value);
        }
    }

    public void configure(Class<?> clazz, String[] fieldDescriptions) throws Exception {
        this.m_class = clazz;
        this.m_classSourceName = this.m_class.getName().replace('$', '.');
        this.initialize(new Empty_WarningConsumer(), fieldDescriptions);
    }

    @Override
    public void configure(EditorState state, Map<String, Object> parameters) throws Exception {
        String[] fieldDescriptions;
        String classBinaryName = (String)parameters.get("class");
        this.m_class = state.getEditorLoader().loadClass(classBinaryName);
        this.m_classSourceName = classBinaryName.replace('$', '.');
        if (parameters.containsKey("field")) {
            List fieldDescriptionList = (List)parameters.get("field");
            fieldDescriptions = fieldDescriptionList.toArray(new String[fieldDescriptionList.size()]);
        } else if (parameters.containsKey("fields")) {
            fieldDescriptions = StringUtils.split((String)((String)parameters.get("fields")));
        } else {
            throw new DesignerException(501, new String[]{"No fields: " + this.m_classSourceName});
        }
        this.initialize(new EditorState_WarningConsumer(state), fieldDescriptions);
    }

    private void initialize(IWarningConsumer logger, String[] fieldDescriptions) throws Exception {
        fieldDescriptions = StaticFieldPropertyEditor.cleanUpFieldDescriptions(logger, this.m_class, fieldDescriptions);
        int count = fieldDescriptions.length;
        this.m_names = new String[count];
        this.m_titles = new String[count];
        this.m_values = new Object[count];
        int i = 0;
        while (i < count) {
            String fieldDescription = fieldDescriptions[i];
            if ("*remove".equals(fieldDescription)) {
                this.m_titles[i] = "";
            } else {
                this.m_names[i] = StaticFieldPropertyEditor.getFieldName(fieldDescription);
                this.m_titles[i] = StaticFieldPropertyEditor.getFieldTitle(fieldDescription);
                Field field = this.m_class.getField(this.m_names[i]);
                Assert.isTrue((boolean)Modifier.isStatic(field.getModifiers()), (String)"Field %s is not static.", (Object[])new Object[]{field});
                this.m_values[i] = field.get(null);
            }
            ++i;
        }
    }

    private static String[] cleanUpFieldDescriptions(IWarningConsumer logger, Class<?> m_class, String[] fieldDescriptions) throws Exception {
        ArrayList newFieldDescriptions = Lists.newArrayList();
        String[] stringArray = fieldDescriptions;
        int n = fieldDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                String fieldDescription = stringArray[n2];
                if ("*remove".equals(fieldDescription)) {
                    newFieldDescriptions.add(fieldDescription);
                } else {
                    String name = StaticFieldPropertyEditor.getFieldName(fieldDescription);
                    try {
                        m_class.getField(name);
                    }
                    catch (NoSuchFieldException e) {
                        String message = MessageFormat.format("Can not find field {0}.{1}.", m_class.getName(), name);
                        logger.addWarning(message, e);
                        break block5;
                    }
                    newFieldDescriptions.add(fieldDescription);
                }
            }
            ++n2;
        }
        return newFieldDescriptions.toArray(new String[newFieldDescriptions.size()]);
    }

    private static String getFieldName(String fieldDescription) {
        if (!fieldDescription.contains(":")) {
            return fieldDescription;
        }
        String[] parts = StringUtils.split((String)fieldDescription, (String)":");
        String message = "Exactly one ':' expected in description name:title, but found " + fieldDescription;
        Assert.equals((int)2, (int)parts.length, (String)message);
        return parts[0];
    }

    private static String getFieldTitle(String fieldDescription) {
        if (!fieldDescription.contains(":")) {
            return fieldDescription;
        }
        String[] parts = StringUtils.split((String)fieldDescription, (String)":");
        String message = "Exactly one ':' expected in description name:title, but found " + fieldDescription;
        Assert.equals((int)2, (int)parts.length, (String)message);
        return parts[1];
    }

    private static final class EditorState_WarningConsumer
    implements IWarningConsumer {
        private final EditorState m_state;

        private EditorState_WarningConsumer(EditorState state) {
            this.m_state = state;
        }

        @Override
        public void addWarning(String message, Throwable e) {
            this.m_state.addWarning(new EditorWarning(message, e));
        }
    }

    private static final class Empty_WarningConsumer
    implements IWarningConsumer {
        private Empty_WarningConsumer() {
        }

        @Override
        public void addWarning(String message, Throwable e) {
        }
    }

    private static interface IWarningConsumer {
        public void addWarning(String var1, Throwable var2);
    }
}

