/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.databinding.xwt.parser;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.model.broadcast.ObjectInfoTreeComplete;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.utils.xml.DocumentAttribute;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.utils.xml.DocumentModelVisitor;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.rcp.databinding.model.BindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.BeanBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.beans.bindables.PropertyBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.bindables.WidgetPropertyBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.DatabindingsProvider;
import org.eclipse.wb.internal.rcp.databinding.xwt.Messages;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.AttributeDocumentEditor;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.BindingInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.ElementDocumentEditor;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.ObserveTypeContainer;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.beans.BeansObserveTypeContainer;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.widgets.WidgetBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.widgets.WidgetsObserveTypeContainer;

public final class DatabindingParser {
    private static final String BINDING = "{binding ";
    private final XmlObjectInfo m_xmlObjectRoot;
    private final DatabindingsProvider m_provider;
    private final BeansObserveTypeContainer m_beanContainer;
    private final WidgetsObserveTypeContainer m_widgetContainer;

    public static void parse(DatabindingsProvider provider) throws Exception {
        new DatabindingParser(provider.getXmlObjectRoot(), provider);
    }

    private DatabindingParser(XmlObjectInfo xmlObjectRoot, DatabindingsProvider provider) throws Exception {
        this.m_xmlObjectRoot = xmlObjectRoot;
        this.m_provider = provider;
        this.m_beanContainer = (BeansObserveTypeContainer)this.m_provider.getContainer(ObserveType.BEANS);
        this.m_widgetContainer = (WidgetsObserveTypeContainer)this.m_provider.getContainer(ObserveType.WIDGETS);
        for (ObserveTypeContainer container : provider.getContainers()) {
            container.createObservables(this.m_xmlObjectRoot);
        }
        this.m_xmlObjectRoot.addBroadcastListener((Object)new ObjectInfoTreeComplete(){

            public void invoke() throws Exception {
                DatabindingParser.this.m_xmlObjectRoot.removeBroadcastListener((Object)this);
                DatabindingParser.this.parse();
            }
        });
    }

    private void parse() throws Exception {
        this.m_xmlObjectRoot.getElement().accept(new DocumentModelVisitor(){

            public boolean visit(DocumentElement element) {
                if (element.getTag().equalsIgnoreCase("binding")) {
                    DocumentElement propertyElement = element.getParent();
                    if (!propertyElement.getTag().equalsIgnoreCase("MultiBinding")) {
                        try {
                            DocumentElement objectElement = propertyElement.getParent();
                            String property = StringUtils.substringAfter((String)propertyElement.getTag(), (String)".").toLowerCase();
                            BindingInfo binding = DatabindingParser.this.parseBinding(objectElement, property, DatabindingParser.getAttributes(element));
                            if (binding != null) {
                                binding.getConverter().parse(DatabindingParser.this.m_provider, element.getChild("Binding.converter", true));
                                binding.getValidator().parse(DatabindingParser.this.m_provider, element.getChild("Binding.validationRules", true), element.getChild("Binding.validationRule", true));
                                binding.setDocumentEditor(new ElementDocumentEditor(binding, element));
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    for (DocumentAttribute attribute : element.getDocumentAttributes()) {
                        String value = attribute.getValue();
                        if (!value.toLowerCase().startsWith(DatabindingParser.BINDING) || !value.endsWith("}")) continue;
                        try {
                            Map<String, String> attributes = DatabindingParser.getAttributes(value.substring(DatabindingParser.BINDING.length(), value.length() - 1));
                            BindingInfo binding = DatabindingParser.this.parseBinding(element, attribute.getName().toLowerCase(), attributes);
                            if (binding == null) continue;
                            binding.getConverter().parse(DatabindingParser.this.m_provider, element.getRoot(), attributes.get("converter"));
                            binding.getValidator().parse(DatabindingParser.this.m_provider, element.getRoot(), attributes.get("validationrules"), attributes.get("validationrule"));
                            binding.setDocumentEditor(new AttributeDocumentEditor(binding, attribute));
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                return true;
            }
        });
        for (BindingInfo binding : this.m_provider.getBindings0()) {
            binding.postParse();
        }
    }

    private BindingInfo parseBinding(DocumentElement element, String property, Map<String, String> attributes) throws Exception {
        WidgetBindableInfo target = this.m_widgetContainer.resolve(element);
        if (target == null) {
            this.m_provider.addWarning(MessageFormat.format(Messages.DatabindingParser_widgetNotFound, element), new Throwable());
            return null;
        }
        WidgetPropertyBindableInfo targetProperty = target.resolvePropertyByText(property);
        if (targetProperty == null) {
            this.m_provider.addWarning(MessageFormat.format(Messages.DatabindingParser_widgetPropertyNotFound, element, property), new Throwable());
            return null;
        }
        String path = attributes.get("path");
        String elementName = attributes.get("elementname");
        if (elementName != null) {
            WidgetBindableInfo model = this.m_widgetContainer.resolve(elementName);
            if (model == null) {
                this.m_provider.addWarning(MessageFormat.format(Messages.DatabindingParser_widgetNotFound, elementName), new Throwable());
                return null;
            }
            if (path.toLowerCase().startsWith("singleselection.(") && path.endsWith(")")) {
                property.equalsIgnoreCase("input");
                return null;
            }
            WidgetPropertyBindableInfo modelProperty = model.resolvePropertyByText(path.toLowerCase());
            if (modelProperty == null) {
                this.m_provider.addWarning(MessageFormat.format(Messages.DatabindingParser_widgetPropertyNotFound, element, path), new Throwable());
                return null;
            }
            return this.createBinding(target, (BindableInfo)targetProperty, model, (BindableInfo)modelProperty, attributes);
        }
        BeanBindableInfo model = null;
        String source = attributes.get("source");
        if (source != null) {
            String sourceReference = StringUtils.substringBetween((String)source, (String)"{StaticResource", (String)"}").trim();
            model = (BeanBindableInfo)this.m_beanContainer.resolve(sourceReference);
        } else {
            model = this.m_beanContainer.getDataContext();
        }
        if (model == null) {
            this.m_provider.addWarning(Messages.DatabindingParser_beanNotFound, new Throwable());
            return null;
        }
        PropertyBindableInfo modelProperty = model.resolvePropertyReference("\"" + path.toLowerCase() + "\"");
        if (modelProperty == null) {
            this.m_provider.addWarning(MessageFormat.format(Messages.DatabindingParser_beanPropertyNotFound, path), new Throwable());
            return null;
        }
        if (property.equalsIgnoreCase("input")) {
            return null;
        }
        return this.createBinding(target, (BindableInfo)targetProperty, (BindableInfo)model, (BindableInfo)modelProperty, attributes);
    }

    private BindingInfo createBinding(BindableInfo target, BindableInfo targetProperty, BindableInfo model, BindableInfo modelProperty, Map<String, String> attributes) throws Exception {
        BindingInfo binding = new BindingInfo(target, targetProperty, model, modelProperty);
        binding.setMode(attributes.get("mode"));
        binding.setTrigger(attributes.get("updatesourcetrigger"));
        this.m_provider.getBindings0().add(binding);
        return binding;
    }

    private static Map<String, String> getAttributes(DocumentElement element) {
        HashMap attributes = Maps.newHashMap();
        for (DocumentAttribute attribute : element.getDocumentAttributes()) {
            attributes.put(attribute.getName().toLowerCase(), attribute.getValue());
        }
        return attributes;
    }

    private static Map<String, String> getAttributes(String value) {
        HashMap attributes = Maps.newHashMap();
        for (String pair : DatabindingParser.splitAttributePairs(value, " \t,")) {
            String[] values = StringUtils.split((String)pair, (char)'=');
            if (values.length != 2) continue;
            attributes.put(values[0].toLowerCase(), values[1]);
        }
        return attributes;
    }

    private static List<String> splitAttributePairs(String str, String separatorChars) {
        String substring;
        ArrayList attributePairs = Lists.newArrayList();
        int lastSeparatorPosition = 0;
        int innerCounter = 0;
        int i = 0;
        while (i < str.length()) {
            char curChar = str.charAt(i);
            if (curChar == '{') {
                ++innerCounter;
            } else if (curChar == '}') {
                --innerCounter;
            } else if (innerCounter == 0 && separatorChars.indexOf(curChar) >= 0) {
                String substring2 = str.substring(lastSeparatorPosition, i).trim();
                if (!StringUtils.isEmpty((String)substring2)) {
                    attributePairs.add(substring2);
                }
                lastSeparatorPosition = i + 1;
            }
            ++i;
        }
        if (lastSeparatorPosition < str.length() && !StringUtils.isEmpty((String)(substring = str.substring(lastSeparatorPosition).trim()))) {
            attributePairs.add(substring);
        }
        return attributePairs;
    }
}

