/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SignalRelay<SIGNAL> {
    private static final Logger LOGGER = Logger.getLogger(SignalRelay.class.getName());
    private final List<PeerWrapper<SIGNAL, ?>> peers = new ArrayList(2);
    private final Callback<SIGNAL> callback;
    private boolean isSignalled = false;
    private SIGNAL savedSignal;

    public static <T> SignalRelay<T> create(Callback<T> callback) {
        return new SignalRelay<T>(callback);
    }

    public SignalRelay(Callback<SIGNAL> callback) {
        this.callback = callback;
    }

    public void sendSignal(SIGNAL signal, Exception cause) {
        this.sendSignalImpl(this, signal, cause);
    }

    public synchronized boolean isSignalled() {
        return this.isSignalled;
    }

    public synchronized SIGNAL getReceivedSignal() {
        return this.savedSignal;
    }

    public <OPPOSITE> void bind(SignalRelay<OPPOSITE> peer, SignalConverter<SIGNAL, OPPOSITE> toPeerConverter, SignalConverter<OPPOSITE, SIGNAL> fromPeerConverter) throws AlreadySignalledException {
        this.addPeer(peer, toPeerConverter);
        try {
            super.addPeer(this, fromPeerConverter);
        }
        catch (AlreadySignalledException e) {
            PeerWrapper.send(this, peer.getReceivedSignal(), this, fromPeerConverter, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSignalImpl(SignalRelay<?> source, SIGNAL signal, Exception cause) {
        SignalRelay signalRelay = this;
        synchronized (signalRelay) {
            if (this.isSignalled) {
                return;
            }
            this.isSignalled = true;
            this.savedSignal = signal;
        }
        try {
            this.callback.onSignal(signal, cause);
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Exception in relay callback", e);
        }
        for (PeerWrapper<SIGNAL, ?> peer : this.peers) {
            if (peer.getPeer() == source) continue;
            peer.send(this, signal, cause);
        }
    }

    private synchronized <OPPOSITE> void addPeer(SignalRelay<OPPOSITE> peer, SignalConverter<SIGNAL, OPPOSITE> converter) throws AlreadySignalledException {
        if (this.isSignalled) {
            throw new AlreadySignalledException();
        }
        this.peers.add(new PeerWrapper<SIGNAL, OPPOSITE>(peer, converter));
    }

    public static class AlreadySignalledException
    extends Exception {
        AlreadySignalledException() {
        }

        AlreadySignalledException(String message, Throwable cause) {
            super(message, cause);
        }

        AlreadySignalledException(String message) {
            super(message);
        }

        AlreadySignalledException(Throwable cause) {
            super(cause);
        }
    }

    public static interface Callback<S> {
        public void onSignal(S var1, Exception var2) throws RuntimeException, Error;
    }

    private static class PeerWrapper<S, P> {
        private final SignalRelay<P> peer;
        private final SignalConverter<S, P> converter;

        PeerWrapper(SignalRelay<P> peer, SignalConverter<S, P> converter) {
            this.peer = peer;
            this.converter = converter;
        }

        SignalRelay<?> getPeer() {
            return this.peer;
        }

        void send(SignalRelay<?> source, S signal, Exception cause) {
            PeerWrapper.send(source, signal, this.peer, this.converter, cause);
        }

        static <T, D> void send(SignalRelay<?> source, T signal, SignalRelay<D> destination, SignalConverter<T, D> converter, Exception cause) {
            Object convertedSignal = converter == null ? null : converter.convert(signal);
            ((SignalRelay)destination).sendSignalImpl((SignalRelay)source, convertedSignal, cause);
        }
    }

    public static interface SignalConverter<FROM, TO> {
        public TO convert(FROM var1);
    }
}

