/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.zest.core.widgets.ConstraintAdapter;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphContainer;
import org.eclipse.zest.core.widgets.GraphDragSupport;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.HideNodeHelper;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.core.widgets.ZestStyles;
import org.eclipse.zest.core.widgets.internal.ContainerFigure;
import org.eclipse.zest.core.widgets.internal.RevealListener;
import org.eclipse.zest.core.widgets.internal.ZestRootLayer;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.zest.layouts.constraints.LayoutConstraint;

public class Graph
extends FigureCanvas
implements IContainer {
    public static final int ANIMATION_TIME = 500;
    public static final int FISHEYE_ANIMATION_TIME = 100;
    public Color LIGHT_BLUE = null;
    public Color LIGHT_BLUE_CYAN = null;
    public Color GREY_BLUE = null;
    public Color DARK_BLUE = null;
    public Color LIGHT_YELLOW = null;
    public Color HIGHLIGHT_COLOR = ColorConstants.yellow;
    public Color HIGHLIGHT_ADJACENT_COLOR = ColorConstants.orange;
    public Color DEFAULT_NODE_COLOR = this.LIGHT_BLUE;
    private final List<GraphNode> nodes;
    protected List<GraphConnection> connections;
    private List<GraphItem> selectedItems = null;
    private HideNodeHelper hoverNode = null;
    IFigure fisheyedFigure = null;
    private List<SelectionListener> selectionListeners = null;
    private HashMap<IFigure, GraphItem> figure2ItemMap = null;
    private int connectionStyle;
    private int nodeStyle;
    private List<ConstraintAdapter> constraintAdapters;
    private List<RevealListener> revealListeners = null;
    private ScalableFreeformLayeredPane fishEyeLayer = null;
    LayoutAlgorithm layoutAlgorithm = null;
    private Dimension preferredSize = null;
    int style = 0;
    private ScalableFreeformLayeredPane rootlayer;
    private ZestRootLayer zestRootLayer;
    private boolean hasPendingLayoutRequest;
    private boolean enableHideNodes;

    public Graph(Composite parent, int style) {
        this(parent, style, false);
    }

    public Graph(Composite parent, int style, boolean enableHideNodes) {
        super(parent, style | 0x20000000);
        this.style = style;
        this.setBackground(ColorConstants.white);
        this.LIGHT_BLUE = new Color((Device)Display.getDefault(), 216, 228, 248);
        this.LIGHT_BLUE_CYAN = new Color((Device)Display.getDefault(), 213, 243, 255);
        this.GREY_BLUE = new Color((Device)Display.getDefault(), 139, 150, 171);
        this.DARK_BLUE = new Color((Device)Display.getDefault(), 1, 70, 122);
        this.LIGHT_YELLOW = new Color((Device)Display.getDefault(), 255, 255, 206);
        this.setViewport((Viewport)new FreeformViewport());
        this.getLightweightSystem().setEventDispatcher((EventDispatcher)new SWTEventDispatcher(){

            public void dispatchMouseMoved(org.eclipse.swt.events.MouseEvent me) {
                super.dispatchMouseMoved(me);
                if (this.getCurrentEvent() == null) {
                    return;
                }
                if (this.getMouseTarget() == null) {
                    this.setMouseTarget(this.getRoot());
                }
                if ((me.stateMask & SWT.BUTTON_MASK) != 0) {
                    this.getMouseTarget().handleMouseDragged(this.getCurrentEvent());
                } else {
                    this.getMouseTarget().handleMouseMoved(this.getCurrentEvent());
                }
            }
        });
        this.setContents(this.createLayers());
        GraphDragSupport dragSupport = this.createGraphDragSupport();
        this.getLightweightSystem().getRootFigure().addMouseListener((MouseListener)dragSupport);
        this.getLightweightSystem().getRootFigure().addMouseMotionListener((MouseMotionListener)dragSupport);
        this.nodes = new ArrayList<GraphNode>();
        this.preferredSize = new Dimension(-1, -1);
        this.connectionStyle = 0;
        this.nodeStyle = 0;
        this.connections = new ArrayList<GraphConnection>();
        this.constraintAdapters = new ArrayList<ConstraintAdapter>();
        this.selectedItems = new ArrayList<GraphItem>();
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.figure2ItemMap = new HashMap();
        this.enableHideNodes = enableHideNodes;
        this.revealListeners = new ArrayList<RevealListener>(1);
        this.addPaintListener(event -> {
            Iterator<RevealListener> iterator = this.revealListeners.iterator();
            while (iterator.hasNext()) {
                RevealListener reveallisetner = iterator.next();
                reveallisetner.revealed((Control)this);
                iterator.remove();
            }
        });
        this.addDisposeListener(event -> this.release());
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (!this.selectionListeners.contains(selectionListener)) {
            this.selectionListeners.add(selectionListener);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (this.selectionListeners.contains(selectionListener)) {
            this.selectionListeners.remove(selectionListener);
        }
    }

    @Override
    public List<? extends GraphNode> getNodes() {
        return this.nodes;
    }

    public void addConstraintAdapter(ConstraintAdapter constraintAdapter) {
        this.constraintAdapters.add(constraintAdapter);
    }

    public void setConstraintAdapters(List<ConstraintAdapter> constraintAdapters) {
        this.constraintAdapters = constraintAdapters;
    }

    public ScalableFigure getRootLayer() {
        return this.rootlayer;
    }

    public void setConnectionStyle(int connectionStyle) {
        this.connectionStyle = connectionStyle;
    }

    public int getConnectionStyle() {
        return this.connectionStyle;
    }

    public void setNodeStyle(int nodeStyle) {
        this.nodeStyle = nodeStyle;
    }

    public int getNodeStyle() {
        return this.nodeStyle;
    }

    public List<? extends GraphConnection> getConnections() {
        return this.connections;
    }

    public void setSelection(GraphItem[] items) {
        this.clearSelection();
        if (items != null) {
            GraphItem[] graphItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                GraphItem item = graphItemArray[n2];
                if (item != null) {
                    this.select(item);
                }
                ++n2;
            }
        }
    }

    public void selectAll() {
        this.setSelection(this.nodes.toArray(new GraphItem[0]));
    }

    public List<? extends GraphItem> getSelection() {
        return this.selectedItems;
    }

    public String toString() {
        return "GraphModel {" + this.nodes.size() + " nodes, " + this.connections.size() + " connections}";
    }

    public Graph getGraphModel() {
        return this;
    }

    public void dispose() {
        this.release();
        super.dispose();
    }

    @Override
    public void applyLayout() {
        if (!this.hasPendingLayoutRequest) {
            this.hasPendingLayoutRequest = true;
            this.addRevealListener(control -> Display.getDefault().asyncExec(this::applyLayoutInternal));
        }
    }

    public void setPreferredSize(int width, int height) {
        this.preferredSize = new Dimension(width, height);
    }

    @Override
    public void setLayoutAlgorithm(LayoutAlgorithm algorithm, boolean applyLayout) {
        this.layoutAlgorithm = algorithm;
        if (applyLayout) {
            this.applyLayout();
        }
    }

    public LayoutAlgorithm getLayoutAlgorithm() {
        return this.layoutAlgorithm;
    }

    public IFigure getFigureAt(int x, int y) {
        return this.getContents().findFigureAt(x, y, new TreeSearch(){

            public boolean accept(IFigure figure) {
                return true;
            }

            public boolean prune(IFigure figure) {
                IFigure parent = figure.getParent();
                if (parent == Graph.this.fishEyeLayer) {
                    return true;
                }
                if (parent instanceof ContainerFigure && figure instanceof PolylineConnection) {
                    return false;
                }
                if (parent == Graph.this.zestRootLayer || parent == Graph.this.zestRootLayer.getParent() || parent == Graph.this.zestRootLayer.getParent().getParent()) {
                    return false;
                }
                GraphItem item = Graph.this.figure2ItemMap.get(figure);
                return (item == null || item.getItemType() != 3) && !(figure instanceof FreeformLayer) && !(parent instanceof FreeformLayer) && !(figure instanceof ScrollPane) && !(parent instanceof ScrollPane) && !(parent instanceof ScalableFreeformLayeredPane) && !(figure instanceof ScalableFreeformLayeredPane) && !(figure instanceof FreeformViewport) && !(parent instanceof FreeformViewport);
            }
        });
    }

    public boolean getHideNodesEnabled() {
        return this.enableHideNodes;
    }

    protected GraphDragSupport createGraphDragSupport() {
        return new DragSupport(this);
    }

    public void notifyListeners(int eventType, Event event) {
        super.notifyListeners(eventType, event);
        if (eventType == 13 && event != null) {
            this.notifySelectionListeners(new SelectionEvent(event));
        }
    }

    private void release() {
        while (!this.nodes.isEmpty()) {
            GraphNode node = this.nodes.get(0);
            if (node == null) continue;
            node.dispose();
        }
        while (!this.connections.isEmpty()) {
            GraphConnection connection = this.connections.get(0);
            if (connection == null) continue;
            connection.dispose();
        }
        if (this.LIGHT_BLUE != null) {
            this.LIGHT_BLUE.dispose();
        }
        if (this.LIGHT_BLUE_CYAN != null) {
            this.LIGHT_BLUE_CYAN.dispose();
        }
        if (this.GREY_BLUE != null) {
            this.GREY_BLUE.dispose();
        }
        if (this.DARK_BLUE != null) {
            this.DARK_BLUE.dispose();
        }
        if (this.LIGHT_YELLOW != null) {
            this.LIGHT_YELLOW.dispose();
        }
    }

    private void clearSelection() {
        for (GraphItem item : new ArrayList<GraphItem>(this.selectedItems)) {
            this.deselect(item);
        }
    }

    private void fireWidgetSelectedEvent(Item item) {
        Event swtEvent = new Event();
        swtEvent.item = item;
        swtEvent.widget = this;
        this.notifySelectionListeners(new SelectionEvent(swtEvent));
    }

    private void notifySelectionListeners(SelectionEvent event) {
        for (SelectionListener listener : this.selectionListeners) {
            listener.widgetSelected(event);
        }
    }

    private void deselect(GraphItem item) {
        this.selectedItems.remove((Object)item);
        item.unhighlight();
        this.setNodeSelected(item, false);
    }

    private void select(GraphItem item) {
        this.selectedItems.add(item);
        item.highlight();
        this.setNodeSelected(item, true);
    }

    private void setNodeSelected(GraphItem item, boolean selected) {
        if (item instanceof GraphNode) {
            ((GraphNode)item).setSelected(selected);
        }
    }

    void highlightEdge(GraphConnection connection) {
        Connection figure = connection.getConnectionFigure();
        if (figure != null && !connection.isHighlighted()) {
            this.zestRootLayer.highlightConnection((IFigure)figure);
        }
    }

    void unhighlightEdge(GraphConnection connection) {
        Connection figure = connection.getConnectionFigure();
        if (figure != null && connection.isHighlighted()) {
            this.zestRootLayer.unHighlightConnection((IFigure)figure);
        }
    }

    void highlightNode(GraphNode node) {
        IFigure figure = node.getNodeFigure();
        if (figure != null && !node.isHighlighted()) {
            this.zestRootLayer.highlightNode(figure);
        }
    }

    void highlightNode(GraphContainer node) {
        IFigure figure = node.getNodeFigure();
        if (figure != null && !node.isHighlighted()) {
            this.zestRootLayer.highlightNode(figure);
        }
    }

    void unhighlightNode(GraphContainer node) {
        IFigure figure = node.getNodeFigure();
        if (figure != null && node.isHighlighted()) {
            this.zestRootLayer.unHighlightNode(figure);
        }
    }

    void unhighlightNode(GraphNode node) {
        IFigure figure = node.getNodeFigure();
        if (figure != null && node.isHighlighted()) {
            this.zestRootLayer.unHighlightNode(figure);
        }
    }

    GraphConnection[] getConnectionsArray() {
        GraphConnection[] connsArray = new GraphConnection[this.connections.size()];
        return this.connections.toArray(connsArray);
    }

    LayoutRelationship[] getConnectionsToLayout(List<GraphNode> nodesToLayout) {
        LayoutRelationship[] entities;
        if (ZestStyles.checkStyle(this.style, 2)) {
            LinkedList<LayoutRelationship> connectionList = new LinkedList<LayoutRelationship>();
            for (GraphConnection graphConnection : this.getConnections()) {
                if (!graphConnection.isVisible() || !nodesToLayout.contains((Object)graphConnection.getSource()) || !nodesToLayout.contains((Object)graphConnection.getDestination())) continue;
                connectionList.add(graphConnection.getLayoutRelationship());
            }
            entities = connectionList.toArray(new LayoutRelationship[0]);
        } else {
            LinkedList<LayoutRelationship> nodeList = new LinkedList<LayoutRelationship>();
            for (GraphConnection graphConnection : this.getConnections()) {
                if (!nodesToLayout.contains((Object)graphConnection.getSource()) || !nodesToLayout.contains((Object)graphConnection.getDestination())) continue;
                nodeList.add(graphConnection.getLayoutRelationship());
            }
            entities = nodeList.toArray(new LayoutRelationship[0]);
        }
        return entities;
    }

    LayoutEntity[] getNodesToLayout(List<? extends GraphNode> nodes) {
        LayoutEntity[] entities;
        if (ZestStyles.checkStyle(this.style, 2)) {
            LinkedList<LayoutEntity> nodeList = new LinkedList<LayoutEntity>();
            for (GraphNode graphNode : nodes) {
                if (!graphNode.isVisible()) continue;
                nodeList.add(graphNode.getLayoutEntity());
            }
            entities = nodeList.toArray(new LayoutEntity[0]);
        } else {
            LinkedList<LayoutEntity> nodeList = new LinkedList<LayoutEntity>();
            for (GraphNode graphNode : nodes) {
                nodeList.add(graphNode.getLayoutEntity());
            }
            entities = nodeList.toArray(new LayoutEntity[0]);
        }
        return entities;
    }

    void removeConnection(GraphConnection connection) {
        Connection figure = connection.getConnectionFigure();
        PolylineConnection sourceContainerConnectionFigure = connection.getSourceContainerConnectionFigure();
        PolylineConnection targetContainerConnectionFigure = connection.getTargetContainerConnectionFigure();
        connection.removeFigure();
        this.getConnections().remove((Object)connection);
        this.figure2ItemMap.remove(figure);
        if (sourceContainerConnectionFigure != null) {
            this.figure2ItemMap.remove(sourceContainerConnectionFigure);
        }
        if (targetContainerConnectionFigure != null) {
            this.figure2ItemMap.remove(targetContainerConnectionFigure);
        }
    }

    void removeNode(GraphNode node) {
        IFigure figure = node.getNodeFigure();
        if (figure.getParent() != null) {
            if (figure.getParent() instanceof ZestRootLayer) {
                ((ZestRootLayer)figure.getParent()).removeNode(figure);
            } else {
                figure.getParent().remove(figure);
            }
        }
        this.getNodes().remove((Object)node);
        if (this.getSelection() != null) {
            this.getSelection().remove((Object)node);
        }
        this.figure2ItemMap.remove(figure);
    }

    void addConnection(GraphConnection connection, boolean addToEdgeLayer) {
        this.connections.add(connection);
        if (addToEdgeLayer) {
            this.zestRootLayer.addConnection(connection.getFigure());
        }
    }

    void addNode(GraphNode node) {
        this.nodes.add(node);
        this.zestRootLayer.addNode(node.getNodeFigure());
    }

    void addNode(GraphContainer graphContainer) {
        this.nodes.add(graphContainer);
        this.zestRootLayer.addNode(graphContainer.getNodeFigure());
    }

    void registerItem(GraphItem item) {
        if (item.getItemType() == 1) {
            IFigure figure = ((GraphNode)item).getNodeFigure();
            this.figure2ItemMap.put(figure, item);
        } else if (item.getItemType() == 2) {
            IFigure figure = item.getFigure();
            this.figure2ItemMap.put(figure, item);
            if (((GraphConnection)item).getSourceContainerConnectionFigure() != null) {
                this.figure2ItemMap.put((IFigure)((GraphConnection)item).getSourceContainerConnectionFigure(), item);
            }
            if (((GraphConnection)item).getTargetContainerConnectionFigure() != null) {
                this.figure2ItemMap.put((IFigure)((GraphConnection)item).getTargetContainerConnectionFigure(), item);
            }
        } else if (item.getItemType() == 3) {
            IFigure figure = ((GraphNode)item).getNodeFigure();
            this.figure2ItemMap.put(figure, item);
            figure = ((GraphNode)item).getModelFigure();
            this.figure2ItemMap.put(figure, item);
        } else {
            throw new RuntimeException("Unknown item type: " + item.getItemType());
        }
    }

    void changeNodeFigure(IFigure oldValue, IFigure newFigure, GraphNode graphItem) {
        if (this.zestRootLayer.getChildren().contains(oldValue)) {
            this.zestRootLayer.remove(oldValue);
            this.figure2ItemMap.remove(oldValue);
        }
        this.figure2ItemMap.put(newFigure, graphItem);
        this.zestRootLayer.add(newFigure);
    }

    void invokeConstraintAdapters(Object object, LayoutConstraint constraint) {
        if (this.constraintAdapters == null) {
            return;
        }
        for (ConstraintAdapter constraintAdapter : this.constraintAdapters) {
            constraintAdapter.populateConstraint(object, constraint);
        }
    }

    private void applyLayoutInternal() {
        this.hasPendingLayoutRequest = false;
        if (this.getNodes().isEmpty()) {
            return;
        }
        int layoutStyle = 0;
        if ((this.nodeStyle & 0x10) > 0) {
            layoutStyle = 1;
        }
        if (this.layoutAlgorithm == null) {
            this.layoutAlgorithm = new TreeLayoutAlgorithm(layoutStyle);
        }
        this.layoutAlgorithm.setStyle(this.layoutAlgorithm.getStyle() | layoutStyle);
        Dimension d = this.getViewport().getSize();
        d.width -= 10;
        d.height -= 10;
        if (this.preferredSize.width >= 0) {
            d.width = this.preferredSize.width;
        }
        if (this.preferredSize.height >= 0) {
            d.height = this.preferredSize.height;
        }
        if (d.isEmpty()) {
            return;
        }
        LayoutRelationship[] connectionsToLayout = this.getConnectionsToLayout(this.nodes);
        LayoutEntity[] nodesToLayout = this.getNodesToLayout(this.getNodes());
        try {
            if ((this.nodeStyle & 0x100) == 0) {
                Animation.markBegin();
            }
            this.layoutAlgorithm.applyLayout(nodesToLayout, connectionsToLayout, 0.0, 0.0, (double)d.width, (double)d.height, false, false);
            if ((this.nodeStyle & 0x100) == 0) {
                Animation.run((int)500);
            }
            this.getLightweightSystem().getUpdateManager().performUpdate();
        }
        catch (InvalidLayoutConfiguration e) {
            e.printStackTrace();
        }
    }

    private void addRevealListener(RevealListener revealListener) {
        MyRunnable myRunnable = new MyRunnable(){
            boolean isVisible;

            @Override
            public boolean isVisible() {
                return this.isVisible;
            }

            @Override
            public void run() {
                this.isVisible = Graph.this.isVisible();
            }
        };
        Display.getDefault().syncExec((Runnable)myRunnable);
        if (myRunnable.isVisible()) {
            revealListener.revealed((Control)this);
        } else {
            this.revealListeners.add(revealListener);
        }
    }

    protected IFigure createLayers() {
        this.rootlayer = new ScalableFreeformLayeredPane();
        this.rootlayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.zestRootLayer = this.createZestRootLayer();
        this.zestRootLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.fishEyeLayer = new ScalableFreeformLayeredPane();
        this.fishEyeLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        this.rootlayer.add((IFigure)this.zestRootLayer);
        this.rootlayer.add((IFigure)this.fishEyeLayer);
        this.zestRootLayer.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        this.fishEyeLayer.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        return this.rootlayer;
    }

    protected ZestRootLayer createZestRootLayer() {
        return new ZestRootLayer();
    }

    void removeFishEye(IFigure fishEyeFigure, IFigure regularFigure, boolean animate) {
        if (!this.fishEyeLayer.getChildren().contains(fishEyeFigure)) {
            return;
        }
        if (animate) {
            Animation.markBegin();
        }
        Rectangle bounds = regularFigure.getBounds().getCopy();
        regularFigure.translateToAbsolute((Translatable)bounds);
        double scale = this.rootlayer.getScale();
        this.fishEyeLayer.setScale(1.0 / scale);
        this.fishEyeLayer.translateToRelative((Translatable)bounds);
        this.fishEyeLayer.translateFromParent((Translatable)bounds);
        this.fishEyeLayer.setConstraint(fishEyeFigure, (Object)bounds);
        if (animate) {
            Animation.run((int)200);
        }
        this.getRootLayer().getUpdateManager().performUpdate();
        this.fishEyeLayer.removeAll();
        this.fisheyedFigure = null;
    }

    boolean replaceFishFigure(IFigure oldFigure, IFigure newFigure) {
        if (this.fishEyeLayer.getChildren().contains(oldFigure)) {
            Rectangle bounds = oldFigure.getBounds();
            newFigure.setBounds(bounds);
            this.fishEyeLayer.remove(oldFigure);
            this.fishEyeLayer.add(newFigure);
            this.fisheyedFigure = newFigure;
            return true;
        }
        return false;
    }

    void fishEye(IFigure startFigure, IFigure endFigure, Rectangle newBounds, boolean animate) {
        this.fishEyeLayer.removeAll();
        this.fisheyedFigure = null;
        if (animate) {
            Animation.markBegin();
        }
        double scale = this.rootlayer.getScale();
        this.fishEyeLayer.setScale(1.0 / scale);
        this.fishEyeLayer.translateToRelative((Translatable)newBounds);
        this.fishEyeLayer.translateFromParent((Translatable)newBounds);
        Rectangle bounds = startFigure.getBounds().getCopy();
        startFigure.translateToAbsolute((Translatable)bounds);
        this.fishEyeLayer.translateToRelative((Translatable)bounds);
        this.fishEyeLayer.translateFromParent((Translatable)bounds);
        endFigure.setLocation(bounds.getLocation());
        endFigure.setSize(bounds.getSize());
        this.fishEyeLayer.add(endFigure);
        this.fishEyeLayer.setConstraint(endFigure, (Object)newBounds);
        if (animate) {
            Animation.run((int)100);
        }
        this.getRootLayer().getUpdateManager().performUpdate();
    }

    @Override
    public Graph getGraph() {
        return this.getGraphModel();
    }

    @Override
    public int getItemType() {
        return 0;
    }

    protected GraphItem getGraphItem(IFigure figure) {
        return this.figure2ItemMap.get(figure);
    }

    class DragSupport
    implements GraphDragSupport {
        Graph graph = null;
        Point lastLocation = null;
        GraphItem fisheyedItem = null;
        boolean isDragging = false;

        DragSupport(Graph graph2) {
            this.graph = graph2;
        }

        public void mouseDragged(MouseEvent me) {
            if (!this.isDragging) {
                return;
            }
            Point mousePoint = new Point(me.x, me.y);
            Point tempPoint = mousePoint.getCopy();
            if (!Graph.this.selectedItems.isEmpty()) {
                for (GraphItem item : Graph.this.selectedItems) {
                    if (item.getItemType() != 1 && item.getItemType() != 3) continue;
                    GraphNode node = (GraphNode)item;
                    Point pointCopy = mousePoint.getCopy();
                    Point tempLastLocation = this.lastLocation.getCopy();
                    node.getNodeFigure().getParent().translateToRelative((Translatable)tempLastLocation);
                    node.getNodeFigure().getParent().translateFromParent((Translatable)tempLastLocation);
                    node.getNodeFigure().getParent().translateToRelative((Translatable)pointCopy);
                    node.getNodeFigure().getParent().translateFromParent((Translatable)pointCopy);
                    Point delta = new Point(pointCopy.x - tempLastLocation.x, pointCopy.y - tempLastLocation.y);
                    node.setLocation(node.getLocation().x + delta.x, node.getLocation().y + delta.y);
                }
                if (Graph.this.fisheyedFigure != null) {
                    Point pointCopy = mousePoint.getCopy();
                    Point tempLastLocation = this.lastLocation.getCopy();
                    Graph.this.fisheyedFigure.translateToRelative((Translatable)tempLastLocation);
                    Graph.this.fisheyedFigure.translateFromParent((Translatable)tempLastLocation);
                    Graph.this.fisheyedFigure.translateToRelative((Translatable)pointCopy);
                    Graph.this.fisheyedFigure.translateFromParent((Translatable)pointCopy);
                    Point delta = new Point(pointCopy.x - tempLastLocation.x, pointCopy.y - tempLastLocation.y);
                    Point point = new Point(Graph.this.fisheyedFigure.getBounds().x + delta.x, Graph.this.fisheyedFigure.getBounds().y + delta.y);
                    Graph.this.fishEyeLayer.setConstraint(Graph.this.fisheyedFigure, (Object)new Rectangle(point, Graph.this.fisheyedFigure.getSize()));
                    Graph.this.fishEyeLayer.getUpdateManager().performUpdate();
                }
            }
            this.lastLocation = tempPoint;
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
        }

        public void mouseHover(MouseEvent me) {
        }

        /*
         * WARNING - void declaration
         */
        public void mouseMoved(MouseEvent me) {
            Point mousePoint = new Point(me.x, me.y);
            Graph.this.getRootLayer().translateToRelative((Translatable)mousePoint);
            IFigure figureUnderMouse = Graph.this.getFigureAt(mousePoint.x, mousePoint.y);
            if (figureUnderMouse != null) {
                GraphItem itemUnderMouse = Graph.this.figure2ItemMap.get(figureUnderMouse);
                GraphItem graphItem = itemUnderMouse;
                if (graphItem instanceof GraphNode) {
                    void node;
                    GraphNode graphNode = (GraphNode)graphItem;
                    GraphNode cfr_ignored_0 = (GraphNode)graphItem;
                    Graph.this.hoverNode = node.getHideNodeHelper();
                    if (Graph.this.hoverNode != null) {
                        Graph.this.hoverNode.setHideButtonVisible(true);
                        Graph.this.hoverNode.setRevealButtonVisible(true);
                    }
                } else if (Graph.this.hoverNode != null) {
                    Graph.this.hoverNode.setHideButtonVisible(false);
                    Graph.this.hoverNode.setRevealButtonVisible(false);
                    Graph.this.hoverNode = null;
                }
                if (itemUnderMouse != this.fisheyedItem) {
                    if (itemUnderMouse != null && itemUnderMouse.getItemType() == 1) {
                        this.fisheyedItem = itemUnderMouse;
                        Graph.this.fisheyedFigure = ((GraphNode)itemUnderMouse).fishEye(true, true);
                        if (Graph.this.fisheyedFigure == null) {
                            this.fisheyedItem = null;
                        }
                    } else if (this.fisheyedItem != null) {
                        ((GraphNode)this.fisheyedItem).fishEye(false, true);
                        this.fisheyedItem = null;
                        Graph.this.fisheyedFigure = null;
                    }
                }
            } else {
                if (Graph.this.hoverNode != null) {
                    Graph.this.hoverNode.setHideButtonVisible(false);
                    Graph.this.hoverNode.setRevealButtonVisible(false);
                    Graph.this.hoverNode = null;
                }
                if (this.fisheyedItem != null) {
                    ((GraphNode)this.fisheyedItem).fishEye(false, true);
                    this.fisheyedItem = null;
                    Graph.this.fisheyedFigure = null;
                }
            }
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            this.isDragging = true;
            Point mousePoint = new Point(me.x, me.y);
            this.lastLocation = mousePoint.getCopy();
            Graph.this.getRootLayer().translateToRelative((Translatable)mousePoint);
            if ((me.getState() & SWT.MOD3) != 0) {
                if ((me.getState() & SWT.MOD2) == 0) {
                    double scale = Graph.this.getRootLayer().getScale();
                    Graph.this.getRootLayer().setScale(scale *= 1.05);
                    Point newMousePoint = mousePoint.getCopy().scale(1.05);
                    Point delta = new Point(newMousePoint.x - mousePoint.x, newMousePoint.y - mousePoint.y);
                    Point newViewLocation = Graph.this.getViewport().getViewLocation().getCopy().translate(delta);
                    Graph.this.getViewport().setViewLocation(newViewLocation);
                    Graph.this.clearSelection();
                } else {
                    double scale = Graph.this.getRootLayer().getScale();
                    Graph.this.getRootLayer().setScale(scale /= 1.05);
                    Point newMousePoint = mousePoint.getCopy().scale(0.9523809523809523);
                    Point delta = new Point(newMousePoint.x - mousePoint.x, newMousePoint.y - mousePoint.y);
                    Point newViewLocation = Graph.this.getViewport().getViewLocation().getCopy().translate(delta);
                    Graph.this.getViewport().setViewLocation(newViewLocation);
                    Graph.this.clearSelection();
                }
            } else {
                boolean hasSelection = !Graph.this.selectedItems.isEmpty();
                IFigure figureUnderMouse = Graph.this.getFigureAt(mousePoint.x, mousePoint.y);
                Graph.this.getRootLayer().translateFromParent((Translatable)mousePoint);
                if (figureUnderMouse != null) {
                    figureUnderMouse.getParent().translateFromParent((Translatable)mousePoint);
                }
                if (figureUnderMouse == null || figureUnderMouse == Graph.this) {
                    if ((me.getState() & SWT.MOD1) == 0) {
                        Graph.this.clearSelection();
                        if (hasSelection) {
                            Graph.this.fireWidgetSelectedEvent(null);
                            hasSelection = false;
                        }
                    }
                    return;
                }
                GraphItem itemUnderMouse = Graph.this.figure2ItemMap.get(figureUnderMouse);
                if (itemUnderMouse == null) {
                    if ((me.getState() & SWT.MOD1) != 0) {
                        Graph.this.clearSelection();
                        if (hasSelection) {
                            Graph.this.fireWidgetSelectedEvent(null);
                            hasSelection = false;
                        }
                    }
                    return;
                }
                if (Graph.this.selectedItems.contains((Object)itemUnderMouse)) {
                    if ((me.getState() & SWT.MOD1) != 0) {
                        Graph.this.selectedItems.remove((Object)itemUnderMouse);
                        itemUnderMouse.unhighlight();
                        Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
                    }
                    return;
                }
                if ((me.getState() & SWT.MOD1) == 0) {
                    Graph.this.clearSelection();
                }
                if (itemUnderMouse.getItemType() == 1) {
                    Graph.this.selectedItems.add(itemUnderMouse);
                    ((GraphNode)itemUnderMouse).highlight();
                    Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
                } else if (itemUnderMouse.getItemType() == 2) {
                    Graph.this.selectedItems.add(itemUnderMouse);
                    ((GraphConnection)itemUnderMouse).highlight();
                    Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
                } else if (itemUnderMouse.getItemType() == 3) {
                    Graph.this.selectedItems.add(itemUnderMouse);
                    ((GraphContainer)itemUnderMouse).highlight();
                    Graph.this.fireWidgetSelectedEvent(itemUnderMouse);
                }
            }
        }

        public void mouseReleased(MouseEvent me) {
            this.isDragging = false;
        }
    }

    static interface MyRunnable
    extends Runnable {
        public boolean isVisible();
    }
}

