/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.client.messages.swarm.Network;
import org.mandas.docker.client.messages.swarm.NetworkAttachment;

final class ImmutableNetworkAttachment
implements NetworkAttachment {
    private final Network network;
    private final List<String> addresses;

    private ImmutableNetworkAttachment(Network network, List<String> addresses) {
        this.network = network;
        this.addresses = addresses;
    }

    @Override
    @JsonProperty(value="Network")
    public Network network() {
        return this.network;
    }

    @Override
    @JsonProperty(value="Addresses")
    public List<String> addresses() {
        return this.addresses;
    }

    public final ImmutableNetworkAttachment withNetwork(Network value) {
        if (this.network == value) {
            return this;
        }
        Network newValue = Objects.requireNonNull(value, "network");
        return new ImmutableNetworkAttachment(newValue, this.addresses);
    }

    public final ImmutableNetworkAttachment withAddresses(String ... elements) {
        List<String> newValue = ImmutableNetworkAttachment.createUnmodifiableList(false, ImmutableNetworkAttachment.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableNetworkAttachment(this.network, newValue);
    }

    public final ImmutableNetworkAttachment withAddresses(Iterable<String> elements) {
        if (this.addresses == elements) {
            return this;
        }
        List<String> newValue = ImmutableNetworkAttachment.createUnmodifiableList(false, ImmutableNetworkAttachment.createSafeList(elements, true, false));
        return new ImmutableNetworkAttachment(this.network, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNetworkAttachment && this.equalTo((ImmutableNetworkAttachment)another);
    }

    private boolean equalTo(ImmutableNetworkAttachment another) {
        return this.network.equals(another.network) && this.addresses.equals(another.addresses);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.network.hashCode();
        h += (h << 5) + this.addresses.hashCode();
        return h;
    }

    public String toString() {
        return "NetworkAttachment{network=" + this.network + ", addresses=" + this.addresses + "}";
    }

    public static ImmutableNetworkAttachment copyOf(NetworkAttachment instance) {
        if (instance instanceof ImmutableNetworkAttachment) {
            return (ImmutableNetworkAttachment)instance;
        }
        return ImmutableNetworkAttachment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder {
        private static final long INIT_BIT_NETWORK = 1L;
        private long initBits = 1L;
        private Network network;
        private List<String> addresses = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(NetworkAttachment instance) {
            Objects.requireNonNull(instance, "instance");
            this.network(instance.network());
            this.addAllAddresses(instance.addresses());
            return this;
        }

        @JsonProperty(value="Network")
        public final Builder network(Network network) {
            this.network = Objects.requireNonNull(network, "network");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addresse(String element) {
            this.addresses.add(Objects.requireNonNull(element, "addresses element"));
            return this;
        }

        public final Builder addresses(String ... elements) {
            for (String element : elements) {
                this.addresses.add(Objects.requireNonNull(element, "addresses element"));
            }
            return this;
        }

        @JsonProperty(value="Addresses")
        public final Builder addresses(Iterable<String> elements) {
            this.addresses.clear();
            return this.addAllAddresses(elements);
        }

        public final Builder addAllAddresses(Iterable<String> elements) {
            for (String element : elements) {
                this.addresses.add(Objects.requireNonNull(element, "addresses element"));
            }
            return this;
        }

        public ImmutableNetworkAttachment build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNetworkAttachment(this.network, ImmutableNetworkAttachment.createUnmodifiableList(true, this.addresses));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("network");
            }
            return "Cannot build NetworkAttachment, some of required attributes are not set " + attributes;
        }
    }
}

