/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.ProblemFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPComputableFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotations;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunction;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameterSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTypeList;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPFunctionSpecialization
extends PDOMCPPSpecialization
implements ICPPFunctionSpecialization,
ICPPComputableFunction {
    private static final int NUM_PARAMS = 44;
    private static final int FIRST_PARAM = 48;
    private static final int FUNCTION_TYPE = 52;
    protected static final int EXCEPTION_SPEC = 58;
    private static final int ANNOTATION = 62;
    private static final int REQUIRED_ARG_COUNT = 64;
    private static final int FUNCTION_BODY = 66;
    private static final int DECLARED_TYPE = 72;
    protected static final int RECORD_SIZE = 78;
    private ICPPFunctionType fType;
    private ICPPFunctionType fDeclaredType;
    private short fAnnotations = (short)-1;
    private int fRequiredArgCount = -1;

    public PDOMCPPFunctionSpecialization(PDOMCPPLinkage linkage, PDOMNode parent, ICPPFunction astFunction, PDOMBinding specialized) throws CoreException {
        super(linkage, parent, (ICPPSpecialization)((Object)astFunction), specialized);
        Database db = this.getDB();
        this.fAnnotations = PDOMCPPAnnotations.encodeFunctionAnnotations(astFunction);
        db.putShort(this.record + 62L, this.fAnnotations);
        db.putShort(this.record + 64L, (short)astFunction.getRequiredArgumentCount());
        PDOMCPPLinkage pDOMCPPLinkage = linkage;
        pDOMCPPLinkage.getClass();
        pDOMCPPLinkage.new PDOMCPPLinkage.ConfigureFunctionSpecialization(astFunction, this, specialized);
    }

    public PDOMCPPFunctionSpecialization(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    public void initData(PDOMBinding specialized, ICPPFunctionType type, ICPPFunctionType declaredType, ICPPParameter[] astParams, ICPPParameter[] origAstParams, IType[] exceptionSpec, ICPPExecution functionBody) {
        try {
            this.setType(type);
            this.setDeclaredType(declaredType);
            this.setParameters(astParams, origAstParams, specialized);
            this.storeExceptionSpec(exceptionSpec);
            if (functionBody != null) {
                ((PDOMLinkage)this.getLinkage()).storeExecution(this.record + 66L, functionBody);
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    private void setParameters(ICPPParameter[] astParams, ICPPParameter[] origAstParams, PDOMBinding specialized) throws CoreException {
        PDOMCPPLinkage linkage = (PDOMCPPLinkage)this.getLinkage();
        Database db = this.getDB();
        if (origAstParams.length == 0) {
            db.putInt(this.record + 44L, 0);
            db.putRecPtr(this.record + 48L, 0L);
        } else {
            int length = astParams.length;
            db.putInt(this.record + 44L, length);
            db.putRecPtr(this.record + 48L, 0L);
            PDOMCPPParameter origPar = null;
            PDOMNode next = null;
            int i = length;
            while (--i >= 0) {
                if (i < origAstParams.length - 1) {
                    origPar = new PDOMCPPParameter(linkage, specialized, origAstParams[i], null);
                } else if (origPar == null) {
                    origPar = new PDOMCPPParameter(linkage, specialized, origAstParams[origAstParams.length - 1], null);
                }
                next = new PDOMCPPParameterSpecialization(linkage, this, astParams[i], origPar, (PDOMCPPParameterSpecialization)next);
            }
            db.putRecPtr(this.record + 48L, next == null ? 0L : next.getRecord());
        }
    }

    private void setType(ICPPFunctionType ft) throws CoreException {
        if (ft != null) {
            this.fType = null;
            ((PDOMLinkage)this.getLinkage()).storeType(this.record + 52L, ft);
        }
    }

    private void setDeclaredType(ICPPFunctionType ft) throws CoreException {
        if (ft != null) {
            this.fType = null;
            ((PDOMLinkage)this.getLinkage()).storeType(this.record + 72L, ft);
        }
    }

    private void storeExceptionSpec(IType[] exceptionSpec) throws CoreException {
        long typelist = 0L;
        if (exceptionSpec != null) {
            typelist = PDOMCPPTypeList.putTypes(this, exceptionSpec);
        }
        this.getDB().putRecPtr(this.record + 58L, typelist);
    }

    @Override
    protected int getRecordSize() {
        return 78;
    }

    @Override
    public int getNodeType() {
        return 34;
    }

    @Override
    public boolean isInline() {
        return PDOMCPPAnnotations.isInline(this.getAnnotations());
    }

    protected final short getAnnotations() {
        if (this.fAnnotations == -1) {
            try {
                this.fAnnotations = this.getDB().getShort(this.record + 62L);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fAnnotations = 0;
            }
        }
        return this.fAnnotations;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public IScope getFunctionScope() {
        return null;
    }

    @Override
    public ICPPParameter[] getParameters() {
        try {
            ILinkage linkage = this.getLinkage();
            Database db = this.getDB();
            ICPPFunctionType ft = this.getType();
            IType[] ptypes = ft == null ? IType.EMPTY_TYPE_ARRAY : ft.getParameterTypes();
            int n = db.getInt(this.record + 44L);
            ICPPParameter[] result = new ICPPParameter[n];
            long next = db.getRecPtr(this.record + 48L);
            int i = 0;
            while (i < n && next != 0L) {
                IType type = i < ptypes.length ? ptypes[i] : null;
                PDOMCPPParameterSpecialization par = new PDOMCPPParameterSpecialization((PDOMLinkage)linkage, next, type);
                next = par.getNextPtr();
                result[i] = par;
                ++i;
            }
            return result;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPParameter.EMPTY_CPPPARAMETER_ARRAY;
        }
    }

    @Override
    public ICPPFunctionType getDeclaredType() {
        if (this.fDeclaredType == null) {
            try {
                this.fDeclaredType = (ICPPFunctionType)((PDOMLinkage)this.getLinkage()).loadType(this.record + 72L);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fDeclaredType = new ProblemFunctionType(10005);
            }
        }
        return this.fDeclaredType;
    }

    @Override
    public ICPPFunctionType getType() {
        if (this.fType == null) {
            try {
                this.fType = (ICPPFunctionType)((PDOMLinkage)this.getLinkage()).loadType(this.record + 52L);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fType = new ProblemFunctionType(10005);
            }
        }
        return this.fType;
    }

    @Override
    public boolean isAuto() {
        return false;
    }

    @Override
    public boolean isConstexpr() {
        return PDOMCPPAnnotations.isConstexpr(this.getAnnotations());
    }

    @Override
    public boolean isExtern() {
        return PDOMCPPAnnotations.isExtern(this.getAnnotations());
    }

    @Override
    public boolean isExternC() {
        return PDOMCPPAnnotations.isExternC(this.getAnnotations());
    }

    @Override
    public boolean isRegister() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return PDOMCPPAnnotations.isStatic(this.getAnnotations());
    }

    @Override
    public boolean takesVarArgs() {
        return PDOMCPPAnnotations.isVarargsFunction(this.getAnnotations());
    }

    @Override
    public boolean isNoReturn() {
        return PDOMCPPAnnotations.isNoReturnFunction(this.getAnnotations());
    }

    @Override
    public int getRequiredArgumentCount() {
        if (this.fRequiredArgCount == -1) {
            try {
                this.fRequiredArgCount = this.getDB().getShort(this.record + 64L);
            }
            catch (CoreException e) {
                this.fRequiredArgCount = 0;
            }
        }
        return this.fRequiredArgCount;
    }

    @Override
    public boolean hasParameterPack() {
        return PDOMCPPAnnotations.hasParameterPack(this.getAnnotations());
    }

    @Override
    public boolean isDeleted() {
        return PDOMCPPAnnotations.isDeletedFunction(this.getAnnotations());
    }

    @Override
    public int pdomCompareTo(PDOMBinding other) {
        int cmp = super.pdomCompareTo(other);
        return cmp == 0 ? PDOMCPPFunction.compareSignatures(this, other) : cmp;
    }

    @Override
    public IType[] getExceptionSpecification() {
        try {
            long rec = this.getPDOM().getDB().getRecPtr(this.record + 58L);
            return PDOMCPPTypeList.getTypes(this, rec);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public ICPPExecution getFunctionBodyExecution() {
        if (!this.isConstexpr()) {
            return null;
        }
        try {
            ICPPExecution exec = ((PDOMLinkage)this.getLinkage()).loadExecution(this.record + 66L);
            if (exec == null) {
                exec = CPPTemplates.instantiateFunctionBody(this);
            }
            return exec;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public boolean isNoDiscard() {
        return PDOMCPPAnnotations.isNoDiscardFunction(this.getAnnotations());
    }
}

