/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.ui;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCommandGenerator;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class LibrariesCommandGenerator
implements IOptionCommandGenerator {
    private static final String GROUP_LIBRARIES_COMMAND_FORMAT = "-Wl,--start-group %s -Wl,--end-group";
    private final String fGroupLibrariesOptionId;

    protected LibrariesCommandGenerator(String groupLibrariesOptionId) {
        this.fGroupLibrariesOptionId = groupLibrariesOptionId;
    }

    public String generateCommand(IOption option, IVariableSubstitutor macroSubstitutor) {
        IOption groupOption = option.getOptionHolder().getOptionBySuperClassId(this.fGroupLibrariesOptionId);
        try {
            if (groupOption != null && groupOption.getBooleanValue()) {
                String command = option.getCommand();
                String libraries = Arrays.stream(option.getLibraries()).map(lib -> String.valueOf(command) + lib).collect(Collectors.joining(" "));
                if (!libraries.isEmpty()) {
                    libraries = CdtVariableResolver.resolveToString((String)libraries, (IVariableSubstitutor)macroSubstitutor);
                    return String.format(GROUP_LIBRARIES_COMMAND_FORMAT, libraries);
                }
            }
        }
        catch (CdtVariableException | BuildException e) {
            Platform.getLog(this.getClass()).log(Status.error((String)"Error generating libraries command", (Throwable)e));
        }
        return null;
    }
}

