/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.repositories.wizards;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import org.eclipse.emf.cdo.admin.CDOAdminClient;
import org.eclipse.emf.cdo.admin.CDOAdminClientManager;
import org.eclipse.emf.cdo.admin.CDOAdminClientRepository;
import org.eclipse.emf.cdo.admin.CDOAdminClientUtil;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.AbstractRepositoryPage;
import org.eclipse.emf.cdo.internal.ui.ViewerUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.DelayingExecutor;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MasterRepositoryController {
    private static final Image REPOSITORY_IMAGE = OM.getImage("icons/repository.gif");
    private static final Image EMPTY_IMAGE = OM.getImage("icons/empty.gif");
    private static final Image OK_IMAGE = OM.getImage("icons/ok.gif");
    private static final Image ERROR_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
    private static final int VALIDATING_WIDTH = 120;
    private static final int ADDRESS_VALIDATION_DELAY = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.explorer.ui.repositories.wizards.MasterRepositoryController.ADDRESS_VALIDATION_DELAY", 400);
    private static final int REPOSITORY_VALIDATION_DELAY = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.explorer.ui.repositories.wizards.MasterRepositoryController.REPOSITORY_VALIDATION_DELAY", 1000);
    private static final String CONNECTOR_TYPE = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.explorer.ui.repositories.wizards.MasterRepositoryController.CONNECTOR_TYPE", "tcp");
    private static final String DEFAULT_HOST = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.explorer.ui.repositories.wizards.MasterRepositoryController.DEFAULT_HOST", "localhost");
    private static final String DEFAULT_PORT = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.explorer.ui.repositories.wizards.MasterRepositoryController.DEFAULT_PORT", "2036");
    private final DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            MasterRepositoryController.this.dispose();
        }
    };
    private IListener adminListener = new IListener(){

        public void notifyEvent(IEvent event) {
            ViewerUtil.refresh((StructuredViewer)MasterRepositoryController.this.repositoryTableViewer, null);
        }
    };
    private IListener adminManagerListener = new ContainerEventAdapter<CDOAdminClient>(){

        protected void onAdded(IContainer<CDOAdminClient> container, CDOAdminClient admin) {
            admin.addListener(MasterRepositoryController.this.adminListener);
        }

        protected void onRemoved(IContainer<CDOAdminClient> container, CDOAdminClient admin) {
            admin.removeListener(MasterRepositoryController.this.adminListener);
        }
    };
    private CDOAdminClientManager adminManager;
    private IManagedContainer container;
    private Composite parent;
    private Text hostText;
    private ValidatingText portText;
    private TableViewer repositoryTableViewer;
    private ValidatingText repositoryNameText;
    private Label userNameLabel;
    private Text userNameText;
    private Label passwordLabel;
    private Text passwordText;
    private String connectorDescription;
    private String repositoryName;
    private String userName;
    private String password;
    private boolean authenticating;
    private CDORepository.VersioningMode versioningMode;
    private CDORepository.IDGeneration idGeneration;

    public MasterRepositoryController(Composite parent) {
        this.parent = parent;
        this.container = ContainerUtil.createPluginContainer();
        LifecycleUtil.activate((Object)this.container);
        this.adminManager = CDOAdminClientUtil.createAdminManager((IManagedContainer)this.container);
        this.adminManager.addListener(this.adminManagerListener);
        LifecycleUtil.activate((Object)this.adminManager);
        AbstractRepositoryPage.createLabel(parent, "Host:");
        this.hostText = new Text(parent, 2048);
        this.hostText.setText(DEFAULT_HOST);
        this.hostText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        AbstractRepositoryPage.createLabel(parent, "Port:");
        this.portText = new AddressValidatingText(parent);
        this.portText.setText(DEFAULT_PORT);
        this.hostText.addModifyListener((ModifyListener)this.portText);
        AbstractRepositoryPage.createLabel(parent, "Repositories:");
        this.repositoryTableViewer = new TableViewer(parent, 2052);
        this.repositoryTableViewer.setContentProvider((IContentProvider)new AdminContentProvider());
        this.repositoryTableViewer.setLabelProvider((IBaseLabelProvider)new AdminLabelProvider());
        this.repositoryTableViewer.setInput((Object)this.adminManager);
        this.repositoryTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.repositoryTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                CDOAdminClientRepository adminRepository = (CDOAdminClientRepository)selection.getFirstElement();
                if (adminRepository != null) {
                    MasterRepositoryController.this.repositoryNameText.setText(adminRepository.getName());
                    MasterRepositoryController.this.repositoryNameText.modifyText(false);
                }
            }
        });
        AbstractRepositoryPage.createLabel(parent, "Repository name:");
        this.repositoryNameText = new RepositoryValidatingText(parent);
        this.userNameLabel = AbstractRepositoryPage.createLabel(parent, "User name:");
        this.userNameText = new Text(parent, 2048);
        this.userNameText.setLayoutData((Object)MasterRepositoryController.createWidthGridData());
        this.userNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MasterRepositoryController.this.userName = MasterRepositoryController.this.userNameText.getText();
                MasterRepositoryController.this.repositoryNameText.modifyText(true);
            }
        });
        this.passwordLabel = AbstractRepositoryPage.createLabel(parent, "Password:");
        this.passwordText = new Text(parent, 0x400800);
        this.passwordText.setLayoutData((Object)MasterRepositoryController.createWidthGridData());
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MasterRepositoryController.this.password = MasterRepositoryController.this.passwordText.getText();
                MasterRepositoryController.this.repositoryNameText.modifyText(true);
            }
        });
        this.portText.modifyText(false);
        this.repositoryNameText.modifyText(false);
        parent.addDisposeListener(this.disposeListener);
    }

    public final String getConnectorURL() {
        return this.connectorDescription == null ? null : String.valueOf(CONNECTOR_TYPE) + "://" + this.connectorDescription;
    }

    public final String getConnectorDescription() {
        return this.connectorDescription;
    }

    public final String getRepositoryName() {
        return this.repositoryName;
    }

    public final boolean isAuthenticating() {
        return this.authenticating;
    }

    public final IPasswordCredentials getCredentials() {
        if (this.userNameText.isEnabled() && !StringUtil.isEmpty((String)this.userName)) {
            return new PasswordCredentials(this.userName, this.password);
        }
        return null;
    }

    public final CDORepository.VersioningMode getVersioningMode() {
        return this.versioningMode;
    }

    public final CDORepository.IDGeneration getIDGeneration() {
        return this.idGeneration;
    }

    public final boolean isValid() {
        return this.portText.isValid() && this.repositoryNameText.isValid();
    }

    public void dispose() {
        this.parent.removeDisposeListener(this.disposeListener);
        if (this.container != null) {
            this.repositoryNameText.cancelValidation();
            this.portText.cancelValidation();
            LifecycleUtil.deactivate((Object)this.adminManager);
            this.adminManager = null;
            this.container.deactivate();
            this.container = null;
        }
    }

    protected void validateController() {
        if (this.repositoryNameText != null && !this.repositoryNameText.isDisposed()) {
            this.repositoryName = this.repositoryNameText.getText();
        }
    }

    protected void showCredentials(final boolean show) {
        this.parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!MasterRepositoryController.this.parent.isDisposed()) {
                    MasterRepositoryController.this.userNameLabel.setEnabled(show);
                    MasterRepositoryController.this.userNameText.setEnabled(show);
                    MasterRepositoryController.this.passwordLabel.setEnabled(show);
                    MasterRepositoryController.this.passwordText.setEnabled(show);
                }
            }
        });
    }

    private static GridData createWidthGridData() {
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        gridData.widthHint = 120;
        return gridData;
    }

    private final class AddressValidatingText
    extends ValidatingText {
        public AddressValidatingText(Composite parent) {
            super(parent, ADDRESS_VALIDATION_DELAY);
        }

        @Override
        protected String getValidationInfo() {
            MasterRepositoryController.this.connectorDescription = null;
            String host = MasterRepositoryController.this.hostText.getText();
            if (host.length() == 0) {
                return null;
            }
            String port = this.getText();
            if (port.length() == 0) {
                port = DEFAULT_PORT;
            }
            return String.valueOf(host) + ":" + port;
        }

        @Override
        protected String validate(String validationInfo) throws Exception {
            InetAddress addr;
            String[] tokens = validationInfo.split(":");
            String host = tokens[0];
            String port = tokens[1];
            try {
                addr = InetAddress.getByName(host);
            }
            catch (Exception ex) {
                throw new Exception("Unknown host");
            }
            try {
                new InetSocketAddress(addr, Integer.parseInt(port));
            }
            catch (IllegalArgumentException ex) {
                throw new Exception("Invalid port");
            }
            MasterRepositoryController.this.connectorDescription = validationInfo;
            return "Valid address";
        }

        @Override
        protected void finished(boolean valid) {
            MasterRepositoryController.this.repositoryNameText.modifyText(false);
            if (valid && MasterRepositoryController.this.connectorDescription != null) {
                String url = MasterRepositoryController.this.getConnectorURL();
                MasterRepositoryController.this.adminManager.setConnection(url);
            }
            ViewerUtil.refresh((StructuredViewer)MasterRepositoryController.this.repositoryTableViewer, null);
        }
    }

    private final class AdminContentProvider
    implements IStructuredContentProvider {
        private AdminContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            String url;
            CDOAdminClient admin;
            if (MasterRepositoryController.this.connectorDescription != null && (admin = MasterRepositoryController.this.adminManager.getConnection(url = MasterRepositoryController.this.getConnectorURL())) != null) {
                return admin.getRepositories();
            }
            return ContainerItemProvider.NO_ELEMENTS;
        }
    }

    private final class AdminLabelProvider
    extends LabelProvider {
        private AdminLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof CDOAdminClientRepository) {
                return REPOSITORY_IMAGE;
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof CDOAdminClientRepository) {
                CDOAdminClientRepository adminRepository = (CDOAdminClientRepository)element;
                return adminRepository.getName();
            }
            return super.getText(element);
        }
    }

    private final class RepositoryValidatingText
    extends ValidatingText {
        public RepositoryValidatingText(Composite parent) {
            super(parent, REPOSITORY_VALIDATION_DELAY);
        }

        @Override
        protected String getValidationInfo() {
            if (MasterRepositoryController.this.connectorDescription == null) {
                return null;
            }
            String repositoryName = this.getText();
            if (repositoryName.length() == 0) {
                return null;
            }
            return repositoryName;
        }

        /*
         * Exception decompiling
         */
        @Override
        protected String validate(String repositoryName) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private IConnector getConnector() throws Exception {
            IConnector connector = null;
            try {
                connector = Net4jUtil.getConnector((IManagedContainer)MasterRepositoryController.this.container, (String)CONNECTOR_TYPE, (String)MasterRepositoryController.this.connectorDescription);
            }
            catch (Exception ex) {
                connector = null;
            }
            if (connector == null) {
                throw new Exception("Host unreachable");
            }
            return connector;
        }
    }

    private abstract class ValidatingText
    extends Composite
    implements ModifyListener {
        private final Text text;
        private final Label imageLabel;
        private final Label statusLabel;
        private final DelayingExecutor validator;
        private boolean valid;

        public ValidatingText(Composite parent, int validationDelay) {
            super(parent, 0);
            if (validationDelay >= 0) {
                final ExecutorService threadPool = ConcurrencyUtil.getExecutorService((IManagedContainer)MasterRepositoryController.this.container);
                this.validator = new DelayingExecutor(validationDelay){

                    protected void doExecute(Runnable runnable) {
                        threadPool.execute(runnable);
                    }
                };
                threadPool.execute((Runnable)this.validator);
            } else {
                this.validator = null;
            }
            this.setLayoutData(new GridData(4, 0x1000000, true, false));
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.setLayout((Layout)layout);
            this.text = new Text((Composite)this, 2048);
            this.text.setLayoutData((Object)MasterRepositoryController.createWidthGridData());
            this.text.addModifyListener((ModifyListener)this);
            this.imageLabel = new Label((Composite)this, 0);
            this.statusLabel = new Label((Composite)this, 0);
            this.statusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }

        public final String getText() {
            return this.text.getText();
        }

        public final void setText(String text) {
            this.text.setText(text);
        }

        public final boolean isValid() {
            return this.valid;
        }

        public void cancelValidation() {
            this.valid = false;
            if (this.validator != null) {
                this.validator.stop();
            }
        }

        public void modifyText(ModifyEvent e) {
            this.modifyText(true);
        }

        public void modifyText(boolean delay) {
            MasterRepositoryController.this.validateController();
            if (this.validator != null) {
                this.imageLabel.setImage(EMPTY_IMAGE);
                this.statusLabel.setText("");
                String validationInfo = this.getValidationInfo();
                if (validationInfo != null) {
                    this.validator.execute(() -> {
                        this.updateLabels(null, false);
                        String message = null;
                        this.valid = false;
                        try {
                            message = this.validate(validationInfo);
                            this.valid = true;
                        }
                        catch (Exception ex) {
                            message = ex.getMessage();
                        }
                        this.updateLabels(message, this.valid);
                    });
                } else {
                    this.finished(false);
                }
            }
        }

        protected abstract String getValidationInfo();

        protected abstract String validate(String var1) throws Exception;

        protected void finished(boolean valid) {
        }

        private void updateLabels(final String message, final boolean valid) {
            Display display = MasterRepositoryController.this.parent.getDisplay();
            if (!MasterRepositoryController.this.parent.isDisposed()) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (message != null) {
                                ValidatingText.this.imageLabel.setImage(valid ? OK_IMAGE : ERROR_IMAGE);
                                ValidatingText.this.statusLabel.setText(message);
                                ValidatingText.this.finished(valid);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        MasterRepositoryController.this.validateController();
                    }
                });
            }
        }
    }
}

