/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.help.internal.search.HTMLDocParser;
import org.eclipse.help.internal.webapp.servlet.ChildLinkInserter;

public class PluginsRootResolvingStream
extends OutputStream {
    protected OutputStream out;
    private int state = 0;
    private int charsMatched = 0;
    private int lastKeywordMatch = 0;
    private static final int INITIAL_STATE = 0;
    private static final int IN_TAG = 1;
    private static final int IN_QUOTE = 2;
    private static final int IN_QUOTE_NOT_PLUGINS_ROOT = 3;
    private static final int MAY_BE_INCLUDE = 4;
    private static final int IN_METATAG = 5;
    private static final String PLUGINS_ROOT = "PLUGINS_ROOT/";
    private static final String INSERT_CHILD_LINKS = "<!--INSERT_CHILD_LINKS-->";
    private static final String INSERT_CHILD_LINK_STYLE = "<!--INSERT_CHILD_LINK_STYLE-->";
    private final String[] keywords = new String[]{"<!--INSERT_CHILD_LINKS-->", "<!--INSERT_CHILD_LINK_STYLE-->"};
    private boolean[] possibleKeywordMatches;
    private final String pathPrefix;
    private StringBuilder tag;
    private ByteArrayOutputStream metaTagBuffer;
    private boolean tagRead;
    private final HttpServletRequest req;
    private String charset;

    public PluginsRootResolvingStream(OutputStream out, HttpServletRequest req, String prefix) {
        this.out = out;
        this.pathPrefix = prefix;
        this.req = req;
    }

    @Override
    public void write(int b) throws IOException {
        switch (this.state) {
            case 0: {
                if (b == 60) {
                    this.state = 1;
                    this.charsMatched = 0;
                    this.tag = new StringBuilder();
                    this.tagRead = false;
                    break;
                }
                this.out.write(b);
                break;
            }
            case 1: {
                if (this.charsMatched == 0) {
                    if (b == 33) {
                        this.state = 4;
                        this.possibleKeywordMatches = new boolean[this.keywords.length];
                        int i = 0;
                        while (i < this.possibleKeywordMatches.length) {
                            this.possibleKeywordMatches[i] = true;
                            ++i;
                        }
                        this.charsMatched = 2;
                        this.lastKeywordMatch = 0;
                        break;
                    }
                    this.out.write(60);
                }
                if (b == 62) {
                    this.state = 0;
                } else if (b == 34) {
                    this.state = 2;
                    this.charsMatched = 0;
                } else {
                    ++this.charsMatched;
                    if (!this.tagRead && b >= 0 && b < 128 && this.tag.length() < 20) {
                        char c = (char)b;
                        if (Character.isLetter(c)) {
                            this.tag.append(c);
                        } else if (Character.isWhitespace(c)) {
                            this.tagRead = true;
                            if (this.tag.toString().equalsIgnoreCase("meta")) {
                                this.state = 5;
                                this.metaTagBuffer = new ByteArrayOutputStream(7);
                                this.metaTagBuffer.write("<meta ".getBytes());
                            }
                        } else {
                            this.tag.append(c);
                        }
                    }
                }
                this.out.write(b);
                break;
            }
            case 3: {
                if (b == 62) {
                    this.state = 0;
                } else if (b == 34) {
                    this.state = 1;
                    this.charsMatched = 1;
                }
                this.out.write(b);
                break;
            }
            case 2: {
                if (b == PLUGINS_ROOT.charAt(this.charsMatched)) {
                    ++this.charsMatched;
                    if (this.charsMatched != PLUGINS_ROOT.length()) break;
                    this.out.write(this.pathPrefix.getBytes());
                    this.state = 3;
                    break;
                }
                this.state = 3;
                this.flushPluginsRootCharacters();
                this.out.write(b);
                break;
            }
            case 4: {
                boolean canStillMatch = false;
                int perfectMatch = -1;
                int i = 0;
                while (i < this.keywords.length) {
                    if (this.possibleKeywordMatches[i]) {
                        if (this.keywords[i].charAt(this.charsMatched) == b) {
                            canStillMatch = true;
                            this.lastKeywordMatch = i;
                            if (this.keywords[i].length() == this.charsMatched + 1) {
                                perfectMatch = i;
                            }
                        } else {
                            this.possibleKeywordMatches[i] = false;
                        }
                    }
                    ++i;
                }
                if (perfectMatch != -1) {
                    this.insertBasedOnKeyword(perfectMatch);
                    this.state = 0;
                    break;
                }
                if (canStillMatch) {
                    ++this.charsMatched;
                    break;
                }
                this.state = 0;
                this.flushKeywordCharacters();
                this.out.write(b);
                break;
            }
            case 5: {
                this.out.write(b);
                this.metaTagBuffer.write(b);
                if (b != 62) break;
                this.parseMetaTag(this.metaTagBuffer);
                this.metaTagBuffer = null;
                this.state = 0;
                break;
            }
            default: {
                this.out.write(b);
            }
        }
    }

    private void parseMetaTag(ByteArrayOutputStream buffer) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ByteArrayInputStream is = new ByteArrayInputStream(buffer.toByteArray());){
                String value = HTMLDocParser.getCharsetFromHTML((InputStream)is);
                if (value != null) {
                    this.charset = value;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    protected void insertBasedOnKeyword(int index) throws IOException {
        if (index == 0) {
            ChildLinkInserter inserter = new ChildLinkInserter(this.req, this.out);
            inserter.addContents(this.getCharset());
        } else {
            ChildLinkInserter inserter = new ChildLinkInserter(this.req, this.out);
            inserter.addStyle();
        }
    }

    private void flushPluginsRootCharacters() throws IOException {
        this.out.write(PLUGINS_ROOT.substring(0, this.charsMatched).getBytes(StandardCharsets.UTF_8));
    }

    private void flushKeywordCharacters() throws IOException {
        String matchingCharacters = this.keywords[this.lastKeywordMatch].substring(0, this.charsMatched);
        this.out.write(matchingCharacters.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void close() throws IOException {
        if (this.state == 2) {
            this.flushPluginsRootCharacters();
        } else if (this.state == 4) {
            this.flushKeywordCharacters();
        }
        this.out.close();
        super.close();
    }

    public String getCharset() {
        return this.charset;
    }
}

