/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.swt.widgets.Display;

public class DockerImagesContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];
    private TableViewer viewer;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TableViewer)viewer;
    }

    /*
     * WARNING - void declaration
     */
    public Object[] getElements(Object inputElement) {
        Object object = inputElement;
        if (object instanceof IDockerConnection) {
            void connection;
            IDockerConnection iDockerConnection = (IDockerConnection)object;
            IDockerConnection cfr_ignored_0 = (IDockerConnection)object;
            if (connection.isImagesLoaded()) {
                List images = connection.getImages();
                if (images == null) {
                    return EMPTY;
                }
                return images.toArray();
            }
            this.loadImages((IDockerConnection)connection);
            return EMPTY;
        }
        return EMPTY;
    }

    private void loadImages(final IDockerConnection connection) {
        Job loadImagesJob = new Job(DVMessages.getFormattedString("ImagesLoadJob.msg", connection.getUri())){

            protected IStatus run(IProgressMonitor monitor) {
                connection.getImages(true);
                Display.getDefault().asyncExec(() -> DockerImagesContentProvider.this.viewer.refresh());
                return Status.OK_STATUS;
            }
        };
        loadImagesJob.schedule();
    }

    public Object[] getChildren(Object parentElement) {
        return this.getElements(parentElement);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }
}

