/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.cli.configuration.SettingsXmlConfigurationProcessor;
import org.apache.maven.eventspy.internal.EventSpyDispatcher;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.lifecycle.internal.MojoExecutor;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.session.scope.internal.SessionScope;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IComponentLookup;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.embedder.ArtifactTransferListenerAdapter;
import org.eclipse.m2e.core.internal.embedder.FilterRepositorySystemSession;
import org.eclipse.m2e.core.internal.embedder.MavenProjectMutableState;
import org.eclipse.m2e.core.internal.embedder.MavenProperties;
import org.eclipse.m2e.core.internal.embedder.ReadonlyMavenExecutionRequest;

public class MavenExecutionContext
implements IMavenExecutionContext {
    private static final String CTX_PREFIX = MavenExecutionContext.class.getName();
    private static final String CTX_LOCALREPOSITORY = String.valueOf(CTX_PREFIX) + "/localRepository";
    private static final String CTX_MAVENSESSION = String.valueOf(CTX_PREFIX) + "/mavenSession";
    private static final String CTX_REPOSITORYSESSION = String.valueOf(CTX_PREFIX) + "/repositorySession";
    private static final ThreadLocal<Deque<MavenExecutionContext>> threadLocal = new ThreadLocal();
    private MavenExecutionRequest request;
    private Map<String, Object> context;
    private final File basedir;
    private final Function<? super MavenExecutionContext, MavenProject> projectSupplier;
    private final IComponentLookup containerLookup;
    private File multiModuleProjectDirectory;

    public MavenExecutionContext(IComponentLookup lookup, File baseDir, Function<? super MavenExecutionContext, MavenProject> projectSupplier) {
        this(lookup, baseDir, MavenProperties.computeMultiModuleProjectDirectory(baseDir), projectSupplier);
    }

    public MavenExecutionContext(IComponentLookup lookup, File baseDir, File multiModuleProjectDirectory, Function<? super MavenExecutionContext, MavenProject> projectSupplier) {
        this.multiModuleProjectDirectory = multiModuleProjectDirectory;
        this.containerLookup = Objects.requireNonNull(lookup);
        this.basedir = baseDir;
        this.projectSupplier = projectSupplier;
    }

    @Override
    public MavenExecutionRequest getExecutionRequest() throws CoreException {
        if (this.request != null && this.context != null) {
            return new ReadonlyMavenExecutionRequest(this.request);
        }
        if (this.request == null) {
            this.request = this.newExecutionRequest();
        }
        return this.request;
    }

    protected MavenExecutionRequest newExecutionRequest() throws CoreException {
        MavenExecutionRequest request = null;
        Deque<MavenExecutionContext> stack = threadLocal.get();
        if (stack != null && !stack.isEmpty()) {
            MavenExecutionRequest parent = stack.peek().request;
            if (parent == null) {
                throw new IllegalStateException();
            }
            request = DefaultMavenExecutionRequest.copy((MavenExecutionRequest)parent);
        }
        if (request == null) {
            request = MavenExecutionContext.createExecutionRequest(IMavenConfiguration.getWorkspaceConfiguration(), this.containerLookup, MavenPlugin.getMaven().getSettings());
            request.setBaseDirectory(this.basedir);
        }
        request.setMultiModuleProjectDirectory(this.multiModuleProjectDirectory);
        return request;
    }

    static MavenExecutionRequest createExecutionRequest(IMavenConfiguration mavenConfiguration, IComponentLookup lookup, Settings settings) throws CoreException {
        ArtifactRepository localRepository;
        DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
        if (mavenConfiguration.getGlobalSettingsFile() != null) {
            request.setGlobalSettingsFile(new File(mavenConfiguration.getGlobalSettingsFile()));
        }
        File userSettingsFile = SettingsXmlConfigurationProcessor.DEFAULT_USER_SETTINGS_FILE;
        if (mavenConfiguration.getUserSettingsFile() != null) {
            userSettingsFile = new File(mavenConfiguration.getUserSettingsFile());
        }
        request.setUserSettingsFile(userSettingsFile);
        try {
            request = lookup.lookup(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)request, settings);
        }
        catch (MavenExecutionRequestPopulationException ex) {
            throw new CoreException(Status.error((String)Messages.MavenImpl_error_no_exec_req, (Throwable)ex));
        }
        String localRepositoryPath = settings.getLocalRepository();
        if (localRepositoryPath == null) {
            localRepositoryPath = RepositorySystem.defaultUserLocalRepository.getAbsolutePath();
        }
        try {
            localRepository = lookup.lookup(RepositorySystem.class).createLocalRepository(new File(localRepositoryPath));
        }
        catch (InvalidRepositoryException ex) {
            throw new AssertionError("Should never happen!", ex);
        }
        request.setLocalRepository(localRepository);
        request.setLocalRepositoryPath(localRepository.getBasedir());
        request.setOffline(mavenConfiguration.isOffline());
        request.getUserProperties().put("m2e.version", MavenPluginActivator.getVersion());
        request.getUserProperties().put("aether.connector.userAgent", MavenPluginActivator.getUserAgent());
        MavenExecutionContext.populateSystemProperties((MavenExecutionRequest)request);
        request.setCacheNotFound(true);
        request.setCacheTransferError(true);
        request.setGlobalChecksumPolicy(mavenConfiguration.getGlobalChecksumPolicy());
        return request;
    }

    @Override
    public <V> V execute(ICallable<V> callable, IProgressMonitor monitor) throws CoreException {
        return this.execute(null, callable, monitor);
    }

    @Override
    public <V> V execute(MavenProject project, ICallable<V> callable, IProgressMonitor monitor) throws CoreException {
        IComponentLookup lookup;
        MavenExecutionContext parent;
        Deque<MavenExecutionContext> stack = threadLocal.get();
        if (stack == null) {
            stack = new ArrayDeque<MavenExecutionContext>();
            threadLocal.set(stack);
        }
        if (this == (parent = stack.peek())) {
            return this.executeBare(project, callable, monitor);
        }
        MavenExecutionRequest origRequest = this.request;
        Map<String, Object> origContext = this.context;
        if (this.request == null && parent != null) {
            this.request = parent.request;
            this.context = new HashMap<String, Object>(parent.context);
        } else {
            this.context = new HashMap<String, Object>();
            if (this.request == null) {
                this.request = this.newExecutionRequest();
            }
            lookup = this.getComponentLookup();
            try {
                lookup.lookup(MavenExecutionRequestPopulator.class).populateDefaults(this.request);
            }
            catch (MavenExecutionRequestPopulationException ex) {
                throw new CoreException(Status.error((String)Messages.MavenImpl_error_read_config, (Throwable)ex));
            }
            MavenExecutionContext.populateSystemProperties(this.request);
            this.setValue(CTX_LOCALREPOSITORY, this.request.getLocalRepository());
            FilterRepositorySystemSession repositorySession = MavenExecutionContext.createRepositorySession(this.request, MavenPlugin.getMavenConfiguration(), lookup);
            this.setValue(CTX_REPOSITORYSESSION, repositorySession);
            if (parent != null) {
                repositorySession.setData(parent.getRepositorySession().getData());
            }
            DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
            this.setValue(CTX_MAVENSESSION, new MavenSession(lookup.lookup(PlexusContainer.class), (RepositorySystemSession)repositorySession, this.request, (MavenExecutionResult)result));
        }
        lookup = this.getComponentLookup();
        LegacySupport legacySupport = lookup.lookup(LegacySupport.class);
        MavenSession origLegacySession = legacySupport.getSession();
        stack.push(this);
        MavenSession session = this.getSession();
        legacySupport.setSession(session);
        SessionScope sessionScope = lookup.lookup(SessionScope.class);
        sessionScope.enter();
        sessionScope.seed(MavenSession.class, (Object)session);
        try {
            V v = this.executeBare(project, callable, monitor);
            return v;
        }
        finally {
            sessionScope.exit();
            stack.pop();
            if (stack.isEmpty()) {
                threadLocal.set(null);
            }
            legacySupport.setSession(origLegacySession);
            this.request = origRequest;
            this.context = origContext;
        }
    }

    @Override
    public void execute(MavenProject project, MojoExecution execution, IProgressMonitor monitor) throws CoreException {
        this.execute(project, (IMavenExecutionContext context, IProgressMonitor pm) -> {
            MavenExecutionContext.executeMojo(context.getSession(), execution, context.getComponentLookup());
            return null;
        }, monitor);
    }

    @Override
    public MavenExecutionResult execute(MavenExecutionRequest request) {
        try {
            return this.execute((innerContext, monitor) -> {
                IComponentLookup componentLookup = innerContext.getComponentLookup();
                try (EventSpyDispatcher eventSpyDispatcher = componentLookup.lookup(EventSpyDispatcher.class);){
                    eventSpyDispatcher.onEvent((Object)request);
                    MavenExecutionResult result = componentLookup.lookup(Maven.class).execute(request);
                    eventSpyDispatcher.onEvent((Object)result);
                    MavenExecutionResult mavenExecutionResult = result;
                    return mavenExecutionResult;
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ex) {
            return new DefaultMavenExecutionResult().addException((Throwable)ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void executeMojo(MavenSession session, MojoExecution execution, IComponentLookup lookup) throws CoreException {
        artifacts = new HashMap<MavenProject, LinkedHashSet<E>>();
        snapshots = new HashMap<MavenProject, MavenProjectMutableState>();
        for (MavenProject project : session.getProjects()) {
            artifacts.put(project, new LinkedHashSet<E>(project.getArtifacts()));
            snapshots.put(project, MavenProjectMutableState.takeSnapshot(project));
        }
        clone = MavenExecutionContext.cloneMojoExecution(execution);
        try {
            try {
                currentProject = session.getCurrentProject();
                executionPlanCalculator = lookup.lookup(LifecycleExecutionPlanCalculator.class);
                executionPlanCalculator.setupMojoExecution(session, currentProject, clone);
                mojoExecutor = lookup.lookup(MojoExecutor.class);
                dependencyContext = mojoExecutor.newDependencyContext(session, List.of(clone));
                mojoExecutor.ensureDependenciesAreResolved(clone.getMojoDescriptor(), session, dependencyContext);
                buildPluginManager = lookup.lookup(BuildPluginManager.class);
                buildPluginManager.executeMojo(session, clone);
            }
            catch (Exception ex) {
                throw new CoreException(Status.error((String)("Failed to execute mojo " + clone), (Throwable)ex));
            }
        }
        finally {
            ** for (project : session.getProjects())
        }
lbl-1000:
        // 1 sources

        {
            project.setArtifactFilter(null);
            project.setResolvedArtifacts(null);
            project.setArtifacts((Set)artifacts.get(project));
            snapshot = (MavenProjectMutableState)snapshots.get(project);
            if (snapshot == null) continue;
            snapshot.restore(project);
            continue;
        }
lbl32:
        // 1 sources

    }

    private static MojoExecution cloneMojoExecution(MojoExecution execution) {
        MojoExecution clone = new MojoExecution(execution.getPlugin(), execution.getGoal(), execution.getExecutionId());
        clone.setConfiguration(execution.getConfiguration());
        clone.setLifecyclePhase(execution.getLifecyclePhase());
        execution.getForkedExecutions().forEach((k, v) -> clone.setForkedExecutions(k, v));
        return clone;
    }

    private <V> V executeBare(MavenProject project, ICallable<V> callable, IProgressMonitor monitor) throws CoreException {
        V v;
        MavenSession mavenSession = this.getSession();
        FilterRepositorySystemSession repositorySession = this.getRepositorySession();
        TransferListener origTransferListener = repositorySession.setTransferListener(new ArtifactTransferListenerAdapter(monitor));
        MavenProject origProject = mavenSession.getCurrentProject();
        List origProjects = mavenSession.getProjects();
        List origAllProjects = mavenSession.getAllProjects();
        ClassLoader origTCCL = Thread.currentThread().getContextClassLoader();
        try {
            if (project == null && this.projectSupplier != null) {
                project = this.projectSupplier.apply(this);
            }
            if (project != null) {
                mavenSession.setCurrentProject(project);
                List<MavenProject> projects = Collections.singletonList(project);
                mavenSession.setProjects(projects);
                mavenSession.setAllProjects(projects);
            }
            v = callable.call(this, IProgressMonitor.nullSafe((IProgressMonitor)monitor));
            Thread.currentThread().setContextClassLoader(origTCCL);
            repositorySession.setTransferListener(origTransferListener);
        }
        catch (Throwable throwable) {
            Thread.currentThread().setContextClassLoader(origTCCL);
            repositorySession.setTransferListener(origTransferListener);
            if (project != null) {
                mavenSession.setCurrentProject(origProject);
                mavenSession.setProjects(origProjects != null ? origProjects : Collections.emptyList());
                mavenSession.setAllProjects(origAllProjects != null ? origAllProjects : Collections.emptyList());
            }
            throw throwable;
        }
        if (project != null) {
            mavenSession.setCurrentProject(origProject);
            mavenSession.setProjects(origProjects != null ? origProjects : Collections.emptyList());
            mavenSession.setAllProjects(origAllProjects != null ? origAllProjects : Collections.emptyList());
        }
        return v;
    }

    @Override
    public MavenSession getSession() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return (MavenSession)this.getValue(CTX_MAVENSESSION);
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return (ArtifactRepository)this.getValue(CTX_LOCALREPOSITORY);
    }

    public FilterRepositorySystemSession getRepositorySession() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return (FilterRepositorySystemSession)((Object)this.getValue(CTX_REPOSITORYSESSION));
    }

    public static MavenExecutionContext getThreadContext() {
        return MavenExecutionContext.getThreadContext(true);
    }

    public static MavenExecutionContext getThreadContext(boolean innermost) {
        Deque<MavenExecutionContext> stack = threadLocal.get();
        return stack != null ? (innermost ? stack.peekFirst() : stack.peekLast()) : null;
    }

    public static void populateSystemProperties(MavenExecutionRequest request) {
        if (request.getSystemProperties() == null || request.getSystemProperties().isEmpty()) {
            Properties systemProperties = new Properties();
            EnvironmentUtils.addEnvVars((Properties)systemProperties);
            M2EUtils.copyProperties(systemProperties, System.getProperties());
            MavenProperties.setProperties(systemProperties);
            request.setSystemProperties(systemProperties);
        }
    }

    @Override
    public ProjectBuildingRequest newProjectBuildingRequest() {
        DefaultProjectBuildingRequest projectBuildingRequest = new DefaultProjectBuildingRequest();
        projectBuildingRequest.setLocalRepository(this.getLocalRepository());
        projectBuildingRequest.setRepositorySession((RepositorySystemSession)this.getRepositorySession());
        projectBuildingRequest.setSystemProperties(this.request.getSystemProperties());
        projectBuildingRequest.setUserProperties(this.request.getUserProperties());
        projectBuildingRequest.setRemoteRepositories(this.request.getRemoteRepositories());
        projectBuildingRequest.setPluginArtifactRepositories(this.request.getPluginArtifactRepositories());
        projectBuildingRequest.setActiveProfileIds(this.request.getActiveProfiles());
        projectBuildingRequest.setInactiveProfileIds(this.request.getInactiveProfiles());
        projectBuildingRequest.setProfiles(this.request.getProfiles());
        projectBuildingRequest.setProcessPlugins(true);
        projectBuildingRequest.setBuildStartTime(this.request.getStartTime());
        return projectBuildingRequest;
    }

    public static Deque<MavenExecutionContext> suspend() {
        Deque<MavenExecutionContext> queue = threadLocal.get();
        threadLocal.set(null);
        return queue;
    }

    public static void resume(Deque<MavenExecutionContext> queue) {
        if (threadLocal.get() != null) {
            throw new IllegalStateException();
        }
        threadLocal.set(queue);
    }

    public <T> T getValue(String key) {
        return (T)this.context.get(key);
    }

    public <T> void setValue(String key, T value) {
        this.context.put(key, value);
    }

    @Override
    public IComponentLookup getComponentLookup() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return this.containerLookup;
    }

    static FilterRepositorySystemSession createRepositorySession(MavenExecutionRequest request, IMavenConfiguration configuration, IComponentLookup lookup) throws CoreException {
        DefaultRepositorySystemSession session = (DefaultRepositorySystemSession)((DefaultMaven)lookup.lookup(Maven.class)).newRepositorySession(request);
        String updatePolicy = configuration.getGlobalUpdatePolicy();
        return new FilterRepositorySystemSession(session, request.isUpdateSnapshots() ? null : updatePolicy);
    }
}

