/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.migrator;

import java.util.function.Predicate;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class TaskPredicates {
    private TaskPredicates() {
    }

    public static Predicate<AbstractTaskCategory> containsTask(AbstractTask task) {
        return category -> category.contains(task.getHandleIdentifier());
    }

    public static Predicate<ITask> hasTaskKey(String taskKey) {
        return task -> taskKey.equals(task.getTaskKey());
    }

    public static Predicate<ITask> isTaskForConnector(String kind) {
        return task -> kind.equals(task.getConnectorKind());
    }

    public static Predicate<IRepositoryQuery> isQueryForRepository(TaskRepository repository) {
        return query -> repository.getConnectorKind().equals(query.getConnectorKind()) && repository.getRepositoryUrl().equals(query.getRepositoryUrl());
    }

    public static Predicate<IRepositoryQuery> isQueryForConnector(String kind) {
        return query -> kind.equals(query.getConnectorKind());
    }

    public static Predicate<RepositoryQuery> isSynchronizing() {
        return query -> query.isSynchronizing();
    }

    public static Predicate<AbstractTask> isTaskSynchronizing() {
        return task -> task.isSynchronizing();
    }
}

