/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class JavadocBasher {
    static final boolean fVerbose = false;
    List<String> fBashed = new ArrayList<String>();
    List<String> fUnchanged = new ArrayList<String>();
    List<String> fSkipped = new ArrayList<String>();

    public static void main(String[] args) {
        String workspaceDir = "..";
        String outputDir = "..";
        String[] folders = new String[]{"Eclipse SWT", "Eclipse SWT Accessibility", "Eclipse SWT AWT", "Eclipse SWT Browser", "Eclipse SWT Drag and Drop", "Eclipse SWT Effects", "Eclipse SWT OpenGL", "Eclipse SWT Printing", "Eclipse SWT Program", "Eclipse SWT Theme", "Eclipse SWT WebKit"};
        String sourceSubdir = "win32";
        String[] targetSubdirs = new String[]{"cairo", "cocoa", "emulated", "emulated/bidi", "emulated/coolbar", "emulated/expand", "emulated/taskbar", "emulated/tooltip", "glx", "gtk"};
        System.out.println("==== Start Bashing ====");
        int totalBashed = 0;
        String[] stringArray = targetSubdirs;
        int n = targetSubdirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            String[] stringArray2 = folders;
            int n3 = folders.length;
            int n4 = 0;
            while (n4 < n3) {
                String folder = stringArray2[n4];
                String targetSubdir = folder + "/" + dir;
                File source = new File(workspaceDir + "/org.eclipse.swt/" + folder + "/" + sourceSubdir);
                File target = new File(workspaceDir + "/org.eclipse.swt/" + targetSubdir);
                File out = new File(outputDir + "/org.eclipse.swt/" + targetSubdir);
                JavadocBasher basher = new JavadocBasher();
                System.out.println("\n==== Start Bashing " + targetSubdir);
                basher.bashJavaSourceTree(source, target, out);
                List<String> bashedList = basher.getBashed();
                basher.status("Bashed", bashedList, targetSubdir);
                if (bashedList.size() > 0) {
                    totalBashed += bashedList.size();
                    basher.status("Skipped", basher.getSkipped(), targetSubdir);
                }
                System.out.println("==== Done Bashing " + targetSubdir);
                ++n4;
            }
            ++n2;
        }
        System.out.println("\n==== Done Bashing (Bashed " + totalBashed + " files in total) - Be sure to Refresh (F5) project(s) ====");
    }

    void status(String label, List<String> list, String targetSubdir) {
        int count;
        System.out.println(label + " " + count + ((count = list.size()) == 1 ? " file" : " files") + " in " + targetSubdir + (count > 0 ? ":" : "."));
        if (count > 0) {
            for (String s : list) {
                System.out.println(label + ": " + s);
            }
            System.out.println();
        }
    }

    char[] readFile(File file) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileReader in = new FileReader(file);){
                CharArrayWriter storage = new CharArrayWriter();
                char[] chars = new char[8192];
                int read = in.read(chars);
                while (read > 0) {
                    storage.write(chars, 0, read);
                    storage.flush();
                    read = in.read(chars);
                }
                return storage.toCharArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            System.out.println("*** Could not read " + String.valueOf(file));
            return null;
        }
    }

    void writeFile(char[] contents, File file) {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileWriter out = new FileWriter(file);){
                out.write(contents);
                ((Writer)out).flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            System.out.println("*** Could not write to " + String.valueOf(file));
        }
    }

    void bashJavaSourceTree(File sourceDir, File targetDir, File outDir) {
        if (!sourceDir.exists()) {
            System.out.println("Source: " + String.valueOf(sourceDir) + " was missing");
            return;
        }
        if (!targetDir.exists()) {
            System.out.println("Target: " + String.valueOf(targetDir) + " was missing");
            return;
        }
        String[] list = sourceDir.list();
        if (list != null) {
            int count = list.length;
            int i = 0;
            while (i < count) {
                String filename = list[i];
                if (!(filename.equals("CVS") || filename.equals("internal") || filename.equals("library"))) {
                    File source = new File(sourceDir, filename);
                    File target = new File(targetDir, filename);
                    File out = new File(outDir, filename);
                    if (source.exists() && target.exists()) {
                        if (source.isDirectory()) {
                            if (target.isDirectory()) {
                                this.bashJavaSourceTree(source, target, out);
                            } else {
                                System.out.println("*** " + String.valueOf(target) + " should have been a directory.");
                            }
                        } else if (filename.toLowerCase().endsWith(".java")) {
                            this.bashFile(source, target, out);
                        } else {
                            this.fSkipped.add(String.valueOf(source) + " (not a java file)");
                        }
                    } else if (source.exists()) {
                        this.fSkipped.add(String.valueOf(target) + " (does not exist)");
                    } else {
                        this.fSkipped.add(String.valueOf(source) + " (does not exist)");
                    }
                }
                ++i;
            }
        }
    }

    void bashFile(final File source, final File target, File out) {
        String newContents;
        char[] contents = this.readFile(source);
        if (contents == null) {
            return;
        }
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        final Document sourceDocument = new Document(new String(contents));
        parser.setSource(contents);
        CompilationUnit sourceUnit = (CompilationUnit)parser.createAST(null);
        contents = this.readFile(target);
        if (contents == null) {
            return;
        }
        String targetContents = new String(contents);
        final Document targetDocument = new Document(targetContents);
        parser.setSource(contents);
        CompilationUnit targetUnit = (CompilationUnit)parser.createAST(null);
        final HashMap comments = new HashMap();
        sourceUnit.accept(new ASTVisitor(){
            String prefix = "";

            public boolean visit(Block node) {
                return false;
            }

            public boolean visit(VariableDeclarationFragment node) {
                FieldDeclaration field = (FieldDeclaration)node.getParent();
                int mods = field.getModifiers();
                if (Modifier.isPublic((int)mods) || Modifier.isProtected((int)mods)) {
                    Javadoc javadoc = field.getJavadoc();
                    if (field.fragments().size() > 1 && javadoc != null) {
                        System.err.println("Field declaration with multiple variables is not supported. -> " + String.valueOf(source) + " " + node.getName().getFullyQualifiedName());
                    }
                    try {
                        String key = this.prefix + "." + node.getName().getFullyQualifiedName();
                        comments.put(key, javadoc != null ? sourceDocument.get(javadoc.getStartPosition(), JavadocBasher.this.getJavadocLength(sourceDocument, javadoc)) : "");
                    }
                    catch (BadLocationException badLocationException) {}
                    return true;
                }
                return false;
            }

            public boolean visit(MethodDeclaration node) {
                int mods = node.getModifiers();
                if (Modifier.isPublic((int)mods) || Modifier.isProtected((int)mods)) {
                    Javadoc javadoc = node.getJavadoc();
                    try {
                        String key = this.prefix + "." + node.getName().getFullyQualifiedName();
                        for (SingleVariableDeclaration param : node.parameters()) {
                            key = key + param.getType().toString();
                        }
                        comments.put(key, javadoc != null ? sourceDocument.get(javadoc.getStartPosition(), JavadocBasher.this.getJavadocLength(sourceDocument, javadoc)) : "");
                    }
                    catch (BadLocationException badLocationException) {}
                    return true;
                }
                return false;
            }

            public boolean visit(TypeDeclaration node) {
                int mods = node.getModifiers();
                if (Modifier.isPublic((int)mods) || Modifier.isProtected((int)mods)) {
                    Javadoc javadoc = node.getJavadoc();
                    try {
                        String key = this.prefix + "." + node.getName().getFullyQualifiedName();
                        comments.put(key, javadoc != null ? sourceDocument.get(javadoc.getStartPosition(), JavadocBasher.this.getJavadocLength(sourceDocument, javadoc)) : "");
                    }
                    catch (BadLocationException badLocationException) {}
                    this.prefix = node.getName().getFullyQualifiedName();
                    return true;
                }
                return false;
            }
        });
        final ArrayList edits = new ArrayList();
        targetUnit.accept(new ASTVisitor(){
            String prefix = "";

            public boolean visit(Block node) {
                return false;
            }

            public boolean visit(VariableDeclarationFragment node) {
                FieldDeclaration field = (FieldDeclaration)node.getParent();
                int mods = field.getModifiers();
                if (Modifier.isPublic((int)mods) || Modifier.isProtected((int)mods)) {
                    String key;
                    String newComment;
                    Javadoc javadoc = field.getJavadoc();
                    if (field.fragments().size() > 1 && javadoc != null) {
                        System.err.println("Field declaration with multiple variables is not supported. -> " + String.valueOf(target) + " " + node.getName().getFullyQualifiedName());
                    }
                    if ((newComment = (String)comments.get(key = this.prefix + "." + node.getName().getFullyQualifiedName())) != null) {
                        comments.remove(key);
                        if (javadoc != null) {
                            edits.add(new Edit(javadoc.getStartPosition(), JavadocBasher.this.getJavadocLength(targetDocument, javadoc), newComment));
                        } else {
                            edits.add(new Edit(field.getStartPosition(), 0, newComment));
                        }
                    }
                    return true;
                }
                return false;
            }

            public boolean visit(MethodDeclaration node) {
                int mods = node.getModifiers();
                if (Modifier.isPublic((int)mods) || Modifier.isProtected((int)mods)) {
                    Javadoc javadoc = node.getJavadoc();
                    String key = this.prefix + "." + node.getName().getFullyQualifiedName();
                    for (SingleVariableDeclaration param : node.parameters()) {
                        key = key + param.getType().toString();
                    }
                    String newComment = (String)comments.get(key);
                    if (newComment != null) {
                        comments.remove(key);
                        if (javadoc != null) {
                            edits.add(new Edit(javadoc.getStartPosition(), JavadocBasher.this.getJavadocLength(targetDocument, javadoc), newComment));
                        } else {
                            edits.add(new Edit(node.getStartPosition(), 0, newComment));
                        }
                    }
                    return true;
                }
                return false;
            }

            public boolean visit(TypeDeclaration node) {
                int mods = node.getModifiers();
                if (Modifier.isPublic((int)mods) || Modifier.isProtected((int)mods)) {
                    Javadoc javadoc = node.getJavadoc();
                    String key = this.prefix + "." + node.getName().getFullyQualifiedName();
                    String newComment = (String)comments.get(key);
                    if (newComment != null) {
                        comments.remove(key);
                        if (javadoc != null) {
                            edits.add(new Edit(javadoc.getStartPosition(), JavadocBasher.this.getJavadocLength(targetDocument, javadoc), newComment));
                        } else {
                            edits.add(new Edit(node.getStartPosition(), 0, newComment));
                        }
                    }
                    this.prefix = node.getName().getFullyQualifiedName();
                    return true;
                }
                return false;
            }
        });
        int i = edits.size() - 1;
        while (i >= 0) {
            Edit edit = (Edit)edits.get(i);
            try {
                targetDocument.replace(edit.start, edit.length, edit.text);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            --i;
        }
        if (comments.size() > 0) {
            String[] filter = new String[]{"Color.win32_newDeviceint", "Cursor.win32_newDeviceint", "Device.hPalette", "Font.win32_newDevicelong", "FontData.data", "FontData.win32_newLOGFONTfloat", "FontMetrics.handle", "FontMetrics.win32_newTEXTMETRIC", "GC.win32_newlongGCData", "GC.win32_newDrawableGCData", "Image.win32_newDeviceintlong", "Pattern.handle", "Region.win32_newDeviceint", "Control.handle", "Display.getSystemFont", "Display.msg", "Menu.handle", "Shell.win32_newDisplaylong", "Accessible.internal_WM_GETOBJECTlonglong", "TransferData.result", "TransferData.stgmedium", "TransferData.pIDataObject", "TransferData.formatetc", "Printer.handle", "Printer.checkDevice", "TableDragSourceEffect.dragFinishedDragSourceEvent", "TableDragSourceEffect.dragStartDragSourceEvent", "TableDropTargetEffect.dragOverDropTargetEvent", "TableDropTargetEffect.dragEnterDropTargetEvent", "TableDropTargetEffect.dragLeaveDropTargetEvent", "Transfer.validateObject", "TransferData.result", "TransferData.stgmedium", "TransferData.pIDataObject", "TransferData.formatetc", "TreeDragSourceEffect.dragFinishedDragSourceEvent", "TreeDragSourceEffect.dragStartDragSourceEvent", "TreeDropTargetEffect.dragLeaveDropTargetEvent", "TreeDropTargetEffect.dragEnterDropTargetEvent", "TreeDropTargetEffect.dragOverDropTargetEvent", "Printer.createDeviceData", "Printer.internal_dispose_GClongGCData", "Printer.release", "Printer.destroy", "Image.handle", "Display.getClientArea", "TreeItem.handle"};
            for (Map.Entry entry : comments.entrySet()) {
                String name = (String)entry.getKey();
                if (((String)entry.getValue()).length() <= 0) continue;
                int i2 = 0;
                i2 = 0;
                while (i2 < filter.length) {
                    if (name.equals(filter[i2])) break;
                    ++i2;
                }
                if (i2 < filter.length) continue;
                System.err.println("***No target for " + name);
            }
        }
        if (!targetContents.equals(newContents = targetDocument.get())) {
            if (this.makeDirectory(out.getParentFile())) {
                this.writeFile(newContents.toCharArray(), out);
                this.fBashed.add(target.toString());
            } else {
                System.out.println("*** Could not create " + out.getParent());
            }
        } else {
            this.fUnchanged.add(target.toString());
        }
    }

    int getJavadocLength(Document sourceDocument, Javadoc javadoc) {
        return this.skipWhitespace(sourceDocument, javadoc.getStartPosition() + javadoc.getLength()) - javadoc.getStartPosition();
    }

    int skipWhitespace(Document doc, int offset) {
        try {
            while (Character.isWhitespace(doc.getChar(offset))) {
                ++offset;
            }
        }
        catch (BadLocationException badLocationException) {}
        return offset;
    }

    boolean makeDirectory(File directory) {
        if (directory.exists()) {
            return true;
        }
        return directory.mkdirs();
    }

    List<String> getBashed() {
        return this.fBashed;
    }

    List<String> getUnchanged() {
        return this.fUnchanged;
    }

    List<String> getSkipped() {
        return this.fSkipped;
    }

    public static class Edit {
        int start;
        int length;
        String text;

        public Edit(int start, int length, String text) {
            this.start = start;
            this.length = length;
            this.text = text;
        }
    }
}

