/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.services;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelQueryService;
import org.eclipse.tcf.te.tcf.locator.services.AbstractPeerModelService;

public class PeerModelLookupService
extends AbstractPeerModelService
implements IPeerModelLookupService {
    public PeerModelLookupService(IPeerModel parentModel) {
        super(parentModel);
    }

    @Override
    public IPeerNode lkupPeerModelById(String id) {
        Assert.isNotNull((Object)id);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IPeerNode node = null;
        IPeerNode[] iPeerNodeArray = this.getPeerModel().getPeerNodes();
        int n = iPeerNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPeerNode candidate = iPeerNodeArray[n2];
            IPeer peer = candidate.getPeer();
            if (id.equals(peer.getID())) {
                node = candidate;
                break;
            }
            if (peer.getAttributes().get("remote.id.transient") != null && ((String)peer.getAttributes().get("remote.id.transient")).equals(id)) {
                node = candidate;
                break;
            }
            ++n2;
        }
        return node;
    }

    @Override
    public IPeerNode[] lkupPeerModelByAgentId(String agentId) {
        Assert.isNotNull((Object)agentId);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        ArrayList<IPeerNode> nodes = new ArrayList<IPeerNode>();
        IPeerNode[] iPeerNodeArray = this.getPeerModel().getPeerNodes();
        int n = iPeerNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPeerNode candidate = iPeerNodeArray[n2];
            IPeer peer = candidate.getPeer();
            if (agentId.equals(peer.getAgentID())) {
                nodes.add(candidate);
            }
            ++n2;
        }
        return nodes.toArray(new IPeerNode[nodes.size()]);
    }

    @Override
    public IPeerNode[] lkupPeerModelByName(String name) {
        Assert.isNotNull((Object)name);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        ArrayList<IPeerNode> nodes = new ArrayList<IPeerNode>();
        IPeerNode[] iPeerNodeArray = this.getPeerModel().getPeerNodes();
        int n = iPeerNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPeerNode candidate = iPeerNodeArray[n2];
            IPeer peer = candidate.getPeer();
            if (name.equals(peer.getName())) {
                nodes.add(candidate);
            }
            ++n2;
        }
        return nodes.toArray(new IPeerNode[nodes.size()]);
    }

    @Override
    public IPeerNode[] lkupPeerModelBySupportedServices(String[] expectedLocalServices, String[] expectedRemoteServices) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
        IPeerModel model = this.getPeerModel();
        IPeerModelQueryService queryService = model.getService(IPeerModelQueryService.class);
        ArrayList<IPeerNode> nodes = new ArrayList<IPeerNode>();
        IPeerNode[] iPeerNodeArray = model.getPeerNodes();
        int n = iPeerNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPeerNode candidate = iPeerNodeArray[n2];
            if (queryService != null && (expectedLocalServices == null || queryService.hasLocalService(candidate, expectedLocalServices)) && (expectedRemoteServices == null || queryService.hasRemoteService(candidate, expectedRemoteServices))) {
                nodes.add(candidate);
            }
            ++n2;
        }
        return nodes.toArray(new IPeerNode[nodes.size()]);
    }
}

