/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.markdown.marked;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;

public class RegExp {
    protected @Nullable String source;
    private @Nullable Pattern pattern;

    public RegExp(@Nullable String source) {
        this.source = source;
    }

    public @Nullable Matcher exec(String s) {
        if (this.source == null) {
            return null;
        }
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.source);
        }
        assert (this.pattern != null);
        Matcher matcher = this.pattern.matcher(s);
        if (matcher.find()) {
            return matcher;
        }
        return null;
    }

    public RegExp replace(String name, RegExp val) {
        return this.replace(name, val.source);
    }

    public RegExp replace(@Nullable String name, @Nullable String val) {
        String source = this.source;
        if (name == null) {
            return new RegExp(source);
        }
        if (source != null && val != null) {
            val = val.replaceAll("(^|[^\\[])\\^", "$1");
            this.source = source.replaceFirst(name, Matcher.quoteReplacement(val));
        }
        return this;
    }

    public RegExp replaceAll(String name, RegExp val) {
        return this.replaceAll(name, val.source);
    }

    public RegExp replaceAll(@Nullable String name, @Nullable String val) {
        String source = this.source;
        if (name == null) {
            return new RegExp(source);
        }
        if (source != null && val != null) {
            val = val.replaceAll("(^|[^\\[])\\^", "$1");
            this.source = source.replaceAll(name, Matcher.quoteReplacement(val));
        }
        return this;
    }

    public static final RegExp noop() {
        return new RegExp(null);
    }
}

