/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.handlers;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.BlockIO;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.DiskWriteModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.InputOutputStateProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.IoOperationType;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.Request;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class BlockRqIssueHandler
extends KernelEventHandler {
    private final InputOutputStateProvider fStateProvider;

    public BlockRqIssueHandler(IKernelAnalysisEventLayout layout, InputOutputStateProvider sp) {
        super(layout);
        this.fStateProvider = sp;
    }

    @Override
    public void handleEvent(@NonNull ITmfStateSystemBuilder ss, @NonNull ITmfEvent event) throws AttributeNotFoundException {
        ITmfEventField content = event.getContent();
        long ts = event.getTimestamp().getValue();
        Integer phydisk = ((Long)content.getField(new String[]{this.getLayout().fieldBlockDeviceId()}).getValue()).intValue();
        Long sector = (Long)NonNullUtils.checkNotNull((Object)((Long)content.getField(new String[]{this.getLayout().fieldBlockSector()}).getValue()));
        Integer nrSector = ((Long)content.getField(new String[]{this.getLayout().fieldBlockNrSector()}).getValue()).intValue();
        IoOperationType rwbs = InputOutputStateProvider.getRWBS(content.getField(new String[]{this.getLayout().fieldBlockRwbs()}));
        DiskWriteModel disk = this.fStateProvider.getDisk(phydisk);
        Request request = disk.getWaitingRequest(sector);
        if (request == null) {
            BlockIO bio = new BlockIO(sector, nrSector, disk, rwbs);
            request = new Request(bio);
        }
        request.setNrSector(nrSector);
        request.setType(rwbs);
        disk.issueRequest(ts, request);
    }
}

