/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.IConfigurablePropertyObject;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.jdt.ui.JdtUiUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public final class InnerClassPropertyEditor
extends TextDialogPropertyEditor
implements IConfigurablePropertyObject {
    private Mode m_mode;
    private String m_baseName;
    private String m_className;
    private String m_source;

    /*
     * WARNING - void declaration
     */
    protected String getText(Property property) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        Expression expression = genericProperty.getExpression();
        Expression expression2 = expression;
        if (expression2 instanceof ClassInstanceCreation) {
            void cic;
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expression2;
            ClassInstanceCreation cfr_ignored_0 = (ClassInstanceCreation)expression2;
            if (cic.getAnonymousClassDeclaration() != null) {
                return "<anonymous>";
            }
            return AstNodeUtils.getFullyQualifiedName(expression, false);
        }
        return "<double click>";
    }

    public boolean activate(PropertyTable propertyTable, Property property, Point location) throws Exception {
        if (location == null) {
            this.openClass(property);
        }
        return false;
    }

    protected void openDialog(Property property) throws Exception {
        IJavaProject javaProject;
        GenericProperty genericProperty = (GenericProperty)property;
        JavaInfo javaInfo = genericProperty.getJavaInfo();
        Shell shell = DesignerPlugin.getShell();
        IType type = JdtUiUtils.selectType(shell, javaProject = javaInfo.getEditor().getJavaProject());
        if (type != null) {
            if (Flags.isAbstract((int)type.getFlags())) {
                UiUtils.openError((Shell)shell, (String)ModelMessages.InnerClassPropertyEditor_selectTypeAbstractTitle, (String)ModelMessages.InnerClassPropertyEditor_selectTypeAbstractMessage);
                return;
            }
            String source = InnerClassPropertyEditor.getCreationSource(javaInfo, type);
            genericProperty.setExpression(source, Property.UNKNOWN_VALUE);
        }
    }

    private static String getCreationSource(JavaInfo javaInfo, IType type) {
        String sourceTypeName = type.getFullyQualifiedName().replace('$', '.');
        try {
            ClassLoader classLoader = JavaInfoUtils.getClassLoader(javaInfo);
            Class<?> componentClass = classLoader.loadClass(sourceTypeName);
            Constructor constructor = ReflectionUtils.getShortestConstructor(componentClass);
            return ComponentDescriptionHelper.getDefaultConstructorInvocation(constructor);
        }
        catch (Throwable e) {
            return "new " + sourceTypeName + "()";
        }
    }

    public void doubleClick(Property property, Point location) throws Exception {
        this.openClass(property);
    }

    private void openClass(Property property) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        Expression expression = genericProperty.getExpression();
        if (expression != null) {
            IDesignPageSite site = IDesignPageSite.Helper.getSite((ObjectInfo)genericProperty.getJavaInfo());
            if (site != null) {
                site.openSourcePosition(expression.getStartPosition());
            }
        } else {
            switch (this.m_mode) {
                case ANONYMOUS: {
                    this.newClass_ANONYMOUS(genericProperty);
                    break;
                }
                case INNER: {
                    this.newClass_INNER(genericProperty);
                }
            }
            this.openClass(property);
        }
    }

    private void newClass_ANONYMOUS(GenericProperty genericProperty) throws Exception {
        JavaInfo javaInfo = genericProperty.getJavaInfo();
        String source = TemplateUtils.evaluate(this.m_source, javaInfo, Collections.emptyMap());
        genericProperty.setExpression(source, Property.UNKNOWN_VALUE);
    }

    private void newClass_INNER(GenericProperty genericProperty) throws Exception {
        JavaInfo javaInfo = genericProperty.getJavaInfo();
        AstEditor editor = javaInfo.getEditor();
        String newName = editor.getUniqueTypeName(this.m_baseName);
        String newSource = TemplateUtils.evaluate(this.m_source, javaInfo, Map.of("name", newName));
        List<String> newLines = List.of(StringUtils.split((String)newSource, (String)"\r\n"));
        TypeDeclaration targetType = JavaInfoUtils.getTypeDeclaration(javaInfo);
        editor.addTypeDeclaration(newLines, new BodyDeclarationTarget(targetType, true));
        genericProperty.setExpression("new " + newName + "()", Property.UNKNOWN_VALUE);
    }

    @Override
    public void configure(EditorState state, Map<String, Object> parameters) throws Exception {
        String modeText = (String)parameters.get("mode");
        Assert.isNotNull((Object)modeText, (String)"'mode' attribute required.");
        modeText = modeText.toUpperCase(Locale.ENGLISH);
        this.m_mode = Mode.valueOf(modeText);
        Assert.isNotNull((Object)((Object)this.m_mode), (String)"Invalid value for 'mode' attribute. Only 'anonymous' or 'inner' supported.");
        if (this.m_mode != Mode.ANONYMOUS) {
            this.m_baseName = (String)parameters.get("name");
            Assert.isNotNull((Object)this.m_baseName, (String)"'name' attribute required.");
        }
        this.m_className = (String)parameters.get("class");
        Assert.isNotNull((Object)this.m_className, (String)"'class' attribute required.");
        this.m_source = (String)parameters.get("source");
        Assert.isNotNull((Object)this.m_source, (String)"'source' attribute required.");
        this.m_source = this.m_source.trim();
    }

    private static enum Mode {
        INNER,
        ANONYMOUS;

    }
}

