/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.binding.BindingContext;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;

public final class AstParser {
    public static final String KEY_TYPE_BINDING = "TYPE_BINDING";
    public static final String KEY_METHOD_BINDING = "METHOD_BINDING";
    public static final String KEY_VARIABLE_BINDING = "VARIABLE_BINDING";
    public static final String KEY_IGNORE_THIS_METHOD = "Ignore this method for parsing context";
    private final AstEditor m_editor;
    private final BindingContext m_context;

    AstParser(AstEditor editor) {
        this.m_editor = editor;
        this.m_context = this.m_editor.getBindingContext();
    }

    public Expression parseExpression(int position, String src) throws Exception {
        if ("null".equals(src)) {
            NullLiteral expression = this.getAst().newNullLiteral();
            expression.setSourceRange(position, "null".length());
            return expression;
        }
        String source = "java.lang.System.out.println(" + src + ");";
        ExpressionStatement statement = (ExpressionStatement)this.parseStatement(position, source);
        MethodInvocation invocation = (MethodInvocation)statement.getExpression();
        Expression expression = (Expression)invocation.arguments().get(0);
        SimpleName fakeExpression = this.getAst().newSimpleName("foo");
        DomGenerics.arguments(invocation).set(0, (Expression)fakeExpression);
        AstNodeUtils.moveNode((ASTNode)expression, position);
        return expression;
    }

    public Statement parseStatement(int position, String src) throws Exception {
        Object source = "";
        source = (String)source + this.getSourceUnitHeader();
        TypeDeclaration typeDeclaration = this.m_editor.getEnclosingType(position);
        source = (String)source + this.getClassDeclarationHeader(typeDeclaration);
        source = (String)source + this.getOpenConstructorSource(typeDeclaration);
        source = (String)source + this.getVisibleVariablesCode(position);
        String anonymousClassSource = this.getAnonymousClassCode(position);
        source = (String)source + anonymousClassSource;
        int statementPosition = ((String)source).length();
        source = (String)source + src;
        if (!StringUtils.isEmpty((String)anonymousClassSource)) {
            source = (String)source + "}};\n";
        }
        source = (String)source + "}\n";
        source = (String)source + "}";
        try {
            return (Statement)this.findNode((String)source, position, Statement.class, statementPosition);
        }
        catch (DesignerException e) {
            String problems = e.getParameters()[1];
            throw new DesignerException(205, (Throwable)e, new String[]{src, problems});
        }
    }

    public BodyDeclaration parseBodyDeclaration(int position, String src) throws Exception {
        Object source = this.m_editor.getSource();
        source = ((String)source).substring(0, position) + src + ((String)source).substring(position);
        try {
            return (BodyDeclaration)this.findNode((String)source, position, BodyDeclaration.class, position);
        }
        catch (DesignerException e) {
            String problems = e.getParameters()[1];
            throw new DesignerException(205, (Throwable)e, new String[]{src, problems});
        }
    }

    public ImportDeclaration parseImportDeclaration(int position, String qualifiedName) throws Exception {
        String source = "import " + qualifiedName + ";";
        source = source + "class Clazz {}";
        return (ImportDeclaration)this.findNode(source, position, ImportDeclaration.class, 0);
    }

    public Type parseQualifiedType(int position, String name) throws Exception {
        VariableDeclarationStatement statement = (VariableDeclarationStatement)this.parseStatement(position, name + " __parseName;");
        Type type = statement.getType();
        statement.setType((Type)type.getAST().newPrimitiveType(PrimitiveType.VOID));
        return type;
    }

    /*
     * WARNING - void declaration
     */
    public Type parseType(int position, Type sourceType) throws Exception {
        PrimitiveType newType;
        Type type = sourceType;
        if (type instanceof PrimitiveType) {
            void primitiveSourceType;
            PrimitiveType primitiveType = (PrimitiveType)type;
            PrimitiveType cfr_ignored_0 = (PrimitiveType)type;
            newType = this.getAst().newPrimitiveType(primitiveSourceType.getPrimitiveTypeCode());
            newType.setSourceRange(position, newType.toString().length());
        } else {
            String typeString = this.m_editor.getSource((ASTNode)sourceType);
            Object newTypeName = typeString.indexOf(46) == -1 ? this.parseSimpleName(position, typeString) : this.parseQualifiedName(position, typeString);
            newType = this.getAst().newSimpleType((Name)newTypeName);
            AstNodeUtils.copySourceRange((ASTNode)newType, (ASTNode)newTypeName);
        }
        ITypeBinding sourceTypeBinding = AstNodeUtils.getTypeBinding(sourceType);
        ITypeBinding newTypeBinding = this.m_context.get(sourceTypeBinding);
        newType.setProperty(KEY_TYPE_BINDING, (Object)newTypeBinding);
        return newType;
    }

    public SimpleName parseSimpleName(int position, String identifier) {
        SimpleName simpleName = this.getAst().newSimpleName(identifier);
        simpleName.setSourceRange(position, identifier.length());
        return simpleName;
    }

    public QualifiedName parseQualifiedName(int startPosition, String src) {
        String[] parts = StringUtils.split((String)src, (char)'.');
        Assert.isTrue((parts.length >= 2 ? 1 : 0) != 0);
        Object result = null;
        int currentPosition = startPosition;
        int i = 0;
        while (i < parts.length) {
            String part = parts[i];
            result = result == null ? this.parseSimpleName(currentPosition, part) : this.getAst().newQualifiedName((Name)result, this.parseSimpleName(++currentPosition, part));
            result.setSourceRange(startPosition, (currentPosition += part.length()) - startPosition);
            ++i;
        }
        return (QualifiedName)result;
    }

    public SimpleName parseVariable(int position, String identifier, ITypeBinding declaringClass, ITypeBinding type, boolean field, int modifiers) {
        SimpleName simpleName = this.parseSimpleName(position, identifier);
        simpleName.setProperty(KEY_TYPE_BINDING, (Object)this.m_context.get(type));
        simpleName.setProperty(KEY_VARIABLE_BINDING, (Object)this.m_context.get(identifier, declaringClass, type, field, modifiers));
        return simpleName;
    }

    public SimpleType parseSimpleType(int position, String identifier, ITypeBinding binding) {
        SimpleName simpleName = this.parseSimpleName(position, identifier);
        SimpleType simpleType = this.getAst().newSimpleType((Name)simpleName);
        simpleType.setProperty(KEY_TYPE_BINDING, (Object)this.m_context.get(binding));
        AstNodeUtils.copySourceRange((ASTNode)simpleType, (ASTNode)simpleName);
        return simpleType;
    }

    private String getSourceUnitHeader() throws Exception {
        CompilationUnit unit = this.m_editor.getAstUnit();
        Object header = "";
        if (unit.getPackage() != null) {
            header = "package " + unit.getPackage().getName().toString() + ";\n";
        }
        for (ImportDeclaration declaration : DomGenerics.imports(unit)) {
            header = (String)header + this.m_editor.getSource((ASTNode)declaration) + "\n";
        }
        return header;
    }

    private String getClassDeclarationHeader(TypeDeclaration typeDeclaration) {
        TypeDeclaration[] innerTypes;
        Object source = "";
        ITypeBinding binding = AstNodeUtils.getTypeBinding(typeDeclaration);
        if (binding.isInterface()) {
            source = (String)source + "interface ";
        } else {
            if (AstNodeUtils.isAbstract(binding)) {
                source = (String)source + "abstract ";
            }
            source = (String)source + "class ";
        }
        int nameBegin = AstNodeUtils.getSourceBegin((ASTNode)typeDeclaration.getName());
        int openBrace = this.m_editor.indexOf("{", nameBegin);
        source = (String)source + this.m_editor.getSourceBeginEnd(nameBegin, openBrace);
        source = ((String)source).trim();
        source = (String)source + " {\n";
        TypeDeclaration[] typeDeclarationArray = innerTypes = typeDeclaration.getTypes();
        int n = innerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration innerType = typeDeclarationArray[n2];
            if (AstNodeUtils.isStatic((BodyDeclaration)innerType)) {
                source = (String)source + "static ";
            }
            source = (String)source + this.getClassDeclarationHeader(innerType) + "}\n";
            ++n2;
        }
        FieldDeclaration[] fields = typeDeclaration.getFields();
        typeDeclarationArray = fields;
        n = fields.length;
        n2 = 0;
        while (n2 < n) {
            TypeDeclaration field = typeDeclarationArray[n2];
            if (AstParser.isVisibleType(field.getType())) {
                source = (String)source + AstParser.getFieldSourceForParsingContext((FieldDeclaration)field) + "\n";
            }
            ++n2;
        }
        source = (String)source + this.getEnumsDeclarations(typeDeclaration);
        MethodDeclaration[] methods = typeDeclaration.getMethods();
        typeDeclarationArray = methods;
        n = methods.length;
        n2 = 0;
        while (n2 < n) {
            TypeDeclaration method = typeDeclarationArray[n2];
            source = (String)source + this.getMethodDeclarationSource((MethodDeclaration)method);
            ++n2;
        }
        return source;
    }

    private String getMethodDeclarationSource(MethodDeclaration method) {
        IMethodBinding binding = AstNodeUtils.getMethodBinding(method);
        if (binding == null) {
            return "";
        }
        if (method.getProperty(KEY_IGNORE_THIS_METHOD) == Boolean.TRUE) {
            return "";
        }
        if (binding.isConstructor() && AstParser.isMethodOfTopType(method)) {
            return "";
        }
        Object source = "";
        int sourceBegin = this.getMethodDeclarationSourceBegin(method);
        int sourceEnd = method.getBody() != null ? AstNodeUtils.getSourceBegin((ASTNode)method.getBody()) : AstNodeUtils.getSourceEnd((ASTNode)method);
        source = (String)source + this.m_editor.getSourceBeginEnd(sourceBegin, sourceEnd);
        source = StringUtilities.normalizeWhitespaces((String)source);
        if (AstNodeUtils.isAbstract(binding)) {
            source = (String)source + "\n";
        } else {
            String returnTypeName;
            source = (String)source + "{";
            if (binding.isConstructor()) {
                source = (String)source + AstParser.getConstructorBodySource(method);
            }
            if (!"void".equals(returnTypeName = AstNodeUtils.getFullyQualifiedName(binding.getReturnType(), false))) {
                source = (String)source + "return " + AstParser.getDefaultValue(returnTypeName) + ";";
            }
            source = (String)source + "}\n";
        }
        return source;
    }

    private static String getConstructorBodySource(MethodDeclaration method) {
        List<Statement> statements = DomGenerics.statements(method);
        if (!statements.isEmpty()) {
            if (statements.get(0) instanceof SuperConstructorInvocation) {
                SuperConstructorInvocation invocation = (SuperConstructorInvocation)statements.get(0);
                IMethodBinding binding = AstNodeUtils.getSuperBinding(invocation);
                return "super" + AstParser.getMethodArgumentsSource(binding);
            }
            if (statements.get(0) instanceof ConstructorInvocation) {
                ConstructorInvocation invocation = (ConstructorInvocation)statements.get(0);
                IMethodBinding binding = AstNodeUtils.getBinding(invocation);
                return "this" + AstParser.getMethodArgumentsSource(binding);
            }
        }
        return "";
    }

    private static boolean isMethodOfTopType(MethodDeclaration method) {
        ASTNode parentType = method.getParent();
        return parentType.getParent() instanceof CompilationUnit;
    }

    private int getMethodDeclarationSourceBegin(MethodDeclaration method) {
        List<ASTNode> modifiers = DomGenerics.modifiersNodes((BodyDeclaration)method);
        if (!modifiers.isEmpty()) {
            return modifiers.get(0).getStartPosition();
        }
        List<TypeParameter> parameters = DomGenerics.typeParameters(method);
        if (!parameters.isEmpty()) {
            int begin = parameters.get(0).getStartPosition();
            begin = this.m_editor.indexOfCharBackward('<', begin);
            return begin;
        }
        Type type = method.getReturnType2();
        if (type != null) {
            return type.getStartPosition();
        }
        return method.getName().getStartPosition();
    }

    private String getEnumsDeclarations(TypeDeclaration typeDeclaration) {
        Object source = "";
        List<EnumDeclaration> enums = DomGenerics.getEnums(typeDeclaration);
        for (EnumDeclaration enumDeclaration : enums) {
            source = (String)source + "enum " + enumDeclaration.getName().getIdentifier();
            source = (String)source + " {";
            List<ASTNode> enumConstants = DomGenerics.getEnumConstants(enumDeclaration);
            int i = 0;
            while (i < enumConstants.size()) {
                EnumConstantDeclaration declaration = (EnumConstantDeclaration)enumConstants.get(i);
                source = (String)source + declaration.getName().getIdentifier();
                source = i == enumConstants.size() - 1 ? (String)source + ";" : (String)source + ", ";
                ++i;
            }
            source = (String)source + "}\n";
        }
        return source;
    }

    private static String getFieldSourceForParsingContext(FieldDeclaration field) {
        Object fieldSource = "";
        int modifiers = field.getModifiers();
        if ((modifiers & 8) != 0) {
            fieldSource = (String)fieldSource + "static ";
        }
        if ((modifiers & 0x10) != 0) {
            fieldSource = (String)fieldSource + "final ";
        }
        String typeName = AstNodeUtils.getFullyQualifiedName(field.getType(), false);
        fieldSource = (String)fieldSource + typeName + " ";
        for (VariableDeclarationFragment fragment : DomGenerics.fragments(field)) {
            if (!((String)fieldSource).endsWith(" ")) {
                fieldSource = (String)fieldSource + ", ";
            }
            fieldSource = (String)fieldSource + fragment.getName().getIdentifier() + "=" + AstParser.getDefaultValue(typeName);
        }
        fieldSource = (String)fieldSource + ";";
        return fieldSource;
    }

    private String getOpenConstructorSource(TypeDeclaration typeDeclaration) {
        IMethodBinding[] declaredMethods;
        ITypeBinding typeBinding = AstNodeUtils.getTypeBinding(typeDeclaration);
        ITypeBinding superTypeBinding = typeBinding.getSuperclass();
        String constructorCode = typeDeclaration.getName().getIdentifier() + "(Object __wbp_param) {\n";
        try {
            declaredMethods = superTypeBinding.getDeclaredMethods();
        }
        catch (Throwable e) {
            declaredMethods = new IMethodBinding[]{};
        }
        IMethodBinding[] iMethodBindingArray = declaredMethods;
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding methodBinding = iMethodBindingArray[n2];
            int modifiers = methodBinding.getModifiers();
            if (methodBinding.isConstructor() && (Modifier.isProtected((int)modifiers) || Modifier.isPublic((int)modifiers))) {
                constructorCode = constructorCode + "super" + AstParser.getMethodArgumentsSource(methodBinding);
                break;
            }
            ++n2;
        }
        return constructorCode;
    }

    private static String getMethodArgumentsSource(IMethodBinding methodBinding) {
        Object source = "(";
        ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            ITypeBinding parameterType = parameterTypes[i];
            if (i != 0) {
                source = (String)source + ", ";
            }
            String parameterTypeName = AstNodeUtils.getFullyQualifiedName(parameterType, false);
            source = (String)source + AstParser.getDefaultValue(parameterTypeName);
            ++i;
        }
        source = (String)source + ");";
        return source;
    }

    /*
     * WARNING - void declaration
     */
    private String getVisibleVariablesCode(int position) {
        StringBuffer sb = new StringBuffer();
        List<VariableDeclaration> declarations = AstNodeUtils.getVariableDeclarationsVisibleAt((ASTNode)this.m_editor.getAstUnit(), position);
        for (VariableDeclaration declaration : declarations) {
            Type type = null;
            VariableDeclaration variableDeclaration = declaration;
            if (variableDeclaration instanceof SingleVariableDeclaration) {
                void parameter;
                SingleVariableDeclaration cfr_ignored_0 = (SingleVariableDeclaration)variableDeclaration;
                SingleVariableDeclaration cfr_ignored_1 = (SingleVariableDeclaration)variableDeclaration;
                type = parameter.getType();
            } else {
                VariableDeclaration variableDeclaration2 = declaration;
                if (variableDeclaration2 instanceof VariableDeclarationFragment) {
                    void fragment;
                    VariableDeclarationFragment cfr_ignored_2 = (VariableDeclarationFragment)variableDeclaration2;
                    VariableDeclarationFragment cfr_ignored_3 = (VariableDeclarationFragment)variableDeclaration2;
                    if (fragment.getParent() instanceof FieldDeclaration) continue;
                    if (fragment.getParent() instanceof VariableDeclarationStatement) {
                        VariableDeclarationStatement statement = (VariableDeclarationStatement)fragment.getParent();
                        type = statement.getType();
                    }
                }
            }
            Assert.isNotNull(type);
            if (!AstParser.isVisibleType(type)) continue;
            ITypeBinding typeBinding = AstNodeUtils.getTypeBinding(type);
            String typeName = AstNodeUtils.getFullyQualifiedName(typeBinding, false);
            sb.append(typeName);
            sb.append(' ');
            sb.append(declaration.getName().getIdentifier());
            sb.append(" = ");
            sb.append(AstParser.getDefaultValue(typeName));
            sb.append(";\n");
        }
        return sb.toString();
    }

    private static boolean isVisibleType(Type type) {
        ITypeBinding fieldTypeBinding = AstNodeUtils.getTypeBinding(type);
        return fieldTypeBinding != null;
    }

    public static String getDefaultValue(String className) {
        if ("boolean".equals(className)) {
            return "false";
        }
        if ("byte".equals(className)) {
            return "(byte)0";
        }
        if ("char".equals(className)) {
            return "'0'";
        }
        if ("short".equals(className)) {
            return "(short)0";
        }
        if ("int".equals(className)) {
            return "0";
        }
        if ("long".equals(className)) {
            return "0L";
        }
        if ("float".equals(className)) {
            return "0.0f";
        }
        if ("double".equals(className)) {
            return "0.0";
        }
        return "(" + className + ") null";
    }

    private String getAnonymousClassCode(int position) {
        ITypeBinding typeBinding;
        ASTNode node = this.m_editor.getEnclosingNode(position);
        Initializer initializer = null;
        AnonymousClassDeclaration declaration = null;
        ClassInstanceCreation creation = null;
        while (node != null) {
            if (initializer != null && declaration != null && node instanceof Statement) break;
            if (initializer == null && node instanceof Initializer) {
                initializer = (Initializer)node;
            }
            if (declaration == null && node instanceof AnonymousClassDeclaration) {
                declaration = (AnonymousClassDeclaration)node;
                creation = (ClassInstanceCreation)declaration.getParent();
            }
            node = node.getParent();
        }
        if (initializer != null && declaration != null && (typeBinding = declaration.resolveBinding().getSuperclass()) != null) {
            String typeName = AstNodeUtils.getFullyQualifiedName(typeBinding, false);
            Object argumentsSource = "";
            List<Expression> arguments = DomGenerics.arguments(creation);
            for (Expression argument : arguments) {
                if (!StringUtils.isEmpty((String)argumentsSource)) {
                    argumentsSource = (String)argumentsSource + ", ";
                }
                argumentsSource = (String)argumentsSource + this.m_editor.getSource((ASTNode)argument);
            }
            return "new " + typeName + "(" + (String)argumentsSource + ") { {";
        }
        return "";
    }

    private CompilationUnit parseCompilationUnit(String source) throws Exception {
        return CodeUtils.parseCompilationUnit(source, this.m_editor.getJavaProject(), "Fake");
    }

    private AST getAst() {
        return this.m_editor.getAstUnit().getAST();
    }

    private ASTNode findNode(String source, int targetPosition, Class<? extends ASTNode> nodeClass, int nodePosition) throws Exception {
        CompilationUnit compilationUnit = this.parseCompilationUnit(source);
        try {
            return this.findNode0(compilationUnit, targetPosition, nodeClass, nodePosition);
        }
        catch (Throwable e) {
            String problemsString = AstParser.getProblemsString(compilationUnit);
            throw new DesignerException(205, e, new String[]{source, problemsString});
        }
    }

    private static String getProblemsString(CompilationUnit compilationUnit) throws Exception {
        StringBuilder problemsString = new StringBuilder();
        IProblem[] iProblemArray = compilationUnit.getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (problem.getID() != 16777541) {
                if (problemsString.length() != 0) {
                    problemsString.append("\r\n");
                }
                problemsString.append("line: ");
                problemsString.append(problem.getSourceLineNumber());
                problemsString.append(" ");
                problemsString.append(problem.getMessage());
            }
            ++n2;
        }
        return problemsString.toString();
    }

    private ASTNode findNode0(CompilationUnit compilationUnit, final int targetPosition, final Class<? extends ASTNode> nodeClass, final int nodePosition) throws Exception {
        final ArrayList nodes = new ArrayList();
        compilationUnit.accept(new ASTVisitor(true){

            public void preVisit(ASTNode node) {
                int pos = node.getStartPosition();
                if (nodes.isEmpty() && pos >= nodePosition && nodeClass.isInstance(node)) {
                    nodes.add(node);
                }
                if (pos >= nodePosition) {
                    int length = node.getLength();
                    node.setSourceRange(targetPosition + pos - nodePosition, length);
                }
            }
        });
        Assert.isTrue((nodes.size() == 1 ? 1 : 0) != 0);
        ASTNode externalNode = (ASTNode)nodes.get(0);
        ASTNode internalNode = ASTNode.copySubtree((AST)this.m_editor.getAstUnit().getAST(), (ASTNode)externalNode);
        this.copyBindings(externalNode, internalNode);
        return internalNode;
    }

    private final void copyBindings(ASTNode source, ASTNode target) {
        final TreeMap indexToBinding = new TreeMap();
        final int[] finalIndex = new int[1];
        source.accept(new ASTVisitor(){

            /*
             * WARNING - void declaration
             */
            public void postVisit(ASTNode node) {
                ASTNode aSTNode;
                ITypeBinding binding;
                ASTNode aSTNode2;
                AnonymousClassDeclaration binding2;
                ASTNode aSTNode3;
                TypeDeclaration binding3;
                ASTNode aSTNode4;
                Type binding4;
                MethodDeclaration expression;
                ASTNode aSTNode5;
                ASTNode aSTNode6;
                FieldAccess binding5;
                ASTNode aSTNode7;
                VariableDeclaration binding6;
                ASTNode aSTNode8 = node;
                if (aSTNode8 instanceof SimpleName) {
                    void simpleName;
                    SimpleName simpleName2 = (SimpleName)aSTNode8;
                    SimpleName cfr_ignored_0 = (SimpleName)aSTNode8;
                    binding6 = simpleName.resolveBinding();
                    if (binding6 instanceof IVariableBinding) {
                        this.saveBinding((IBinding)binding6);
                    } else {
                        this.saveBinding(null);
                    }
                }
                if ((aSTNode7 = node) instanceof VariableDeclaration) {
                    void variableDeclaration;
                    binding6 = (VariableDeclaration)aSTNode7;
                    VariableDeclaration cfr_ignored_1 = (VariableDeclaration)aSTNode7;
                    binding5 = variableDeclaration.resolveBinding();
                    this.saveBinding((IBinding)binding5);
                }
                if ((aSTNode6 = node) instanceof FieldAccess) {
                    void fieldAccess;
                    binding5 = (FieldAccess)aSTNode6;
                    FieldAccess cfr_ignored_2 = (FieldAccess)aSTNode6;
                    this.saveBinding((IBinding)fieldAccess.resolveFieldBinding());
                }
                if ((aSTNode5 = node) instanceof Expression) {
                    Expression expression2 = (Expression)aSTNode5;
                    Expression cfr_ignored_3 = (Expression)aSTNode5;
                    binding4 = expression.resolveTypeBinding();
                    this.saveBinding((IBinding)binding4);
                }
                if ((aSTNode4 = node) instanceof Type) {
                    void type;
                    binding4 = (Type)aSTNode4;
                    Type cfr_ignored_4 = (Type)aSTNode4;
                    binding3 = type.resolveBinding();
                    this.saveBinding((IBinding)binding3);
                }
                if ((aSTNode3 = node) instanceof TypeDeclaration) {
                    void typeDeclaration;
                    binding3 = (TypeDeclaration)aSTNode3;
                    TypeDeclaration cfr_ignored_5 = (TypeDeclaration)aSTNode3;
                    binding2 = typeDeclaration.resolveBinding();
                    this.saveBinding((IBinding)binding2);
                }
                if ((aSTNode2 = node) instanceof AnonymousClassDeclaration) {
                    void anonymousClass;
                    binding2 = (AnonymousClassDeclaration)aSTNode2;
                    AnonymousClassDeclaration cfr_ignored_6 = (AnonymousClassDeclaration)aSTNode2;
                    binding = anonymousClass.resolveBinding();
                    this.saveBinding((IBinding)binding);
                }
                if ((aSTNode5 = node) instanceof MethodDeclaration) {
                    void method;
                    expression = (MethodDeclaration)aSTNode5;
                    MethodDeclaration cfr_ignored_7 = (MethodDeclaration)aSTNode5;
                    binding4 = method.resolveBinding();
                    this.saveBinding((IBinding)binding4);
                }
                if ((aSTNode4 = node) instanceof MethodInvocation) {
                    void invocation;
                    binding4 = (MethodInvocation)aSTNode4;
                    MethodInvocation cfr_ignored_8 = (MethodInvocation)aSTNode4;
                    binding3 = invocation.resolveMethodBinding();
                    this.saveBinding((IBinding)binding3);
                }
                if ((aSTNode3 = node) instanceof SuperConstructorInvocation) {
                    void invocation;
                    binding3 = (SuperConstructorInvocation)aSTNode3;
                    SuperConstructorInvocation cfr_ignored_9 = (SuperConstructorInvocation)aSTNode3;
                    binding2 = invocation.resolveConstructorBinding();
                    this.saveBinding((IBinding)binding2);
                }
                if ((aSTNode2 = node) instanceof SuperMethodInvocation) {
                    void invocation;
                    binding2 = (SuperMethodInvocation)aSTNode2;
                    SuperMethodInvocation cfr_ignored_10 = (SuperMethodInvocation)aSTNode2;
                    binding = invocation.resolveMethodBinding();
                    this.saveBinding((IBinding)binding);
                }
                if ((aSTNode = node) instanceof ClassInstanceCreation) {
                    void creation;
                    binding = (ClassInstanceCreation)aSTNode;
                    ClassInstanceCreation cfr_ignored_11 = (ClassInstanceCreation)aSTNode;
                    IMethodBinding binding7 = creation.resolveConstructorBinding();
                    this.saveBinding((IBinding)binding7);
                }
            }

            public void saveBinding(IBinding binding) {
                int n = finalIndex[0];
                finalIndex[0] = n + 1;
                int index = n;
                if (binding != null) {
                    indexToBinding.put(index, binding);
                }
            }
        });
        finalIndex = new int[1];
        target.accept(new ASTVisitor(){

            public void postVisit(ASTNode node) {
                IVariableBinding binding;
                int index;
                if (node instanceof SimpleName || node instanceof FieldAccess || node instanceof VariableDeclaration) {
                    int n = finalIndex[0];
                    finalIndex[0] = n + 1;
                    index = n;
                    binding = (IVariableBinding)indexToBinding.get(index);
                    if (binding != null) {
                        node.setProperty(AstParser.KEY_VARIABLE_BINDING, (Object)AstParser.this.m_context.get(binding));
                    }
                }
                if (node instanceof Expression || node instanceof Type || node instanceof TypeDeclaration || node instanceof AnonymousClassDeclaration) {
                    int n = finalIndex[0];
                    finalIndex[0] = n + 1;
                    index = n;
                    binding = (ITypeBinding)indexToBinding.get(index);
                    if (binding != null) {
                        node.setProperty(AstParser.KEY_TYPE_BINDING, (Object)AstParser.this.m_context.get((ITypeBinding)binding, true));
                    }
                }
                if (node instanceof MethodDeclaration || node instanceof MethodInvocation || node instanceof SuperConstructorInvocation || node instanceof SuperMethodInvocation || node instanceof ClassInstanceCreation) {
                    int n = finalIndex[0];
                    finalIndex[0] = n + 1;
                    index = n;
                    binding = (IMethodBinding)indexToBinding.get(index);
                    Assert.isNotNull((Object)binding);
                    node.setProperty(AstParser.KEY_METHOD_BINDING, (Object)AstParser.this.m_context.get((IMethodBinding)binding));
                }
            }
        });
    }
}

