/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor.palette.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.tools.CreationTool;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.palette.model.entry.LibraryInfo;
import org.eclipse.wb.internal.core.model.description.ComponentPresentation;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.core.xml.editor.palette.model.AttributesProvider;
import org.eclipse.wb.internal.core.xml.editor.palette.model.AttributesProviders;
import org.eclipse.wb.internal.core.xml.editor.palette.model.CategoryInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.IPaletteSite;
import org.eclipse.wb.internal.core.xml.editor.palette.model.ToolEntryInfo;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.creation.ElementCreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.xml.model.description.ComponentPresentationHelper;
import org.eclipse.wb.internal.core.xml.model.description.CreationDescription;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

public final class ComponentEntryInfo
extends ToolEntryInfo {
    public static final String KEY_SIMULATE_PRESENTATION = "ComponentEntryInfo.simulatePresentation";
    public static final ImageDescriptor DEFAULT_ICON = DesignerPlugin.getImageDescriptor((String)"palette/Object.png");
    private String m_className;
    private String m_creationId;
    private String m_enabledScript;
    private ImageDescriptor m_icon;
    private final List<LibraryInfo> m_libraries = new ArrayList<LibraryInfo>();
    private Class<?> m_class;
    private ComponentPresentation m_presentation;
    private ComponentDescription m_description;
    private CreationDescription m_creation;
    private static Map<ClassLoader, Set<String>> m_contextHasClasses = new WeakHashMap<ClassLoader, Set<String>>();
    private static Map<ClassLoader, Set<String>> m_contextNoClasses = new WeakHashMap<ClassLoader, Set<String>>();

    public ComponentEntryInfo() {
    }

    public ComponentEntryInfo(CategoryInfo categoryInfo, IConfigurationElement element) throws Exception {
        this(categoryInfo, AttributesProviders.get(element));
        this.m_icon = ExternalFactoriesHelper.getImageDescriptor((IConfigurationElement)element, (String)"icon");
        this.addLibraries(element);
    }

    public ComponentEntryInfo(CategoryInfo categoryInfo, AttributesProvider attributes) {
        this.m_className = attributes.getAttribute("class");
        Assert.isNotNull((Object)this.m_className, (String)"Component must have 'class' attribute.");
        this.m_creationId = attributes.getAttribute("creationId");
        Object id = attributes.getAttribute("id");
        if (id == null) {
            id = categoryInfo.getId() + " " + this.m_className;
            if (this.m_creationId != null) {
                id = (String)id + " " + this.m_creationId;
            }
        }
        this.setId((String)id);
        this.setName(attributes.getAttribute("name"));
        this.setDescription(attributes.getAttribute("description"));
        this.setVisible(ComponentEntryInfo.getBoolean(attributes, "visible", true));
        this.m_enabledScript = attributes.getAttribute("enabled");
    }

    public String toString() {
        return "Component(class='" + this.m_className + "')";
    }

    public String getCreationId() {
        return this.m_creationId;
    }

    public void setCreationId(String creationId) {
        this.m_creationId = creationId;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setComponentClassName(String componentClassName) {
        this.m_className = componentClassName;
    }

    private void addLibraries(IConfigurationElement componentElement) {
        IConfigurationElement[] iConfigurationElementArray = componentElement.getChildren("library");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement libraryElement = iConfigurationElementArray[n2];
            this.m_libraries.add(new LibraryInfo(libraryElement));
            ++n2;
        }
    }

    private void ensureLibraries() throws Exception {
        for (LibraryInfo library : this.m_libraries) {
            library.ensure(this.m_javaProject);
        }
    }

    @Override
    protected String getNameDefault() {
        return this.m_className;
    }

    @Override
    public boolean initialize(IEditPartViewer editPartViewer, XmlObjectInfo rootObject) {
        String description;
        super.initialize(editPartViewer, rootObject);
        if (!this.preparePresentation()) {
            return false;
        }
        if (this.m_icon == null) {
            this.m_icon = this.m_presentation.getIcon();
        }
        if (this.getNameRaw() == null) {
            this.setName(this.m_presentation.getName());
        }
        if (StringUtils.isEmpty((String)(description = this.getDescription())) || this.m_className.equals(description)) {
            this.setDescription(this.m_presentation.getDescription());
        }
        return true;
    }

    private boolean preparePresentation() {
        if (this.m_rootJavaInfo.getArbitraryValue(KEY_SIMULATE_PRESENTATION) != null) {
            this.m_presentation = new ComponentPresentation("key", "toolkitId", this.m_className, this.m_className, null);
            return true;
        }
        if (!this.hasClass()) {
            return false;
        }
        try {
            this.m_presentation = ComponentPresentationHelper.getPresentation(this.m_context, this.m_className, this.m_creationId);
            if (this.m_presentation == null) {
                String message = "Palette: no presentation for component " + this.m_className;
                this.m_context.addWarning(new EditorWarning(message));
                return false;
            }
        }
        catch (Throwable e) {
            String message = "Palette: can not load component " + this.m_className;
            this.m_context.addWarning(new EditorWarning(message, e));
            return false;
        }
        return true;
    }

    private boolean ensureDescriptions() {
        if (this.m_creation == null) {
            try {
                this.m_class = this.m_context.getClassLoader().loadClass(this.m_className);
                this.m_description = ComponentDescriptionHelper.getDescription(this.m_context, this.m_class);
                this.m_creation = this.m_description.getCreation(this.m_creationId);
            }
            catch (Throwable e) {
                String message = "Palette: can not load component " + this.m_className;
                this.m_context.addWarning(new EditorWarning(message, e));
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isEnabled() {
        boolean enabled;
        return this.m_enabledScript == null || (enabled = ((Boolean)ExecutionUtils.runObjectIgnore((RunnableObjectEx)new RunnableObjectEx<Boolean>(){

            public Boolean runObject() throws Exception {
                ClassLoader classLoader = ComponentEntryInfo.this.m_context.getClassLoader();
                return (Boolean)ScriptUtils.evaluate((ClassLoader)classLoader, (String)ComponentEntryInfo.this.m_enabledScript);
            }
        }, (Object)false)).booleanValue());
    }

    @Override
    public ImageDescriptor getIcon() {
        if (this.m_icon == null) {
            return DEFAULT_ICON;
        }
        return this.m_icon;
    }

    private boolean hasClass() {
        List elements = ExternalFactoriesHelper.getElements((String)"org.eclipse.wb.core.paletteComponentExists", (String)"component");
        for (IConfigurationElement element : elements) {
            String pkg = element.getAttribute("package");
            if (pkg == null || !this.m_className.startsWith(pkg)) continue;
            String witnessClassName = element.getAttribute("witness");
            if (witnessClassName != null) {
                return this.hasClass0(witnessClassName);
            }
            if (element.getAttribute("hasType") != null) {
                return ProjectUtils.hasType((IJavaProject)this.m_javaProject, (String)this.m_className);
            }
            if (element.getAttribute("always") == null) continue;
            return true;
        }
        return this.hasClass0(this.m_className);
    }

    private boolean hasClass0(String className) {
        ClassLoader classLoader = this.m_context.getClassLoader();
        Set<String> hasClasses = m_contextHasClasses.get(classLoader);
        if (hasClasses == null) {
            hasClasses = new HashSet<String>();
            m_contextHasClasses.put(classLoader, hasClasses);
        }
        if (hasClasses.contains(className)) {
            return true;
        }
        Set<String> noClasses = m_contextNoClasses.get(classLoader);
        if (noClasses == null) {
            noClasses = new HashSet<String>();
            m_contextNoClasses.put(classLoader, noClasses);
        }
        if (noClasses.contains(className)) {
            return false;
        }
        try {
            classLoader.loadClass(className);
            hasClasses.add(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            noClasses.add(className);
            return false;
        }
    }

    @Override
    public Tool createTool() throws Exception {
        if (!this.ensureDescriptions()) {
            return null;
        }
        if (ReflectionUtils.isAbstract(this.m_class)) {
            Shell parentShell = IPaletteSite.Helper.getSite(this.m_rootJavaInfo).getShell();
            UiUtils.openError((Shell)parentShell, (String)"Error", (String)"You can not drop abstract component.");
            return null;
        }
        ICreationFactory factory = new ICreationFactory(){
            private XmlObjectInfo m_object;

            public void activate() throws Exception {
                ElementCreationSupport creationSupport = new ElementCreationSupport(ComponentEntryInfo.this.m_creationId);
                this.m_object = XmlObjectUtils.createObject(ComponentEntryInfo.this.m_context, ComponentEntryInfo.this.m_class, (CreationSupport)creationSupport);
                this.m_object = XmlObjectUtils.getWrapped(this.m_object);
                this.m_object.putArbitraryValue("manuallyCreatedComponent", Boolean.TRUE);
            }

            public Object getNewObject() {
                return this.m_object;
            }
        };
        this.ensureLibraries();
        return new CreationTool(factory);
    }
}

