/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.description;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.xml.model.description.AbstractDescription;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.CreationAttributeDescription;

public final class CreationDescription
extends AbstractDescription {
    private final ComponentDescription m_componentDescription;
    private final Class<?> m_componentClass;
    private final String m_id;
    private ImageDescriptor m_icon;
    private final String m_name;
    private String m_description;
    private final List<CreationAttributeDescription> m_attributes = new ArrayList<CreationAttributeDescription>();
    private String m_content;
    private final Map<String, String> m_parameters = new TreeMap<String, String>();

    public CreationDescription(ComponentDescription componentDescription, String id, String name) {
        this.m_componentDescription = componentDescription;
        this.m_componentClass = componentDescription.getComponentClass();
        this.m_id = id;
        this.m_name = name != null ? name : CodeUtils.getShortClass((String)this.m_componentClass.getName());
    }

    public String getId() {
        return this.m_id;
    }

    public ImageDescriptor getIcon() {
        return this.m_icon != null ? this.m_icon : this.m_componentDescription.getIcon();
    }

    public void setIcon(ImageDescriptor icon) {
        this.m_icon = icon;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description != null ? this.m_description : this.m_componentDescription.getDescription();
    }

    public void setDescription(String description) {
        this.m_description = description != null ? StringUtilities.normalizeWhitespaces((String)description) : null;
    }

    public List<CreationAttributeDescription> getAttributes() {
        return this.m_attributes;
    }

    public void addAttribute(CreationAttributeDescription attribute) {
        this.m_attributes.add(attribute);
    }

    public String getContent() {
        return this.m_content;
    }

    public void setContent(String content) {
        this.m_content = content;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.m_parameters);
    }

    public void addParameter(String name, String value) {
        this.m_parameters.put(name, value);
    }
}

