/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.utils;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.broadcast.BroadcastSupport;
import org.eclipse.wb.core.model.broadcast.DisplayEventListener;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.util.live.ILiveCacheEntry;
import org.eclipse.wb.internal.core.utils.reflect.ClassMap;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;
import org.eclipse.wb.internal.core.xml.Messages;
import org.eclipse.wb.internal.core.xml.model.AbstractComponentInfo;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.utils.GlobalStateXml;

public abstract class AbstractLiveManager {
    protected final AbstractComponentInfo m_component;
    private final EditorContext m_context;
    private static final ClassMap<Map<String, ILiveCacheEntry>> CACHE = ClassMap.create();

    public AbstractLiveManager(AbstractComponentInfo component) {
        this.m_component = component;
        this.m_context = component.getContext();
    }

    protected final ILiveCacheEntry createCacheEntry() {
        try {
            return this.createCacheEntryEx();
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
            return this.createComponentCacheEntryEx(e);
        }
    }

    private ILiveCacheEntry createCacheEntryEx() throws Exception {
        BroadcastSupport oldBroadcast = this.m_context.getBroadcastSupport();
        XmlObjectInfo oldActiveObject = (XmlObjectInfo)GlobalState.getActiveObject();
        ((DisplayEventListener)oldBroadcast.getListener(DisplayEventListener.class)).beforeMessagesLoop();
        AbstractComponentInfo liveComponentInfo = null;
        try {
            liveComponentInfo = this.createLiveComponent();
            liveComponentInfo.getRoot().endEdit();
            ILiveCacheEntry iLiveCacheEntry = this.createComponentCacheEntry(liveComponentInfo);
            return iLiveCacheEntry;
        }
        finally {
            GlobalStateXml.activate(oldActiveObject);
            this.cleanupLiveComponent(liveComponentInfo);
            this.m_context.getLiveContext().dispose();
            ((DisplayEventListener)oldBroadcast.getListener(DisplayEventListener.class)).afterMessagesLoop();
        }
    }

    protected String getKey() {
        return this.m_component.getCreationSupport().toString();
    }

    protected abstract AbstractComponentInfo createLiveComponent() throws Exception;

    protected void cleanupLiveComponent(AbstractComponentInfo liveComponentInfo) throws Exception {
        if (liveComponentInfo != null) {
            liveComponentInfo.getRoot().refresh_dispose();
        }
    }

    protected abstract ILiveCacheEntry createComponentCacheEntry(AbstractComponentInfo var1);

    protected abstract ILiveCacheEntry createComponentCacheEntryEx(Throwable var1);

    protected final XmlObjectInfo parse(String[] sourceLines) throws Exception {
        XmlObjectInfo root = this.m_context.getLiveContext().parse(sourceLines);
        root.startEdit();
        return root;
    }

    protected static Image createImageForException(Throwable e) {
        int width = 200;
        int height = 50;
        Image image = new Image(null, width, height);
        GC gc = new GC((Drawable)image);
        try {
            gc.setBackground(new Color(255, 220, 220));
            gc.fillRectangle(0, 0, width, height);
            String text = Messages.AbstractLiveManager_errorMessage;
            DrawUtils.drawTextWrap((GC)gc, (String)text, (int)0, (int)0, (int)width, (int)height);
        }
        finally {
            gc.dispose();
        }
        return image;
    }

    protected final ILiveCacheEntry getCachedEntry() {
        String key;
        ILiveCacheEntry entry;
        Class<?> clazz = this.m_component.getDescription().getComponentClass();
        TreeMap<String, ILiveCacheEntry> cache = (TreeMap<String, ILiveCacheEntry>)CACHE.get(clazz);
        if (cache == null) {
            cache = new TreeMap<String, ILiveCacheEntry>();
            CACHE.put(clazz, cache);
        }
        if ((entry = (ILiveCacheEntry)cache.get(key = this.getKey())) == null) {
            entry = this.createCacheEntry();
            cache.put(key, entry);
        }
        return entry;
    }
}

