/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.model.IObjectInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.description.IComponentDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.state.IDescriptionHelper;
import org.eclipse.wb.internal.core.utils.state.ILayoutRequestValidatorHelper;
import org.eclipse.wb.internal.core.utils.state.IOrderProcessor;
import org.eclipse.wb.internal.core.utils.state.IOtherHelper;
import org.eclipse.wb.internal.core.utils.state.IParametersProvider;
import org.eclipse.wb.internal.core.utils.state.IPasteComponentProcessor;
import org.eclipse.wb.internal.core.utils.state.IPasteRequestProcessor;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.OrderAssociation;
import org.eclipse.wb.internal.core.xml.model.clipboard.XmlObjectMemento;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.xml.model.description.DescriptionPropertiesHelper;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

public final class GlobalStateXml {
    private static EditorContext m_context;
    private static final IParametersProvider m_parametersProvider;
    private static final IDescriptionHelper m_descriptionHelper;
    private static final ILayoutRequestValidatorHelper m_validatorHelper;
    private static final IPasteRequestProcessor m_pasteRequestProcessor;
    private static final IOrderProcessor m_orderProcessor;
    private static final IOtherHelper m_otherHelper;

    static {
        m_parametersProvider = new IParametersProvider(){

            public Map<String, String> getParameters(Object object) {
                if (object instanceof XmlObjectInfo) {
                    return XmlObjectUtils.getParameters((XmlObjectInfo)((Object)object));
                }
                if (object instanceof ComponentDescription) {
                    return ((ComponentDescription)object).getParameters();
                }
                return Collections.emptyMap();
            }

            public String getParameter(Object object, String name) {
                if (object instanceof XmlObjectInfo) {
                    return XmlObjectUtils.getParameter((XmlObjectInfo)((Object)object), name);
                }
                if (object instanceof ComponentDescription) {
                    return ((ComponentDescription)object).getParameter(name);
                }
                return null;
            }

            public boolean hasTrueParameter(Object object, String name) {
                if (object instanceof XmlObjectInfo) {
                    return XmlObjectUtils.hasTrueParameter((XmlObjectInfo)((Object)object), name);
                }
                return false;
            }
        };
        m_descriptionHelper = new IDescriptionHelper(){

            public PropertyEditor getEditorForType(Class<?> type) throws Exception {
                return DescriptionPropertiesHelper.getEditorForType(type);
            }

            public IComponentDescription getDescription(Object object) {
                if (object instanceof XmlObjectInfo) {
                    return ((XmlObjectInfo)((Object)object)).getDescription();
                }
                return null;
            }
        };
        m_validatorHelper = new ILayoutRequestValidatorHelper(){

            public boolean isComponent(Object object) {
                return object instanceof XmlObjectInfo;
            }

            public IComponentDescription getPasteComponentDescription(Object _memento) throws Exception {
                XmlObjectMemento memento = (XmlObjectMemento)_memento;
                XmlObjectInfo activeObject = (XmlObjectInfo)GlobalState.getActiveObject();
                return ComponentDescriptionHelper.getDescription(activeObject.getContext(), memento.getComponentClassName());
            }

            public Object getPasteComponent(Object _memento) throws Exception {
                XmlObjectMemento memento = (XmlObjectMemento)_memento;
                XmlObjectInfo activeObject = (XmlObjectInfo)GlobalState.getActiveObject();
                return memento.create(activeObject);
            }

            public boolean canUseParentForChild(Object parent, Object child) throws Exception {
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public boolean canReference(Object object) {
                Object object2 = object;
                if (object2 instanceof XmlObjectInfo) {
                    void xmlObject;
                    XmlObjectInfo xmlObjectInfo = (XmlObjectInfo)((Object)object2);
                    XmlObjectInfo cfr_ignored_0 = (XmlObjectInfo)((Object)object2);
                    return !(xmlObject.getCreationSupport() instanceof IImplicitCreationSupport);
                }
                return false;
            }

            public boolean canReorder(ObjectInfo component) {
                return true;
            }

            public boolean canReparent(ObjectInfo component) {
                return true;
            }
        };
        m_pasteRequestProcessor = new IPasteRequestProcessor(){

            public Command getPasteCommand(PasteRequest request, final IPasteComponentProcessor componentProcessor) {
                final List<IObjectInfo> components = this.getPastingComponents(request);
                if (components.isEmpty()) {
                    return null;
                }
                ObjectInfo hierarchyObject = GlobalState.getActiveObject();
                return new EditCommand(hierarchyObject){

                    protected void executeEdit() throws Exception {
                        for (IObjectInfo component : components) {
                            componentProcessor.process((Object)component);
                            XmlObjectMemento.apply((XmlObjectInfo)component.getUnderlyingModel());
                        }
                    }
                };
            }

            public List<IObjectInfo> getPastingComponents(PasteRequest request) {
                final List mementos = (List)request.getMemento();
                final ArrayList<IObjectInfo> components = new ArrayList<IObjectInfo>();
                ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                    public void run() throws Exception {
                        XmlObjectInfo hierarchyModel = (XmlObjectInfo)GlobalState.getActiveObject();
                        for (XmlObjectMemento memento : mementos) {
                            XmlObjectInfo component = memento.create(hierarchyModel);
                            components.add(component);
                        }
                    }
                });
                request.setObjects(components);
                return components;
            }
        };
        m_orderProcessor = new IOrderProcessor(){

            public void move(Object _component, Object _nextComponent) throws Exception {
                XmlObjectInfo component = (XmlObjectInfo)((Object)_component);
                XmlObjectInfo nextComponent = (XmlObjectInfo)((Object)_nextComponent);
                XmlObjectInfo container = (XmlObjectInfo)component.getParent();
                XmlObjectUtils.move(component, OrderAssociation.INSTANCE, container, nextComponent);
            }
        };
        m_otherHelper = new IOtherHelper(){

            public IJavaProject getJavaProject() {
                XmlObjectInfo object = (XmlObjectInfo)GlobalState.getActiveObject();
                return object.getContext().getJavaProject();
            }

            public Object getObject(ObjectInfo model) {
                if (model instanceof XmlObjectInfo) {
                    return ((XmlObjectInfo)model).getObject();
                }
                return null;
            }

            public List<EditorWarning> getWarnings() {
                return this.getContext().getWarnings();
            }

            public void addWarning(EditorWarning warning) {
                this.getContext().addWarning(warning);
            }

            private EditorContext getContext() {
                return ((XmlObjectInfo)GlobalState.getActiveObject()).getContext();
            }
        };
    }

    public static void activate(XmlObjectInfo object) {
        GlobalState.setActiveObject((ObjectInfo)object);
        if (object != null) {
            GlobalState.setToolkit((ToolkitDescription)object.getDescription().getToolkit());
            GlobalState.setClassLoader((ClassLoader)object.getContext().getClassLoader());
            GlobalStateXml.setEditorContext(object.getContext());
        } else {
            GlobalState.setToolkit(null);
            GlobalState.setClassLoader(null);
            GlobalStateXml.setEditorContext(null);
        }
        GlobalState.setParametersProvider((IParametersProvider)m_parametersProvider);
        GlobalState.setDescriptionHelper((IDescriptionHelper)m_descriptionHelper);
        GlobalState.setValidatorHelper((ILayoutRequestValidatorHelper)m_validatorHelper);
        GlobalState.setPasteRequestProcessor((IPasteRequestProcessor)m_pasteRequestProcessor);
        GlobalState.setOrderProcessor((IOrderProcessor)m_orderProcessor);
        GlobalState.setOtherHelper((IOtherHelper)m_otherHelper);
    }

    public static void deactivate(XmlObjectInfo object) {
        if (GlobalState.getActiveObject() == object) {
            GlobalStateXml.deactivate();
        }
    }

    public static void deactivate() {
        GlobalState.setActiveObject(null);
        GlobalState.setToolkit(null);
        GlobalState.setClassLoader(null);
        GlobalState.setParametersProvider(null);
        GlobalState.setDescriptionHelper(null);
        GlobalState.setValidatorHelper(null);
        GlobalState.setPasteRequestProcessor(null);
        GlobalState.setOrderProcessor(null);
        GlobalState.setOtherHelper(null);
        GlobalStateXml.setEditorContext(null);
    }

    public static void setEditorContext(EditorContext context) {
        m_context = context;
    }

    public static EditorContext getEditorContext() {
        return m_context;
    }
}

