/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.tools;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.wb.gef.core.requests.AbstractCreateRequest;
import org.eclipse.wb.gef.core.tools.TargetingTool;
import org.eclipse.wb.internal.gef.core.ISharedCursors;

public abstract class AbstractCreationTool
extends TargetingTool {
    public AbstractCreationTool() {
        this.setDefaultCursor(ISharedCursors.CURSOR_ADD);
        this.setDisabledCursor(ISharedCursors.CURSOR_NO);
    }

    protected boolean handleButtonDown(int button) {
        if (button == 1) {
            if (this.m_state == 1) {
                this.m_state = 2;
                ((AbstractCreateRequest)this.getTargetRequest()).setLocation(this.getLocation());
                this.lockTargetEditPart(this.getTargetEditPart());
            }
        } else {
            this.m_state = 8;
            this.handleInvalidInput();
        }
        return true;
    }

    protected boolean handleButtonUp(int button) {
        if (this.m_state == 2 || this.m_state == 4) {
            this.eraseTargetFeedback();
            this.unlockTargetEditPart();
            this.executeCommand();
            this.selectAddedObjects();
        }
        this.m_state = 0x40000000;
        this.handleFinished();
        return true;
    }

    protected boolean handleMove() {
        this.updateTargetRequest();
        this.updateTargetUnderMouse();
        this.showTargetFeedback();
        this.updateCommand();
        return true;
    }

    protected boolean handleDragStarted() {
        if (this.m_state == 2) {
            this.m_state = 4;
        }
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.m_state == 4) {
            this.updateTargetRequest();
            this.showTargetFeedback();
            this.updateCommand();
        }
        return true;
    }

    @Override
    protected abstract Request createTargetRequest();

    @Override
    protected void updateTargetRequest() {
        super.updateTargetRequest();
        AbstractCreateRequest request = (AbstractCreateRequest)this.getTargetRequest();
        if (this.m_state == 4) {
            Point start = this.getStartLocation();
            Rectangle bounds = new Rectangle(start, this.getDragMoveDelta());
            request.setLocation(bounds.getLocation());
            request.setSize(bounds.getSize());
        } else {
            request.setSize(null);
            request.setLocation(this.getLocation());
        }
    }

    protected abstract void selectAddedObjects();

    public void keyDown(KeyEvent event, EditPartViewer viewer) {
        if (event.keyCode == 27) {
            viewer.getEditDomain().loadDefaultTool();
        }
    }
}

