/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui.actions;

import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.BreakpointSynchronizer;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.ui.actions.Messages;

public class SynchronizeBreakpoints
implements IWorkbenchWindowActionDelegate {
    private final BreakpointSynchronizer.Direction direction;
    private Runnable currentRunnable;

    protected SynchronizeBreakpoints(BreakpointSynchronizer.Direction direction) {
        this.direction = direction;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (this.currentRunnable == null) {
            return;
        }
        this.currentRunnable.run();
        this.currentRunnable = null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentRunnable = this.createRunnable(selection);
        action.setEnabled(this.currentRunnable != null);
    }

    private Runnable createRunnable(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        final HashSet<ConnectedTargetData> targetDatas = new HashSet<ConnectedTargetData>(3);
        for (Object element : structuredSelection) {
            ConnectedTargetData connectedTargetData = SynchronizeBreakpoints.getConnectionTargetData(element);
            if (connectedTargetData == null) continue;
            targetDatas.add(connectedTargetData);
        }
        if (targetDatas.isEmpty()) {
            return null;
        }
        if (this.direction != BreakpointSynchronizer.Direction.RESET_REMOTE && targetDatas.size() > 1) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                new Job(MessageFormat.format(Messages.SynchronizeBreakpoints_JOB_TITLE, targetDatas.size())){

                    protected IStatus run(IProgressMonitor monitor) {
                        BreakpointSynchronizer.Callback callback = new BreakpointSynchronizer.Callback(){

                            public void onDone(IStatus status) {
                                ChromiumDebugPlugin.log((IStatus)status);
                            }
                        };
                        for (ConnectedTargetData data : targetDatas) {
                            data.synchronizeBreakpoints(SynchronizeBreakpoints.this.direction, callback);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        };
    }

    public static ConnectedTargetData getConnectionTargetData(Object element) {
        IDebugTarget debugTarget;
        if (element instanceof ILaunch) {
            ILaunch launch = (ILaunch)element;
            debugTarget = launch.getDebugTarget();
        } else if (element instanceof IDebugElement) {
            IDebugElement debugElement = (IDebugElement)element;
            debugTarget = debugElement.getDebugTarget();
        } else {
            return null;
        }
        if (!(debugTarget instanceof DebugTargetImpl)) {
            return null;
        }
        DebugTargetImpl debugTargetImpl = (DebugTargetImpl)debugTarget;
        return debugTargetImpl.getConnectedOrNull();
    }

    public static class Merge
    extends SynchronizeBreakpoints {
        public Merge() {
            super(BreakpointSynchronizer.Direction.MERGE);
        }
    }

    public static class ResetLocal
    extends SynchronizeBreakpoints {
        public ResetLocal() {
            super(BreakpointSynchronizer.Direction.RESET_LOCAL);
        }
    }

    public static class ResetRemote
    extends SynchronizeBreakpoints {
        public ResetRemote() {
            super(BreakpointSynchronizer.Direction.RESET_REMOTE);
        }
    }
}

