/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.Hashtable;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.gdb.service.GDBMemory;
import org.eclipse.cdt.dsf.gdb.service.GDBMemory_7_0;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory;
import org.eclipse.cdt.dsf.gdb.service.IGDBMemory2;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.MIMemory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MINotifyAsyncOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GDBMemory_7_6
extends GDBMemory_7_0
implements IEventListener {
    private ICommandControlService fConnection;

    public GDBMemory_7_6(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            public void handleSuccess() {
                GDBMemory_7_6.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.register(new String[]{MIMemory.class.getName(), IMemory.class.getName(), IGDBMemory.class.getName(), IGDBMemory2.class.getName(), GDBMemory.class.getName(), GDBMemory_7_0.class.getName(), GDBMemory_7_6.class.getName()}, new Hashtable());
        this.fConnection = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        if (this.fConnection == null) {
            requestMonitor.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", "CommandControl Service is not available"));
            return;
        }
        this.fConnection.addEventListener((IEventListener)this);
        requestMonitor.done();
    }

    @Override
    public void shutdown(RequestMonitor requestMonitor) {
        this.fConnection.removeEventListener((IEventListener)this);
        this.unregister();
        super.shutdown(requestMonitor);
    }

    public void eventReceived(Object output) {
        if (output instanceof MIOutput) {
            MIOOBRecord[] records;
            MIOOBRecord[] mIOOBRecordArray = records = ((MIOutput)output).getMIOOBRecords();
            int n = records.length;
            int n2 = 0;
            while (n2 < n) {
                MINotifyAsyncOutput notifyOutput;
                String asyncClass;
                MIOOBRecord r = mIOOBRecordArray[n2];
                if (r instanceof MINotifyAsyncOutput && "memory-changed".equals(asyncClass = (notifyOutput = (MINotifyAsyncOutput)r).getAsyncClass())) {
                    String groupId = null;
                    String addr = null;
                    int count = 0;
                    MIResult[] results = notifyOutput.getMIResults();
                    int i = 0;
                    while (i < results.length) {
                        String var = results[i].getVariable();
                        MIValue val = results[i].getMIValue();
                        if (var.equals("thread-group")) {
                            if (val instanceof MIConst) {
                                groupId = ((MIConst)val).getString();
                            }
                        } else if (var.equals("addr")) {
                            if (val instanceof MIConst) {
                                addr = ((MIConst)val).getString();
                            }
                        } else if (var.equals("len")) {
                            if (val instanceof MIConst) {
                                try {
                                    String lenStr = ((MIConst)val).getString().trim();
                                    if (lenStr.startsWith("0x")) {
                                        count = Integer.parseInt(lenStr.substring(2), 16);
                                    }
                                    count = Integer.parseInt(lenStr);
                                }
                                catch (NumberFormatException e) {
                                    assert (false);
                                }
                            }
                        } else if (var.equals("type") && val instanceof MIConst) {
                            "code".equals(((MIConst)val).getString());
                        }
                        ++i;
                    }
                    IMIProcesses procService = (IMIProcesses)this.getServicesTracker().getService(IMIProcesses.class);
                    if (procService != null && groupId != null && addr != null && count > 0) {
                        IMIContainerDMContext containerDmc = procService.createContainerContextFromGroupId(this.fConnection.getContext(), groupId);
                        final IMemory.IMemoryDMContext memoryDMC = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)containerDmc, IMemory.IMemoryDMContext.class);
                        Addr64 address = new Addr64(addr);
                        this.getMemoryCache(memoryDMC).refreshMemory(memoryDMC, (IAddress)address, 0L, this.getAddressableSize(memoryDMC), count, false, new RequestMonitor((Executor)this.getExecutor(), null, (IAddress)address){
                            private final /* synthetic */ IAddress val$address;
                            {
                                this.val$address = iAddress;
                                super($anonymous0, $anonymous1);
                            }

                            protected void handleCompleted() {
                                GDBMemory_7_6.this.getSession().dispatchEvent((Object)new MIMemory.MemoryChangedEvent(GDBMemory_7_6.this, memoryDMC, new IAddress[]{this.val$address}), GDBMemory_7_6.this.getProperties());
                            }
                        });
                    }
                }
                ++n2;
            }
        }
    }
}

