/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dstore.core.java;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.dstore.core.java.ClassRequest;
import org.eclipse.dstore.core.model.DataStore;

public class RemoteClassLoader
extends ClassLoader {
    public static final String CACHING_PREFERENCE = "Class.Caching";
    private DataStore _dataStore;
    private boolean _useCaching = false;
    private CacheClassLoader _urlClassLoader;

    public RemoteClassLoader(DataStore dataStore) {
        super(dataStore.getClass().getClassLoader());
        this._dataStore = dataStore;
        this.useCaching();
    }

    public boolean useCaching() {
        boolean useCaching = false;
        String pref = "false";
        if (pref != null && pref.equals("true")) {
            useCaching = true;
        }
        if (useCaching != this._useCaching && useCaching && this._dataStore.getRemoteClassLoaderCache() != null) {
            try {
                URL cache = this._dataStore.getRemoteClassLoaderCache().toURL();
                URL[] urls = new URL[]{cache};
                this._urlClassLoader = new CacheClassLoader(urls, (ClassLoader)this);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        this._useCaching = useCaching;
        return this._useCaching;
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        block16: {
            Class<?> theClass;
            this._dataStore.trace("findClass " + className);
            ArrayList localLoaders = this._dataStore.getLocalClassLoaders();
            if (localLoaders != null) {
                theClass = null;
                int i = 0;
                while (i < localLoaders.size()) {
                    try {
                        theClass = ((ClassLoader)localLoaders.get(i)).loadClass(className);
                        if (theClass != null) {
                            return theClass;
                        }
                    }
                    catch (Exception e) {
                        this._dataStore.trace(e);
                    }
                    ++i;
                }
            }
            try {
                theClass = super.findClass(className);
                if (theClass != null) {
                    return theClass;
                }
            }
            catch (Exception e) {
                if (this._useCaching) break block16;
                throw new ClassNotFoundException(className);
            }
        }
        if (className.indexOf(46) == -1) {
            throw new ClassNotFoundException(className);
        }
        this._dataStore.trace("checking class repository...");
        ClassRequest request = (ClassRequest)this._dataStore.getClassRequestRepository().get(className);
        if (request == null) {
            if (this.useCaching()) {
                try {
                    this._dataStore.trace("checking cache");
                    Class theClass = this._urlClassLoader.findCachedClass(className);
                    return theClass;
                }
                catch (Throwable e) {
                    return this.requestClass(className);
                }
            }
            return this.requestClass(className);
        }
        if (!request.isLoaded()) {
            request.waitForResponse();
            if (request.isLoaded()) {
                return request.getLoadedClass();
            }
            throw new ClassNotFoundException(className);
        }
        if (request.isLoaded()) {
            return request.getLoadedClass();
        }
        throw new ClassNotFoundException(className);
    }

    public synchronized void receiveClass(String className, byte[] bytes, int size) {
        Class receivedClass;
        ClassRequest request;
        block18: {
            this._dataStore.trace("receiving " + className);
            request = (ClassRequest)this._dataStore.getClassRequestRepository().get(className);
            if (request != null && request.isLoaded()) {
                return;
            }
            if (size == 0) {
                if (request != null) {
                    request.notifyResponse();
                }
                return;
            }
            receivedClass = null;
            try {
                this._dataStore.trace("defining " + className + "...");
                receivedClass = this.defineClass(className, bytes, 0, size);
                if (receivedClass == null) {
                    try {
                        receivedClass = this.findClass(className);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this._dataStore.trace("...finished defining " + className);
            }
            catch (NoClassDefFoundError e) {
                e.printStackTrace();
                if (request != null) {
                    request.notifyResponse();
                }
                return;
            }
            catch (LinkageError e) {
                e.printStackTrace();
                try {
                    receivedClass = this.loadClass(className);
                }
                catch (NoClassDefFoundError err) {
                    err.printStackTrace();
                    if (request != null) {
                        request.notifyResponse();
                    }
                    return;
                }
                catch (ClassNotFoundException ee) {
                    if (request != null) {
                        request.notifyResponse();
                    }
                    return;
                }
                if (receivedClass != null) break block18;
                if (request != null) {
                    request.notifyResponse();
                }
                return;
            }
        }
        if (request == null) {
            request = new ClassRequest(className, false);
            request.setLoadedClass(receivedClass);
            this._dataStore.getClassRequestRepository().put(className, request);
            return;
        }
        this._dataStore.trace("notifying requesters");
        request.setLoadedClass(receivedClass);
        if (this.useCaching()) {
            this._dataStore.cacheClass(className, bytes, size);
        }
    }

    protected void requestClassInThread(String className) {
        this._dataStore.trace("requesting (in thread)" + className);
        LoadClassThread thread = new LoadClassThread(className);
        thread.start();
    }

    public Class requestClass(String className) throws ClassNotFoundException {
        ClassRequest request = (ClassRequest)this._dataStore.getClassRequestRepository().get(className);
        if (request == null) {
            request = new ClassRequest(className, true);
            this._dataStore.getClassRequestRepository().put(className, request);
            request.setRequested(true);
            this._dataStore.requestClass(className);
            this._dataStore.trace("thread to wait: " + Thread.currentThread().getName());
            if (!request.isLoaded()) {
                request.waitForResponse();
            }
            this._dataStore.trace("thread finished waiting: " + Thread.currentThread().getName());
            if (request.isLoaded()) {
                return request.getLoadedClass();
            }
            this._dataStore.getClassRequestRepository().remove(className);
            throw new ClassNotFoundException(className);
        }
        if (!request.isLoaded()) {
            this._dataStore.trace("requested elsewhere, thread to wait: " + Thread.currentThread().getName());
            if (!request.isLoaded()) {
                request.waitForResponse();
            }
            this._dataStore.trace("requested elsewhere, thread finished waiting: " + Thread.currentThread().getName());
            if (request.isLoaded()) {
                return request.getLoadedClass();
            }
            throw new ClassNotFoundException(className);
        }
        if (request.isLoaded()) {
            return request.getLoadedClass();
        }
        throw new ClassNotFoundException(className);
    }

    public synchronized void loadClassInThread(String className) {
        ClassRequest request = (ClassRequest)this._dataStore.getClassRequestRepository().get(className);
        if (request == null) {
            request = new ClassRequest(className, false);
            this._dataStore.getClassRequestRepository().put(className, request);
            request.setRequested(true);
            this.requestClassInThread(className);
            return;
        }
        if (!request.isLoaded()) {
            return;
        }
        if (request.isLoaded()) {
            return;
        }
    }

    private class CacheClassLoader
    extends URLClassLoader {
        public CacheClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public Class findCachedClass(String className) throws ClassNotFoundException {
            return super.findClass(className);
        }
    }

    protected class LoadClassThread
    extends Thread {
        private String _className;

        public LoadClassThread(String className) {
            this._className = className;
        }

        public void run() {
            RemoteClassLoader.this._dataStore.requestClass(this._className);
        }
    }
}

