/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.tools.jdt.templates;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.AbstractTemplateCompletionProposalComputer;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;

public class E4TemplateCompletionProposalComputer
extends AbstractTemplateCompletionProposalComputer {
    private static final String E4_ANNOTATION_FOCUS = "org.eclipse.e4.ui.di.Focus";
    private static final String E4_ANNOTATION_POSTCONSTRUCT = "jakarta.annotation.PostConstruct";
    private final TemplateEngine fE4TemplateEngine;
    private final TemplateEngine fE4MembersTemplateEngine;
    private final TemplateEngine fE4StatementsTemplateEngine;
    private IJavaProject fCachedJavaProject;
    private boolean fIsE4OnClasspath;

    public E4TemplateCompletionProposalComputer() {
        ContextTypeRegistry templateContextRegistry = JavaPlugin.getDefault().getTemplateContextRegistry();
        this.fE4TemplateEngine = E4TemplateCompletionProposalComputer.createTemplateEngine(templateContextRegistry, "e4");
        this.fE4MembersTemplateEngine = E4TemplateCompletionProposalComputer.createTemplateEngine(templateContextRegistry, "e4-members");
        this.fE4StatementsTemplateEngine = E4TemplateCompletionProposalComputer.createTemplateEngine(templateContextRegistry, "e4-statements");
        JavaCore.addElementChangedListener((IElementChangedListener)new BuildPathChangeListener());
    }

    private static TemplateEngine createTemplateEngine(ContextTypeRegistry templateContextRegistry, String contextTypeId) {
        TemplateContextType contextType = templateContextRegistry.getContextType(contextTypeId);
        Assert.isNotNull((Object)contextType);
        return new TemplateEngine(contextType);
    }

    protected TemplateEngine computeCompletionEngine(JavaContentAssistInvocationContext context) {
        ICompilationUnit unit = context.getCompilationUnit();
        if (unit == null) {
            return null;
        }
        IJavaProject javaProject = unit.getJavaProject();
        if (javaProject == null) {
            return null;
        }
        if (this.isE4OnClasspath(javaProject)) {
            CompletionContext coreContext = context.getCoreContext();
            if (coreContext != null) {
                int tokenLocation = coreContext.getTokenLocation();
                if ((tokenLocation & 1) != 0) {
                    return this.fE4MembersTemplateEngine;
                }
                if ((tokenLocation & 2) != 0) {
                    return this.fE4StatementsTemplateEngine;
                }
            }
            return this.fE4TemplateEngine;
        }
        return null;
    }

    private synchronized boolean isE4OnClasspath(IJavaProject javaProject) {
        if (!javaProject.equals(this.fCachedJavaProject)) {
            this.fCachedJavaProject = javaProject;
            try {
                IType focucAnnotation = javaProject.findType(E4_ANNOTATION_FOCUS);
                IType postConstructAnnotation = javaProject.findType(E4_ANNOTATION_POSTCONSTRUCT);
                this.fIsE4OnClasspath = focucAnnotation != null || postConstructAnnotation != null;
            }
            catch (JavaModelException e) {
                this.fIsE4OnClasspath = false;
            }
        }
        return this.fIsE4OnClasspath;
    }

    private synchronized IJavaProject getCachedJavaProject() {
        return this.fCachedJavaProject;
    }

    private synchronized void setCachedJavaProject(IJavaProject project) {
        this.fCachedJavaProject = project;
    }

    private final class BuildPathChangeListener
    implements IElementChangedListener {
        private BuildPathChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            IJavaElementDelta[] children;
            IJavaProject javaProject = E4TemplateCompletionProposalComputer.this.getCachedJavaProject();
            if (javaProject == null) {
                return;
            }
            IJavaElementDelta[] iJavaElementDeltaArray = children = event.getDelta().getChangedChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta child = iJavaElementDeltaArray[n2];
                if (javaProject.equals(child.getElement()) && this.isClasspathChange(child)) {
                    E4TemplateCompletionProposalComputer.this.setCachedJavaProject(null);
                }
                ++n2;
            }
        }

        private boolean isClasspathChange(IJavaElementDelta delta) {
            int flags = delta.getFlags();
            if (this.isClasspathChangeFlag(flags)) {
                return true;
            }
            if ((flags & 8) != 0) {
                IJavaElementDelta[] children;
                IJavaElementDelta[] iJavaElementDeltaArray = children = delta.getAffectedChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta element = iJavaElementDeltaArray[n2];
                    if (this.isClasspathChangeFlag(element.getFlags())) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        private boolean isClasspathChangeFlag(int flags) {
            if ((flags & 0x200000) != 0) {
                return true;
            }
            if ((flags & 0x40) != 0) {
                return true;
            }
            if ((flags & 0x80) != 0) {
                return true;
            }
            return (flags & 0x8000) != 0;
        }
    }
}

