/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.util;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.parsley.dsl.model.Module;
import org.eclipse.emf.parsley.dsl.model.WithExtendsClause;
import org.eclipse.emf.parsley.dsl.typing.EmfParsleyDslTypeSystem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.typesystem.override.ResolvedFeatures;

public class EmfParsleyDslGuiceModuleHelper {
    @Inject
    private IJvmModelAssociations jvmModelAssociations;
    @Inject
    private OverrideHelper overrideHelper;
    @Inject
    private EmfParsleyDslTypeSystem emfParsleyDslTypeSystem;

    public JvmGenericType getModuleInferredType(Module module) {
        return (JvmGenericType)IterableExtensions.head(this.getInferredJavaTypes(module));
    }

    public Iterable<JvmGenericType> getInferredJavaTypes(EObject o) {
        return IterableExtensions.filter((Iterable)this.jvmModelAssociations.getJvmElements(o), JvmGenericType.class);
    }

    public Iterable<JvmOperation> getAllGuiceValueBindingsMethodsInSuperclass(Module module) {
        return this.getAllGuiceValueBindingsMethodsInSuperclass(this.getModuleInferredType(module));
    }

    public Iterable<JvmOperation> getAllGuiceTypeBindingsMethodsInSuperclass(Module module) {
        return IterableExtensions.filter(this.superTypeJvmOperations(module), it -> it.getSimpleName().startsWith("bind") && IterableExtensions.head((Iterable)((JvmParameterizedTypeReference)it.getReturnType()).getArguments()) != null);
    }

    public Iterable<JvmOperation> getAllGuiceProviderBindingsMethodsInSuperclass(Module module) {
        return IterableExtensions.filter(this.superTypeJvmOperations(module), it -> it.getSimpleName().startsWith("provide"));
    }

    public Iterable<JvmOperation> getAllGuiceValueBindingsMethodsInSuperclass(JvmGenericType type) {
        return IterableExtensions.filter(this.superTypeJvmOperations(type), it -> it.getSimpleName().startsWith("value"));
    }

    public Iterable<JvmGenericType> getAllWithExtendsClauseInferredJavaTypes(Module module) {
        return Iterables.concat((Iterable)IterableExtensions.map(this.getAllWithExtendsClause(module), this::getInferredJavaTypes));
    }

    public Iterable<WithExtendsClause> getAllWithExtendsClause(Module module) {
        return IterableExtensions.filter((Iterable)module.eContents(), WithExtendsClause.class);
    }

    public ResolvedFeatures getJavaResolvedFeatures(JvmGenericType type) {
        return this.overrideHelper.getResolvedFeatures((JvmDeclaredType)type);
    }

    public String getJavaMethodResolvedErasedSignature(IResolvedOperation op) {
        return op.getResolvedErasureSignature();
    }

    public boolean containsConstructorAcceptingPluginParameter(EObject context, JvmTypeReference typeRef) {
        JvmType type = typeRef.getType();
        if (type instanceof JvmGenericType) {
            return IterableExtensions.exists((Iterable)((JvmGenericType)type).getDeclaredConstructors(), it -> it.getParameters().size() == 1 && this.emfParsleyDslTypeSystem.isConformant(context, AbstractUIPlugin.class, ((JvmFormalParameter)IterableExtensions.head((Iterable)it.getParameters())).getParameterType()));
        }
        return false;
    }

    private Iterable<JvmOperation> superTypeJvmOperations(Module module) {
        return this.superTypeJvmOperations(this.getModuleInferredType(module));
    }

    private Iterable<JvmOperation> superTypeJvmOperations(JvmGenericType type) {
        if (type == null) {
            return CollectionLiterals.emptyList();
        }
        return IterableExtensions.filter((Iterable)((JvmGenericType)((JvmTypeReference)IterableExtensions.head((Iterable)type.getSuperTypes())).getType()).getAllFeatures(), JvmOperation.class);
    }
}

