/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.features.impl;

import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IProgress;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.util.IColorConstant;

public abstract class AbstractFeature
implements IFeature {
    private IFeatureProvider fp;
    private IProgress progressCallback;

    public AbstractFeature(IFeatureProvider fp) {
        this.fp = fp;
    }

    @Override
    public boolean canUndo(IContext context) {
        return true;
    }

    @Override
    public boolean hasDoneChanges() {
        return true;
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    @Override
    public IFeatureProvider getFeatureProvider() {
        return this.fp;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean isAvailable(IContext context) {
        return true;
    }

    public void setProgressCallback(IProgress progress) {
        this.progressCallback = progress;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected PictogramElement addGraphicalRepresentation(IAreaContext context, Object newObject) {
        return this.getFeatureProvider().addIfPossible(new AddContext(context, newObject));
    }

    protected Object[] getAllBusinessObjectsForPictogramElement(PictogramElement pe) {
        return this.getFeatureProvider().getAllBusinessObjectsForPictogramElement(pe);
    }

    protected Object getBusinessObjectForPictogramElement(PictogramElement pe) {
        return this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
    }

    protected Diagram getDiagram() {
        return this.getFeatureProvider().getDiagramTypeProvider().getDiagram();
    }

    protected IDiagramBehavior getDiagramBehavior() {
        return this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior();
    }

    protected IProgress getProgressCallback() {
        return this.progressCallback;
    }

    protected boolean getUserDecision() {
        return true;
    }

    protected IReason layoutPictogramElement(PictogramElement pe) {
        LayoutContext context = new LayoutContext(pe);
        return this.getFeatureProvider().layoutIfPossible(context);
    }

    protected void link(PictogramElement pe, Object businessObject) {
        this.link(pe, new Object[]{businessObject});
    }

    protected void link(PictogramElement pe, Object[] businessObjects) {
        this.getFeatureProvider().link(pe, businessObjects);
    }

    protected Color manageColor(IColorConstant colorConstant) {
        return Graphiti.getGaService().manageColor(this.getDiagram(), colorConstant);
    }

    protected Color manageColor(int red, int green, int blue) {
        return Graphiti.getGaService().manageColor(this.getDiagram(), red, green, blue);
    }

    protected Font manageDefaultFont(Diagram diagram) {
        return Graphiti.getGaService().manageDefaultFont(diagram);
    }

    Font manageDefaultFont(Diagram diagram, boolean isItalic, boolean isBold) {
        return Graphiti.getGaService().manageDefaultFont(diagram, isItalic, isBold);
    }

    public Font manageFont(Diagram diagram, String name, int size) {
        return Graphiti.getGaService().manageFont(diagram, name, size);
    }

    public Font manageFont(Diagram diagram, String name, int size, boolean isItalic, boolean isBold) {
        return Graphiti.getGaService().manageFont(diagram, name, size, isItalic, isBold);
    }

    protected void updatePictogramElement(PictogramElement pe) {
        UpdateContext context = new UpdateContext(pe);
        this.getFeatureProvider().updateIfPossible(context);
    }
}

