/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.commands;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.DockerImage;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandMessages;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageTag;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class TagImageCommandHandler
extends AbstractHandler {
    private static final String TAG_IMAGE_JOB_TITLE = "ImageTagTitle.msg";
    private static final String TAG_IMAGE_MSG = "ImageTag.msg";
    private static final String ERROR_TAGGING_IMAGE = "ImageTagError.msg";

    public Object execute(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        List<IDockerImage> selectedImages = CommandUtils.getSelectedImages(activePart);
        IDockerConnection connection = CommandUtils.getCurrentConnection(activePart);
        if (selectedImages.size() != 1 || connection == null) {
            Activator.log(new DockerException(CommandMessages.getString("Command.missing.selection.failure")));
            return null;
        }
        IDockerImage image = selectedImages.get(0);
        ImageTag wizard = new ImageTag(((DockerImage)image).shortId());
        boolean tagImage = CommandUtils.openWizard((IWizard)wizard, HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (tagImage) {
            this.performTagImage(connection, image, wizard.getTag());
        }
        return null;
    }

    private void performTagImage(final IDockerConnection connection, final IDockerImage image, final String tag) {
        Job tagImageJob = new Job(DVMessages.getString(TAG_IMAGE_JOB_TITLE)){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(DVMessages.getFormattedString(TagImageCommandHandler.TAG_IMAGE_MSG, tag), 2);
                try {
                    ((DockerConnection)connection).tagImage(image.id(), tag);
                    monitor.worked(1);
                    ((DockerConnection)connection).getImages(true);
                    monitor.worked(1);
                }
                catch (DockerException e) {
                    Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)DVMessages.getFormattedString(TagImageCommandHandler.ERROR_TAGGING_IMAGE, tag), (String)e.getMessage()));
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        tagImageJob.schedule();
    }
}

