/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.MetaInfMavenScanner;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class MavenArtifactIdentifier {
    private static final ILog LOG = Platform.getLog(MavenArtifactIdentifier.class);

    private MavenArtifactIdentifier() {
    }

    public static Collection<ArtifactKey> identify(File classesLocation) {
        Path location = classesLocation.toPath();
        Set<ArtifactKey> classesArtifacts = MetaInfMavenScanner.scanForPomProperties(location);
        if (classesArtifacts.isEmpty() && (classesArtifacts = MetaInfMavenScanner.scanForPomXml(location)).isEmpty() && MavenArtifactIdentifier.isQueryCentral()) {
            classesArtifacts = MavenArtifactIdentifier.identifyCentralSearch(location);
        }
        return classesArtifacts;
    }

    private static boolean isQueryCentral() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.m2e.core").getBoolean("eclipse.m2.queryCentralToIdentifyArtifact", false);
    }

    private static Set<ArtifactKey> identifyCentralSearch(Path file) {
        String sha1;
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return Set.of();
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
                sha1 = DigestUtils.sha1Hex((InputStream)fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            LOG.log(Status.error((String)("Failed to compute sha1-hash of file: " + file)));
            return Set.of();
        }
        return ArtifactIdCache.IDS.computeIfAbsent(sha1, h -> MavenArtifactIdentifier.lookUpFileHashOnMavenCentral(h, file));
    }

    private static Set<ArtifactKey> lookUpFileHashOnMavenCentral(String sha1, Path file) {
        try {
            HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
            HttpRequest request = HttpRequest.newBuilder(URI.create("https://search.maven.org/solrsearch/select?q=1:" + sha1)).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            JsonObject container = (JsonObject)new Gson().fromJson(response.body(), JsonObject.class);
            JsonArray docs = container.get("response").getAsJsonObject().get("docs").getAsJsonArray();
            return docs.asList().stream().map(JsonElement::getAsJsonObject).map(obj -> {
                String g = obj.get("g").getAsString();
                String a = obj.get("a").getAsString();
                String v = obj.get("v").getAsString();
                return new ArtifactKey(g, a, v, null);
            }).collect(Collectors.toUnmodifiableSet());
        }
        catch (IOException | InterruptedException e) {
            LOG.log(Status.error((String)("Failed to identify file by its hash using search.maven.org: " + file)));
            return Set.of();
        }
    }

    public static Path resolveSourceLocation(ArtifactKey artifact, IProgressMonitor monitor) {
        if (artifact == null) {
            return null;
        }
        String groupId = artifact.groupId();
        String artifactId = artifact.artifactId();
        String version = artifact.version();
        try {
            ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
            IMaven maven = MavenPlugin.getMaven();
            repositories.addAll(maven.getArtifactRepositories());
            repositories.addAll(maven.getPluginArtifactRepositories());
            if (!maven.isUnavailable(groupId, artifactId, version, "jar", "sources", repositories)) {
                Artifact resolve = maven.resolve(groupId, artifactId, version, "jar", "sources", null, monitor);
                return resolve.getFile().toPath().toAbsolutePath();
            }
        }
        catch (CoreException e) {
            LOG.error("Failed to obtain source for artifact " + artifact, (Throwable)e);
        }
        return null;
    }

    private static class ArtifactIdCache {
        static final Map<String, Set<ArtifactKey>> IDS = ArtifactIdCache.loadCachedIds();

        private ArtifactIdCache() {
        }

        private static Map<String, Set<ArtifactKey>> loadCachedIds() {
            Bundle bundle = FrameworkUtil.getBundle(MavenArtifactIdentifier.class);
            Path cacheFile = Platform.getStateLocation((Bundle)bundle).append("artifactIdCache.properties").toFile().toPath();
            bundle.getBundleContext().addBundleListener(event -> {
                if (event.getType() == 4) {
                    ArtifactIdCache.saveCachedIds(cacheFile);
                }
            });
            if (!Files.exists(cacheFile, new LinkOption[0])) {
                return new ConcurrentHashMap<String, Set<ArtifactKey>>();
            }
            Properties persistedCache = new Properties();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream in = Files.newInputStream(cacheFile, new OpenOption[0]);){
                    persistedCache.load(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                LOG.error("Failed to load artifact-id cache", (Throwable)ex);
            }
            return persistedCache.entrySet().stream().collect(Collectors.toConcurrentMap(e -> e.getKey().toString(), e -> ArtifactIdCache.parseArtifactKeys((String)e.getValue())));
        }

        private static void saveCachedIds(Path cacheFile) {
            Properties properties = new Properties(IDS.size() * 4 / 3 + 1);
            IDS.forEach((sha1, keys) -> {
                Object object = properties.setProperty((String)sha1, ArtifactIdCache.persistArtifactKeys(keys));
            });
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (OutputStream out = Files.newOutputStream(cacheFile, new OpenOption[0]);){
                    properties.store(out, "M2E's cached results for looking up artifact-ids on Maven-Central");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                LOG.error("Failed to persist artifact-id cache", (Throwable)ex);
            }
        }

        private static Set<ArtifactKey> parseArtifactKeys(String value) {
            if (value.isBlank()) {
                return Set.of();
            }
            String[] elements = value.strip().split(",");
            return Arrays.stream(elements).map(ArtifactKey::fromPortableString).collect(Collectors.toSet());
        }

        private static String persistArtifactKeys(Set<ArtifactKey> keys) {
            return keys.stream().map(ArtifactKey::toPortableString).collect(Collectors.joining(","));
        }
    }
}

