/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.cli.internal.BootstrapCoreExtensionManager;
import org.apache.maven.cli.internal.ExtensionResolutionException;
import org.apache.maven.cli.internal.extension.model.CoreExtension;
import org.apache.maven.cli.internal.extension.model.io.xpp3.CoreExtensionsXpp3Reader;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.scope.internal.MojoExecutionScopeModule;
import org.apache.maven.extension.internal.CoreExports;
import org.apache.maven.extension.internal.CoreExtensionEntry;
import org.apache.maven.session.scope.internal.SessionScopeModule;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.LoggerManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.embedder.IComponentLookup;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.embedder.ExtensionModule;
import org.eclipse.m2e.core.internal.embedder.IMavenPlexusContainer;
import org.eclipse.m2e.core.internal.embedder.LifecycleManagerDisposer;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.MavenProperties;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

@Component(service={PlexusContainerManager.class})
public class PlexusContainerManager {
    private static final ILog LOG = Platform.getLog(PlexusContainerManager.class);
    private static final String CONTAINER_CONFIGURATION_NAME = "maven";
    private static final String MAVEN_EXTENSION_REALM_PREFIX = "maven.ext.";
    private static final String PLEXUS_CORE_REALM = "plexus.core";
    private IMavenPlexusContainer nonRootedContainer;
    private final Map<File, IMavenPlexusContainer> containerMap = new HashMap<File, IMavenPlexusContainer>();
    @Reference
    private LoggerManager loggerManager;
    @Reference
    private IMavenConfiguration mavenConfiguration;
    @Reference
    private IWorkspace workspace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    void dispose() {
        Map<File, IMavenPlexusContainer> map = this.containerMap;
        synchronized (map) {
            this.containerMap.values().forEach(PlexusContainerManager::disposeContainer);
            this.containerMap.clear();
            if (this.nonRootedContainer != null) {
                PlexusContainerManager.disposeContainer(this.nonRootedContainer);
                this.nonRootedContainer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        Map<File, IMavenPlexusContainer> map = this.containerMap;
        synchronized (map) {
            this.containerMap.entrySet().removeIf(entry -> {
                if (!new File((File)entry.getKey(), ".mvn").isDirectory()) {
                    PlexusContainerManager.disposeContainer((IMavenPlexusContainer)entry.getValue());
                    return true;
                }
                return false;
            });
        }
    }

    private static void disposeContainer(IMavenPlexusContainer mavenPlexusContainer) {
        PlexusContainer plexusContainer = mavenPlexusContainer.getContainer();
        ClassWorld classWorld = plexusContainer.getContainerRealm().getWorld();
        for (ClassRealm realm : classWorld.getRealms()) {
            try {
                classWorld.disposeRealm(realm.getId());
            }
            catch (NoSuchRealmException e) {
                LOG.error("Failed to dispose ClassRealm", (Throwable)e);
            }
        }
        plexusContainer.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMavenPlexusContainer aquire() throws Exception {
        Map<File, IMavenPlexusContainer> map = this.containerMap;
        synchronized (map) {
            this.cleanup();
            if (this.nonRootedContainer == null) {
                this.nonRootedContainer = PlexusContainerManager.newPlexusContainer(null, this.loggerManager, this.mavenConfiguration);
            }
            return this.nonRootedContainer;
        }
    }

    public IMavenPlexusContainer aquire(IResource basedir) throws Exception {
        if (basedir == null || !basedir.isAccessible()) {
            return this.aquire();
        }
        File file = basedir.getLocation().toFile();
        if (file == null) {
            return this.aquire();
        }
        return this.aquire(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMavenPlexusContainer aquire(File basedir) throws Exception {
        File directory = MavenProperties.computeMultiModuleProjectDirectory(basedir);
        if (directory == null) {
            return this.aquire();
        }
        File canonicalDirectory = directory.getCanonicalFile();
        Map<File, IMavenPlexusContainer> map = this.containerMap;
        synchronized (map) {
            this.cleanup();
            IMavenPlexusContainer plexusContainer = this.containerMap.get(canonicalDirectory);
            if (plexusContainer == null) {
                try {
                    plexusContainer = PlexusContainerManager.newPlexusContainer(canonicalDirectory, this.loggerManager, this.mavenConfiguration);
                    this.containerMap.put(canonicalDirectory, plexusContainer);
                }
                catch (ExtensionResolutionException e) {
                    CoreExtension extension = e.getExtension();
                    File file = new File(directory, ".mvn/extensions.xml");
                    throw new PlexusContainerException("can't create plexus container for basedir = " + basedir.getAbsolutePath() + " because the extension " + extension.getGroupId() + ":" + extension.getArtifactId() + ":" + extension.getVersion() + " can't be loaded (defined in " + file.getAbsolutePath() + ").", (Throwable)e);
                }
            }
            return plexusContainer;
        }
    }

    public IComponentLookup getComponentLookup() {
        try {
            return this.aquire().getComponentLookup();
        }
        catch (Exception ex) {
            return new ExceptionalLookup(ex);
        }
    }

    public IComponentLookup getComponentLookup(File basedir) {
        try {
            return this.aquire(basedir).getComponentLookup();
        }
        catch (Exception ex) {
            return new ExceptionalLookup(ex);
        }
    }

    private static IMavenPlexusContainer newPlexusContainer(final File multiModuleProjectDirectory, LoggerManager loggerManager, IMavenConfiguration mavenConfiguration) throws Exception {
        M2EClassWorld classWorld = new M2EClassWorld(PLEXUS_CORE_REALM, ClassWorld.class.getClassLoader(), multiModuleProjectDirectory);
        ClassRealm coreRealm = classWorld.getRealm(PLEXUS_CORE_REALM);
        CoreExtensionEntry coreEntry = CoreExtensionEntry.discoverFrom((ClassRealm)coreRealm);
        List<CoreExtensionEntry> extensions = PlexusContainerManager.loadCoreExtensions(coreRealm, coreEntry, multiModuleProjectDirectory, loggerManager, mavenConfiguration);
        List<File> extClassPath = List.of();
        ClassRealm containerRealm = PlexusContainerManager.setupContainerRealm(coreRealm, extClassPath, extensions);
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld((ClassWorld)classWorld).setRealm(containerRealm).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setName(CONTAINER_CONFIGURATION_NAME);
        HashSet exportedArtifacts = new HashSet(coreEntry.getExportedArtifacts());
        HashSet exportedPackages = new HashSet(coreEntry.getExportedPackages());
        for (CoreExtensionEntry extension : extensions) {
            exportedArtifacts.addAll(extension.getExportedArtifacts());
            exportedPackages.addAll(extension.getExportedPackages());
        }
        final CoreExports exports = new CoreExports(containerRealm, exportedArtifacts, exportedPackages);
        final DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)LoggerFactory.getILoggerFactory());
                this.bind(CoreExports.class).toInstance((Object)exports);
            }
        }, new ExtensionModule()});
        classWorld.addListener(new LifecycleManagerDisposer(container));
        container.setLookupRealm(null);
        Thread thread = Thread.currentThread();
        ClassLoader ccl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader((ClassLoader)container.getContainerRealm());
            container.setLoggerManager(loggerManager);
            for (CoreExtensionEntry extension : extensions) {
                container.discoverComponents(extension.getClassRealm(), new Module[]{new SessionScopeModule((PlexusContainer)container), new MojoExecutionScopeModule((PlexusContainer)container)});
            }
        }
        finally {
            thread.setContextClassLoader(ccl);
        }
        return new IMavenPlexusContainer(){
            private IComponentLookup lookup;

            @Override
            public Optional<File> getMavenDirectory() {
                return Optional.ofNullable(multiModuleProjectDirectory);
            }

            @Override
            public PlexusContainer getContainer() {
                return container;
            }

            @Override
            public IComponentLookup getComponentLookup() {
                if (this.lookup == null) {
                    this.lookup = PlexusContainerManager.wrap(this.getContainer());
                }
                return this.lookup;
            }
        };
    }

    private static ClassRealm setupContainerRealm(ClassRealm coreRealm, List<File> extClassPath, List<CoreExtensionEntry> extensions) throws DuplicateRealmException, MalformedURLException {
        if (extClassPath.isEmpty() && extensions.isEmpty()) {
            return coreRealm;
        }
        ClassRealm extRealm = coreRealm.getWorld().newRealm(MAVEN_EXTENSION_REALM_PREFIX, null);
        extRealm.setParentRealm(coreRealm);
        for (File file : extClassPath) {
            extRealm.addURL(file.toURI().toURL());
        }
        int i = extensions.size() - 1;
        while (i >= 0) {
            CoreExtensionEntry entry = extensions.get(i);
            Set exportedPackages = entry.getExportedPackages();
            ClassRealm realm = entry.getClassRealm();
            for (String exportedPackage : exportedPackages) {
                extRealm.importFrom((ClassLoader)realm, exportedPackage);
            }
            if (exportedPackages.isEmpty()) {
                extRealm.importFrom((ClassLoader)realm, realm.getId());
            }
            --i;
        }
        return extRealm;
    }

    private static List<CoreExtensionEntry> loadCoreExtensions(ClassRealm coreRealm, CoreExtensionEntry coreEntry, File multiModuleProjectDirectory, LoggerManager loggerManager, IMavenConfiguration mavenConfiguration) throws Exception {
        List extensions;
        if (multiModuleProjectDirectory == null) {
            return Collections.emptyList();
        }
        File extensionsXml = new File(multiModuleProjectDirectory, ".mvn/extensions.xml");
        if (!extensionsXml.isFile()) {
            return Collections.emptyList();
        }
        Throwable throwable = null;
        Object var8_8 = null;
        try (FileInputStream is = new FileInputStream(extensionsXml);){
            extensions = new CoreExtensionsXpp3Reader().read((InputStream)is).getExtensions();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (extensions.isEmpty()) {
            return Collections.emptyList();
        }
        ContainerConfiguration cc = new DefaultContainerConfiguration().setClassWorld(coreRealm.getWorld()).setRealm(coreRealm).setClassPathScanning("index").setAutoWiring(true).setJSR250Lifecycle(true).setName(CONTAINER_CONFIGURATION_NAME);
        DefaultPlexusContainer container = new DefaultPlexusContainer(cc, new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(ILoggerFactory.class).toInstance((Object)LoggerFactory.getILoggerFactory());
            }
        }});
        Thread thread = Thread.currentThread();
        ClassLoader ccl = thread.getContextClassLoader();
        try {
            container.setLookupRealm(null);
            container.setLoggerManager(loggerManager);
            thread.setContextClassLoader((ClassLoader)container.getContainerRealm());
            Optional<MavenProperties> mavenProperties = MavenProperties.getMavenArgs(multiModuleProjectDirectory);
            IMavenConfiguration workspaceConfiguration = IMavenConfiguration.getWorkspaceConfiguration();
            MavenExecutionRequest request = MavenExecutionContext.createExecutionRequest(mavenConfiguration, PlexusContainerManager.wrap((PlexusContainer)container), mavenProperties.map(mavenCfg -> mavenCfg.getSettingsLocations(workspaceConfiguration)).orElseGet(workspaceConfiguration::getSettingsLocations), multiModuleProjectDirectory);
            ((MavenExecutionRequestPopulator)container.lookup(MavenExecutionRequestPopulator.class)).populateDefaults(request);
            request.setBaseDirectory(multiModuleProjectDirectory);
            request.setMultiModuleProjectDirectory(multiModuleProjectDirectory);
            Properties userProperties = request.getUserProperties();
            mavenProperties.ifPresent(prop -> prop.getCliProperties(userProperties::setProperty));
            BootstrapCoreExtensionManager resolver = (BootstrapCoreExtensionManager)container.lookup(BootstrapCoreExtensionManager.class);
            List list = resolver.loadCoreExtensions(request, coreEntry.getExportedArtifacts(), extensions);
            return list;
        }
        finally {
            thread.setContextClassLoader(ccl);
            container.dispose();
        }
    }

    public static IComponentLookup wrap(PlexusContainer container) {
        return PlexusContainerManager.wrap(container, container.getContainerRealm());
    }

    public static IComponentLookup wrap(PlexusContainer container, ClassRealm realm) {
        return new PlexusComponentLookup(container, realm);
    }

    private static final class ExceptionalLookup
    implements IComponentLookup {
        private Exception exception;

        public ExceptionalLookup(Exception exception) {
            this.exception = exception;
        }

        @Override
        public <C> C lookup(Class<C> type) throws CoreException {
            throw this.throwException();
        }

        @Override
        public <C> Collection<C> lookupCollection(Class<C> type) throws CoreException {
            throw this.throwException();
        }

        /*
         * WARNING - void declaration
         */
        private CoreException throwException() {
            void coreException;
            CoreException coreException2;
            Exception exception = this.exception;
            return exception instanceof CoreException && (coreException2 = (CoreException)((Object)exception)) == (CoreException)((Object)exception) ? coreException : new CoreException(Status.error((String)"container creation failed", (Throwable)this.exception));
        }
    }

    private static final class M2EClassWorld
    extends ClassWorld {
        private File multiModuleProjectDirectory;

        M2EClassWorld(String plexusCoreRealm, ClassLoader classLoader, File multiModuleProjectDirectory) {
            super(plexusCoreRealm, classLoader);
            this.multiModuleProjectDirectory = multiModuleProjectDirectory;
        }

        public String toString() {
            String name = this.multiModuleProjectDirectory == null ? "GLOBAL" : this.multiModuleProjectDirectory.getAbsolutePath();
            return "ClassWorld [" + name + "] " + this.getRealms().stream().map(ClassRealm::getId).collect(Collectors.joining(", "));
        }
    }

    private static final class PlexusComponentLookup
    implements IComponentLookup {
        private PlexusContainer container;
        private ClassRealm lookupRealm;

        public PlexusComponentLookup(PlexusContainer container, ClassRealm lookupRealm) {
            this.container = container;
            this.lookupRealm = lookupRealm;
        }

        @Override
        public <C> C lookup(Class<C> type) throws CoreException {
            if (type == PlexusContainer.class) {
                return type.cast(this.container);
            }
            Thread thread = Thread.currentThread();
            ClassLoader ccl = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader((ClassLoader)this.lookupRealm);
                Object object = this.container.lookup(type);
                return (C)object;
            }
            catch (ComponentLookupException ex) {
                throw new CoreException(Status.error((String)Messages.MavenImpl_error_lookup, (Throwable)ex));
            }
            finally {
                thread.setContextClassLoader(ccl);
            }
        }

        @Override
        public <C> Collection<C> lookupCollection(Class<C> type) {
            Thread thread = Thread.currentThread();
            ClassLoader ccl = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader((ClassLoader)this.lookupRealm);
                List list = List.copyOf(this.container.lookupList(type));
                return list;
            }
            catch (ComponentLookupException ex) {
                List list = List.of();
                return list;
            }
            finally {
                thread.setContextClassLoader(ccl);
            }
        }
    }
}

