/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client.compat;

import com.google.gerrit.common.data.ApprovalType;
import com.google.gerrit.common.data.ApprovalTypes;
import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gerrit.reviewdb.ChangeMessage;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.internal.gerrit.core.HudsonCommentParser;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.SubmitRecord;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CommitInfo;
import org.eclipse.mylyn.reviews.internal.core.BuildResult;

public class ChangeDetailX
extends ChangeDetail {
    private boolean canRevert;
    private boolean canSubmit;
    private boolean canRebase;
    private boolean canCherryPick;
    private boolean canDeleteDraft;
    private boolean canEdit;
    private Timestamp createdOn;
    private Timestamp lastUpdatedOn;
    protected List<SubmitRecord> submitRecords;
    private Set<ApprovalType> approvalTypes;
    private Map<Integer, CommitInfo[]> parents;
    private LinkedHashMap<String, BuildResult> patchSetBuildStatuses;

    public boolean canRevert() {
        return this.canRevert;
    }

    public boolean canSubmit() {
        return this.canSubmit;
    }

    public boolean canRebase() {
        return this.canRebase;
    }

    public boolean canCherryPick() {
        return this.canCherryPick;
    }

    public boolean canEdit() {
        return this.canEdit;
    }

    public boolean canDeleteDraft() {
        return this.canDeleteDraft;
    }

    public List<SubmitRecord> getSubmitRecords() {
        return this.submitRecords;
    }

    public void setSubmitRecords(List<SubmitRecord> submitRecords) {
        this.submitRecords = submitRecords;
    }

    public Set<ApprovalType> getApprovalTypes() {
        return this.approvalTypes;
    }

    public void setApprovalTypes(Set<ApprovalType> approvalTypes) {
        this.approvalTypes = approvalTypes;
    }

    public Iterable<BuildResult> getPatchSetBuildStatuses() {
        return Set.copyOf(this.patchSetBuildStatuses.values());
    }

    public void convertSubmitRecordsToApprovalTypes(ApprovalTypes knownApprovalTypes) {
        if (this.approvalTypes != null) {
            throw new IllegalStateException();
        }
        if (this.submitRecords == null) {
            return;
        }
        this.approvalTypes = new LinkedHashSet<ApprovalType>();
        for (SubmitRecord record : this.submitRecords) {
            for (SubmitRecord.Label label : record.getLabels()) {
                ApprovalType approvalType = this.findTypeByLabel(knownApprovalTypes, label.getLabel());
                if (approvalType == null) {
                    ApprovalCategory approvalCategory = new ApprovalCategory(new ApprovalCategory.Id(null), label.getLabel());
                    approvalType = new ApprovalType(approvalCategory, Collections.emptyList());
                }
                this.approvalTypes.add(approvalType);
            }
        }
    }

    public List<ChangeMessage> getMessages() {
        HudsonCommentParser commentParser = new HudsonCommentParser();
        List allMessages = super.getMessages();
        ArrayList<ChangeMessage> filteredMessages = new ArrayList<ChangeMessage>();
        LinkedHashMap<String, BuildResult> patchSetBuildResults = new LinkedHashMap<String, BuildResult>();
        for (ChangeMessage message : allMessages) {
            List<BuildResult> results = commentParser.getBuildResult(message.getMessage());
            if (results.size() == 0) {
                filteredMessages.add(message);
                continue;
            }
            for (BuildResult result : results) {
                patchSetBuildResults.put(result.getBuildUrl(), result);
            }
        }
        this.patchSetBuildStatuses = patchSetBuildResults;
        return filteredMessages;
    }

    private ApprovalType findTypeByLabel(ApprovalTypes knownApprovalTypes, String label) {
        if (knownApprovalTypes == null || knownApprovalTypes.getApprovalTypes() == null) {
            return null;
        }
        for (ApprovalType type : knownApprovalTypes.getApprovalTypes()) {
            if (!type.getCategory().getName().equals(label.replace('-', ' '))) continue;
            return type;
        }
        return null;
    }

    public void setDateCreated(Timestamp ts) {
        this.createdOn = ts;
    }

    public void setLastModified(Timestamp ts) {
        this.lastUpdatedOn = ts;
    }

    public Timestamp getDateCreated() {
        return this.createdOn;
    }

    public Timestamp getLastModified() {
        return this.lastUpdatedOn;
    }

    public void setCanSubmit(boolean canSubmit) {
        this.canSubmit = canSubmit;
    }

    public void setCanRebase(boolean canRebase) {
        this.canRebase = canRebase;
    }

    public void setCanCherryPick(boolean canCherryPick) {
        this.canCherryPick = canCherryPick;
    }

    public Map<Integer, CommitInfo[]> getParents() {
        return this.parents;
    }

    public void setParents(Map<Integer, CommitInfo[]> parents) {
        this.parents = parents;
    }
}

