/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.reconciler;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class MultiReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private final List<IReconcilingStrategy> strategies = new CopyOnWriteArrayList<IReconcilingStrategy>();

    public void add(IReconcilingStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException();
        }
        this.strategies.add(strategy);
    }

    public void remove(IReconcilingStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException();
        }
        this.strategies.remove(strategy);
    }

    public boolean contains(IReconcilingStrategy reconcilingStrategy) {
        return this.strategies.contains(reconcilingStrategy);
    }

    /*
     * WARNING - void declaration
     */
    public void initialReconcile() {
        for (IReconcilingStrategy strategy : this.strategies) {
            void rse;
            IReconcilingStrategy iReconcilingStrategy = strategy;
            if (!(iReconcilingStrategy instanceof IReconcilingStrategyExtension)) continue;
            IReconcilingStrategyExtension cfr_ignored_0 = (IReconcilingStrategyExtension)iReconcilingStrategy;
            IReconcilingStrategyExtension cfr_ignored_1 = (IReconcilingStrategyExtension)iReconcilingStrategy;
            rse.initialReconcile();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setProgressMonitor(IProgressMonitor monitor) {
        for (IReconcilingStrategy strategy : this.strategies) {
            void rse;
            IReconcilingStrategy iReconcilingStrategy = strategy;
            if (!(iReconcilingStrategy instanceof IReconcilingStrategyExtension)) continue;
            IReconcilingStrategyExtension cfr_ignored_0 = (IReconcilingStrategyExtension)iReconcilingStrategy;
            IReconcilingStrategyExtension cfr_ignored_1 = (IReconcilingStrategyExtension)iReconcilingStrategy;
            rse.setProgressMonitor(monitor);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        for (IReconcilingStrategy strategy : this.strategies) {
            strategy.reconcile(dirtyRegion, subRegion);
        }
    }

    public void reconcile(IRegion partition) {
        for (IReconcilingStrategy strategy : this.strategies) {
            strategy.reconcile(partition);
        }
    }

    public void setDocument(IDocument document) {
        for (IReconcilingStrategy strategy : this.strategies) {
            strategy.setDocument(document);
        }
    }
}

