/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.event;

import java.util.concurrent.ExecutorService;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.ThrowableEvent;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class Notifier
implements INotifier.INotifier2 {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, Notifier.class);
    private final ConcurrentArray<IListener> listeners = new ConcurrentArray<IListener>(){

        protected IListener[] newArray(int length) {
            return new IListener[length];
        }

        @Override
        protected void elementAdded(IListener element) {
            Notifier.this.listenerAdded(element);
        }

        @Override
        protected void elementRemoved(IListener element) {
            Notifier.this.listenerRemoved(element);
        }

        @Override
        protected void firstElementAdded() {
            Notifier.this.firstListenerAdded();
        }

        @Override
        protected void lastElementRemoved() {
            Notifier.this.lastListenerRemoved();
        }
    };

    @Override
    public boolean addUniqueListener(IListener listener) {
        CheckUtil.checkArg(listener, "listener");
        if (this.listeners.addUnique(listener)) {
            if (listener instanceof IListener.NotifierAware) {
                ((IListener.NotifierAware)listener).addNotifier(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public void addListener(IListener listener) {
        CheckUtil.checkArg(listener, "listener");
        this.listeners.add(listener);
        if (listener instanceof IListener.NotifierAware) {
            ((IListener.NotifierAware)listener).addNotifier(this);
        }
    }

    @Override
    public void removeListener(IListener listener) {
        CheckUtil.checkArg(listener, "listener");
        if (listener instanceof IListener.NotifierAware) {
            ((IListener.NotifierAware)listener).removeNotifier(this);
        }
        this.listeners.remove(listener);
    }

    @Override
    public boolean hasListener(IListener listener) {
        CheckUtil.checkArg(listener, "listener");
        return this.listeners.contains(listener);
    }

    @Override
    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    @Override
    public IListener[] getListeners() {
        return this.listeners.get();
    }

    public void fireEvent() {
        this.fireEvent(new Event(this));
    }

    public void fireEvent(IEvent event) {
        if (event != null) {
            this.fireEvent(event, this.getListeners());
        }
    }

    public void fireEvent(final IEvent event, final IListener[] listeners) {
        if (event != null && listeners.length != 0) {
            ExecutorService notificationService = this.getNotificationService();
            if (notificationService != null) {
                notificationService.execute(new Runnable(){

                    @Override
                    public void run() {
                        Notifier.fireEventSafe(event, listeners);
                    }
                });
            } else {
                Notifier.fireEventSafe(event, listeners);
            }
        }
    }

    protected void fireThrowable(Throwable throwable) {
        IListener[] listeners;
        if (TRACER.isEnabled()) {
            TRACER.trace(throwable);
        }
        if ((listeners = this.getListeners()).length != 0) {
            ThrowableEvent event = new ThrowableEvent(this, throwable);
            this.fireEvent(event, listeners);
        }
    }

    protected ExecutorService getNotificationService() {
        return null;
    }

    protected void listenerAdded(IListener listener) {
    }

    protected void listenerRemoved(IListener listener) {
    }

    protected void firstListenerAdded() {
    }

    protected void lastListenerRemoved() {
    }

    private static void fireEventSafe(IEvent event, IListener[] listeners) {
        int i = 0;
        while (i < listeners.length) {
            IListener listener = listeners[i];
            try {
                if (listener != null) {
                    listener.notifyEvent(event);
                }
            }
            catch (Exception ex) {
                OM.LOG.warn(listener + " failed to process " + event + ": " + ex, ex);
            }
            ++i;
        }
    }
}

