/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.builders.BuildErrorReporter;
import org.eclipse.pde.internal.core.builders.BundleErrorReporter;
import org.eclipse.pde.internal.core.builders.CompilerFlags;
import org.eclipse.pde.internal.core.builders.DefaultSAXParser;
import org.eclipse.pde.internal.core.builders.ExtensionsErrorReporter;
import org.eclipse.pde.internal.core.builders.FragmentErrorReporter;
import org.eclipse.pde.internal.core.builders.PDEBuilderHelper;
import org.eclipse.pde.internal.core.builders.PluginErrorReporter;
import org.eclipse.pde.internal.core.project.PDEProject;

public class ManifestConsistencyChecker
extends IncrementalProjectBuilder {
    private static final int MANIFEST = 1;
    private static final int EXTENSIONS = 2;
    private static final int BUILD = 4;
    private static final int STRUCTURE = 8;
    static final IPath SETTINGS_PATH = IPath.fromOSString((String)".settings");
    private static IProject[] EMPTY_LIST = new IProject[0];
    private final SelfVisitor fSelfVisitor = new SelfVisitor();
    private static final boolean DISABLE_AUTO_BUILDING_ON_SETTINGS_CHANGE = Boolean.getBoolean("org.eclipse.disableAutoBuildOnSettingsChange");
    private final ClassChangeVisitor fClassFileVisitor = new ClassChangeVisitor();

    private boolean isLocalizationFile(IResource file) {
        return file.equals((Object)PDEProject.getLocalizationFile(this.getProject()));
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        int type;
        if (PDECore.getDefault().getBundle().getState() != 32 || monitor.isCanceled()) {
            return EMPTY_LIST;
        }
        IProject project = this.getProject();
        if (!WorkspaceModelManager.isBinaryProject(project) && (type = this.getDeltaType(project)) != 0) {
            this.validateProject(type, monitor);
        }
        return EMPTY_LIST;
    }

    private int getDeltaType(IProject project) throws CoreException {
        IResourceDelta delta = this.getDelta(project);
        if (delta == null) {
            if (PDECore.DEBUG_VALIDATION) {
                System.out.println("Project [" + this.getProject().getName() + "] - full build");
            }
            return 15;
        }
        if (Boolean.TRUE.equals(project.getSessionProperty(PDECore.TOUCH_PROJECT))) {
            project.setSessionProperty(PDECore.TOUCH_PROJECT, null);
            if (PDECore.DEBUG_VALIDATION) {
                System.out.println("Dependencies Changed: Project [" + this.getProject().getName() + "] - full build");
            }
            return 7;
        }
        this.fSelfVisitor.reset();
        delta.accept((IResourceDeltaVisitor)this.fSelfVisitor);
        int type = this.fSelfVisitor.getType();
        if ((type & 1 | 2) != 3) {
            this.fClassFileVisitor.reset();
            delta.accept((IResourceDeltaVisitor)this.fClassFileVisitor);
            if (this.fClassFileVisitor.hasChanged()) {
                type |= 7;
                if (PDECore.DEBUG_VALIDATION) {
                    System.out.println("Class files changed due to dependency changes: Project [" + this.getProject().getName() + "] - rebuild manifest and properties files");
                }
            }
        }
        return type;
    }

    private void validateProject(int type, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)PDECoreMessages.ManifestConsistencyChecker_builderTaskName, (int)this.getWorkAmount(type));
        if ((type & 8) != 0) {
            this.validateProjectStructure(type, (IProgressMonitor)subMonitor.split(1));
        }
        if ((type & 3) != 0) {
            IFile manifestFile;
            IProject project = this.getProject();
            IFile file = PDEProject.getPluginXml(project);
            if (!file.exists()) {
                file = PDEProject.getFragmentXml(project);
            }
            if (file.exists()) {
                this.validateFiles(file, type, monitor);
            } else if ((type & 1) != 0 && (manifestFile = PDEProject.getManifest(project)).exists()) {
                this.validateManifestFile(manifestFile, (IProgressMonitor)subMonitor.split(1));
            }
        }
        if ((type & 4) != 0) {
            this.validateBuildProperties((IProgressMonitor)subMonitor.split(1));
        }
    }

    private int getWorkAmount(int type) {
        int work = 1;
        if ((type & 3) != 0) {
            ++work;
        }
        if ((type & 4) != 0) {
            ++work;
        }
        return work;
    }

    private void validateProjectStructure(int type, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.pde.core.problem", false, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.validateBuildPropertiesExists(project);
        this.validateManifestCasing(project);
    }

    private void validateManifestFile(IFile file, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        String message = NLS.bind((String)PDECoreMessages.Builders_verifying, (Object)file.getFullPath().toString());
        monitor.subTask(message);
        BundleErrorReporter reporter = new BundleErrorReporter(file);
        reporter.validateContent(monitor);
        monitor.subTask(PDECoreMessages.Builders_updating);
        monitor.done();
    }

    private void validateFiles(IFile file, int type, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        String message = NLS.bind((String)PDECoreMessages.Builders_verifying, (Object)file.getFullPath().toString());
        monitor.subTask(message);
        IFile bundleManifest = PDEProject.getManifest(this.getProject());
        ExtensionsErrorReporter reporter = null;
        BundleErrorReporter bundleReporter = null;
        if (bundleManifest.exists()) {
            if ((type & 2) != 0) {
                reporter = new ExtensionsErrorReporter(file);
            }
            if ((type & 1) != 0) {
                bundleReporter = new BundleErrorReporter(bundleManifest);
            }
        } else if ((type & 1) != 0 || (type & 2) != 0) {
            if (file.equals((Object)PDEProject.getPluginXml(this.getProject()))) {
                reporter = new PluginErrorReporter(file);
            } else if (file.equals((Object)PDEProject.getFragmentXml(this.getProject()))) {
                reporter = new FragmentErrorReporter(file);
            }
        }
        if (reporter != null) {
            DefaultSAXParser.parse(file, reporter);
            reporter.validateContent(monitor);
            monitor.subTask(PDECoreMessages.Builders_updating);
        }
        if (bundleReporter != null) {
            bundleReporter.validateContent(monitor);
            monitor.subTask(PDECoreMessages.Builders_updating);
        }
        monitor.done();
    }

    private void validateBuildProperties(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        IProject project = this.getProject();
        IFile file = PDEProject.getBuildProperties(project);
        if (file.exists()) {
            monitor.subTask(PDECoreMessages.ManifestConsistencyChecker_buildPropertiesSubtask);
            BuildErrorReporter ber = new BuildErrorReporter(file);
            ber.validateContent(monitor);
        }
    }

    private void validateBuildPropertiesExists(IProject project) {
        IFile file = PDEProject.getBuildProperties(project);
        if (!file.exists()) {
            int severity = CompilerFlags.getFlag(project, "compilers.p.build");
            if (severity == 2) {
                return;
            }
            try {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("severity", severity == 0 ? 2 : 1);
                attributes.put("message", PDECoreMessages.ManifestConsistencyChecker_buildDoesNotExist);
                attributes.put("compilerKey", "compilers.p.build");
                project.createMarker("org.eclipse.pde.core.problem", attributes);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private void validateManifestCasing(IProject project) {
        IFolder manifestFolder = PDEProject.getMetaInf(project);
        if (manifestFolder.exists()) {
            try {
                manifestFolder.deleteMarkers("org.eclipse.pde.core.problem", false, 1);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (PDEProject.getManifest(project).exists()) {
                return;
            }
            IPath location = manifestFolder.getLocation();
            if (location != null) {
                File metaFolder = location.toFile();
                String[] fileList = metaFolder.list(new ManifestFilter());
                if (fileList == null || fileList.length == 0) {
                    try {
                        project.createMarker("org.eclipse.pde.core.problem", Map.of("severity", 2, "message", PDECoreMessages.ManifestConsistencyChecker_manifestDoesNotExist));
                    }
                    catch (CoreException coreException) {}
                } else {
                    String[] stringArray = fileList;
                    int n = fileList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fileName = stringArray[n2];
                        IFile currentFile = manifestFolder.getFile(fileName);
                        try {
                            IMarker marker = currentFile.createMarker("org.eclipse.pde.core.problem");
                            marker.setAttribute("severity", 2);
                            marker.setAttribute("message", (Object)PDECoreMessages.ManifestConsistencyChecker_manifestMisspelled);
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)PDECoreMessages.ManifestConsistencyChecker_0, (Object)this.getProject().getName()), (int)1);
        this.cleanProblems((IResource)this.getProject(), 0);
        IFile manifestFile = PDEProject.getManifest(this.getProject());
        this.cleanProblems((IResource)manifestFile.getParent(), 1);
        this.cleanProblems((IResource)PDEProject.getPluginXml(this.getProject()), 0);
        this.cleanProblems((IResource)PDEProject.getFragmentXml(this.getProject()), 0);
        this.cleanProblems((IResource)PDEProject.getBuildProperties(this.getProject()), 0);
        localmonitor.split(1);
    }

    private void cleanProblems(IResource resource, int depth) throws CoreException {
        if (resource.exists()) {
            resource.deleteMarkers("org.eclipse.pde.core.problem", true, depth);
        }
    }

    public ISchedulingRule getRule(int kind, Map<String, String> args) {
        return new MultiRule((ISchedulingRule[])Arrays.stream(this.getProject().getWorkspace().getRoot().getProjects()).filter(PDEBuilderHelper::isPDEProject).toArray(ISchedulingRule[]::new));
    }

    static class ClassChangeVisitor
    implements IResourceDeltaVisitor {
        boolean hasChanged = false;
        boolean veto = false;

        ClassChangeVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            int kind;
            if (delta != null && !this.veto && (kind = delta.getKind()) == 4) {
                IResource resource = delta.getResource();
                if (resource instanceof IFile) {
                    String extension = resource.getFileExtension();
                    if ("java".equals(extension)) {
                        this.veto = true;
                    } else if ("class".equals(extension) && !this.hasChanged) {
                        this.hasChanged = true;
                    }
                }
                return !this.veto;
            }
            return false;
        }

        public void reset() {
            this.veto = false;
            this.hasChanged = false;
        }

        public boolean hasChanged() {
            return this.hasChanged && !this.veto;
        }
    }

    static class ManifestFilter
    implements FilenameFilter {
        ManifestFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.equalsIgnoreCase("MANIFEST.MF");
        }
    }

    class SelfVisitor
    implements IResourceDeltaVisitor {
        int type = 0;

        SelfVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta != null && delta.findMember(SETTINGS_PATH) != null && !DISABLE_AUTO_BUILDING_ON_SETTINGS_CHANGE) {
                this.type |= 0xF;
            }
            if (delta != null && this.type != 15) {
                int kind = delta.getKind();
                if (kind == 1 || kind == 2) {
                    this.type = 15;
                    if (PDECore.DEBUG_VALIDATION) {
                        System.out.print("Needs to rebuild project [" + ManifestConsistencyChecker.this.getProject().getName() + "]: ");
                        System.out.print(delta.getResource().getProjectRelativePath().toString());
                        System.out.print(" - ");
                        System.out.println(kind == 1 ? "added" : "removed");
                    }
                    return false;
                }
                IResource resource = delta.getResource();
                if (resource.isDerived()) {
                    return false;
                }
                if (resource.getType() == 1) {
                    IFile file = (IFile)resource;
                    IProject project = file.getProject();
                    String name = resource.getName();
                    if (ManifestConsistencyChecker.this.isLocalizationFile(resource)) {
                        this.type |= 3;
                        if (PDECore.DEBUG_VALIDATION) {
                            System.out.print("Needs to rebuild manifest and extensions in project [" + ManifestConsistencyChecker.this.getProject().getName() + "]: ");
                            System.out.print(delta.getResource().getProjectRelativePath().toString());
                            System.out.println(" - changed");
                        }
                    } else if (file.equals((Object)PDEProject.getManifest(project))) {
                        this.type |= 7;
                        if (PDECore.DEBUG_VALIDATION) {
                            System.out.print("Needs to rebuild project [" + ManifestConsistencyChecker.this.getProject().getName() + "]: ");
                            System.out.print(delta.getResource().getProjectRelativePath().toString());
                            System.out.println(" - changed");
                        }
                    } else if (name.endsWith(".exsd") || file.equals((Object)PDEProject.getPluginXml(project)) || file.equals((Object)PDEProject.getFragmentXml(project))) {
                        this.type |= 6;
                        if (PDECore.DEBUG_VALIDATION) {
                            System.out.print("Needs to rebuild project [" + ManifestConsistencyChecker.this.getProject().getName() + "]: ");
                            System.out.print(delta.getResource().getProjectRelativePath().toString());
                            System.out.println(" - changed");
                        }
                    } else if (file.equals((Object)PDEProject.getBuildProperties(project))) {
                        this.type |= 4;
                        if (PDECore.DEBUG_VALIDATION) {
                            System.out.print("Needs to rebuild build.properties in project [" + ManifestConsistencyChecker.this.getProject().getName() + "]: ");
                            System.out.print(delta.getResource().getProjectRelativePath().toString());
                            System.out.println(" - changed");
                        }
                    }
                }
            }
            return this.type != 15;
        }

        public int getType() {
            return this.type;
        }

        public void reset() {
            this.type = 0;
        }
    }
}

