/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.sync;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.DragAndDropTargetQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingsListVisitor;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DNodeCandidate;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.model.business.internal.query.DSemanticDecoratorQuery;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class MappingsUpdater {
    private DDiagram diagram;
    private DiagramMappingsManager mappingsManager;
    private DDiagramSynchronizer synchronizer;
    private RefreshIdsHolder ids;

    public MappingsUpdater(DDiagram diagram, DiagramMappingsManager mappingsManager, DDiagramSynchronizer synchronizer, RefreshIdsHolder ids) {
        this.diagram = diagram;
        this.mappingsManager = mappingsManager;
        this.synchronizer = synchronizer;
        this.ids = ids;
    }

    public void updateMappings() {
        this.updateMappings((DragAndDropTarget)this.diagram);
    }

    private void updateMappings(DragAndDropTarget container) {
        if (container instanceof DSemanticDecorator) {
            DSemanticDecorator dSemanticDecorator = (DSemanticDecorator)container;
            if (!new DSemanticDecoratorQuery(dSemanticDecorator).hasDetachedTarget()) {
                this.safeUpdateMappings(container);
            }
        } else {
            this.safeUpdateMappings(container);
        }
    }

    private void safeUpdateMappings(DragAndDropTarget container) {
        this.mappingsManager.iterate(new MappingUpdateVisitor(container, this.ids), container);
        for (DDiagramElement dDiagramElement : DragAndDropTargetQuery.on(container).getLogicalChildren()) {
            if (!(dDiagramElement instanceof DragAndDropTarget)) continue;
            this.updateMappings((DragAndDropTarget)dDiagramElement);
        }
    }

    private class MappingUpdateVisitor
    implements MappingsListVisitor {
        private DragAndDropTarget container;
        private RefreshIdsHolder factory;

        MappingUpdateVisitor(DragAndDropTarget container, RefreshIdsHolder factory) {
            this.container = container;
            this.factory = factory;
        }

        @Override
        public Set<DNodeCandidate> visit(DiagramElementMapping pMapping, Set<DNodeCandidate> candidateFilter) {
            HashSet result;
            if (pMapping instanceof AbstractNodeMapping) {
                final AbstractNodeMapping mapping = (AbstractNodeMapping)pMapping;
                Collection<DNodeCandidate> validCandidates = this.getNodeCandidates(mapping, candidateFilter);
                HashSet<EObject> semanticElementsDone = new HashSet<EObject>();
                if (!validCandidates.isEmpty()) {
                    HashSet validSemantics = Sets.newHashSet((Iterable)Iterables.transform(validCandidates, (Function)new Function<DNodeCandidate, EObject>(){

                        public EObject apply(DNodeCandidate from) {
                            return from.getSemantic();
                        }
                    }));
                    for (DDiagramElement dDiagramElement : DragAndDropTargetQuery.on(this.container).getLogicalChildren()) {
                        DiagramElementMapping elementMapping = dDiagramElement.getDiagramElementMapping();
                        EObject semanticElement = dDiagramElement.getTarget();
                        if (!(elementMapping instanceof AbstractNodeMapping) || semanticElement == null || !validSemantics.contains(semanticElement) || !new DiagramElementMappingQuery(elementMapping).areInSameHiearchy((DiagramElementMapping)mapping)) continue;
                        LayerHelper.updateActualMapping(dDiagramElement, (DiagramElementMapping)mapping);
                        semanticElementsDone.add(semanticElement);
                    }
                }
                result = Sets.newHashSet((Iterable)Iterables.transform(semanticElementsDone, (Function)new Function<EObject, DNodeCandidate>(){

                    public DNodeCandidate apply(EObject from) {
                        return new DNodeCandidate(mapping, from, MappingUpdateVisitor.this.container, MappingUpdateVisitor.this.factory);
                    }
                }));
            } else {
                result = Collections.emptySet();
            }
            return result;
        }

        private Set<DNodeCandidate> getHierarchyCandidateFilter(final AbstractNodeMapping mapping, Set<DNodeCandidate> semanticFilter) {
            final DiagramElementMappingQuery diagramElementMappingQuery = new DiagramElementMappingQuery((DiagramElementMapping)mapping);
            final HashMap knownMappingHierarchy = new HashMap();
            return Sets.newLinkedHashSet((Iterable)Iterables.transform(semanticFilter, (Function)new Function<DNodeCandidate, DNodeCandidate>(){

                public DNodeCandidate apply(DNodeCandidate from) {
                    boolean areInSameHiearchy;
                    DNodeCandidate result = from;
                    AbstractNodeMapping fromMapping = from.getMapping();
                    if (!knownMappingHierarchy.containsKey(fromMapping)) {
                        areInSameHiearchy = diagramElementMappingQuery.areInSameHiearchy((DiagramElementMapping)fromMapping);
                        knownMappingHierarchy.put(fromMapping, areInSameHiearchy);
                    } else {
                        areInSameHiearchy = (Boolean)knownMappingHierarchy.get(fromMapping);
                    }
                    if (areInSameHiearchy) {
                        result = new DNodeCandidate(mapping, from.getSemantic(), MappingUpdateVisitor.this.container, MappingUpdateVisitor.this.factory);
                    }
                    return result;
                }
            }));
        }

        private Collection<DNodeCandidate> getNodeCandidates(AbstractNodeMapping mapping, Set<DNodeCandidate> candidateFilter) {
            Collection<DNodeCandidate> result;
            Set<DNodeCandidate> hierarchyCandidateFilter = this.getHierarchyCandidateFilter(mapping, candidateFilter);
            if (!new DiagramElementMappingQuery((DiagramElementMapping)mapping).isSynchronizedAndCreateElement(MappingsUpdater.this.diagram)) {
                MappingsUpdater.this.synchronizer.forceRetrieve();
                Collection<DNodeCandidate> candidates = MappingsUpdater.this.synchronizer.computeNodeCandidates(this.container, mapping, hierarchyCandidateFilter);
                MappingsUpdater.this.synchronizer.resetforceRetrieve();
                result = candidates;
            } else {
                result = MappingsUpdater.this.synchronizer.computeNodeCandidates(this.container, mapping, hierarchyCandidateFilter);
            }
            return result;
        }
    }
}

