/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.ui.providers;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.swing.databinding.Activator;
import org.eclipse.wb.internal.swing.databinding.model.bindings.AutoBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.BindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.ColumnBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.DetailBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.JComboBoxBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.JListBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.JTableBindingInfo;
import org.eclipse.wb.internal.swing.databinding.model.bindings.VirtualBindingInfo;

public final class BindingLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final ImageDescriptor AUTO_BINDING_IMAGE = Activator.getImageDescriptor("autobinding2.png");
    private static final ImageDescriptor JLIST_BINDING_IMAGE = Activator.getImageDescriptor("JList.gif");
    private static final ImageDescriptor JLIST_DETAIL_BINDING_IMAGE = Activator.getImageDescriptor("JListDetail2.png");
    private static final ImageDescriptor JCOMBO_BOX_BINDING_IMAGE = Activator.getImageDescriptor("JComboBox.gif");
    private static final ImageDescriptor JTABLE_BINDING_IMAGE = Activator.getImageDescriptor("JTable.gif");
    private static final ImageDescriptor JTABLE_COLUMN_BINDING_IMAGE = Activator.getImageDescriptor("JTableColumnBinding.png");
    private final ResourceManager m_resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public void dispose() {
        super.dispose();
        this.m_resourceManager.dispose();
    }

    public String getColumnText(Object element, int column) {
        return BindingLabelProvider.getText(element, column);
    }

    public static String getText(Object element, int column) {
        return (String)ExecutionUtils.runObjectLog(() -> {
            BindingInfo binding = (BindingInfo)((Object)((Object)element));
            switch (column) {
                case 1: {
                    return binding.getTargetPresentationText(true);
                }
                case 2: {
                    return binding.getModelPresentationText(true);
                }
                case 3: {
                    BindingInfo bindingInfo = binding;
                    if (bindingInfo instanceof AutoBindingInfo) {
                        void autoBinding;
                        AutoBindingInfo autoBindingInfo = (AutoBindingInfo)bindingInfo;
                        AutoBindingInfo cfr_ignored_0 = (AutoBindingInfo)bindingInfo;
                        return autoBinding.getStrategyInfo().getStrategyValue();
                    }
                    return null;
                }
                case 4: {
                    String variable = binding.getVariableIdentifier();
                    if (variable == null) break;
                    String name = binding.getName();
                    if (StringUtils.isEmpty((CharSequence)name)) {
                        return variable;
                    }
                    return variable + " - " + name;
                }
            }
            return null;
        }, (Object)"<exception, see log>");
    }

    public Image getColumnImage(Object element, int column) {
        if (column == 0) {
            return this.m_resourceManager.createImageWithDefault(BindingLabelProvider.getIcon(element));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static ImageDescriptor getIcon(Object element) {
        if (element instanceof JListBindingInfo) {
            return JLIST_BINDING_IMAGE;
        }
        if (element instanceof DetailBindingInfo) {
            return JLIST_DETAIL_BINDING_IMAGE;
        }
        if (element instanceof JComboBoxBindingInfo) {
            return JCOMBO_BOX_BINDING_IMAGE;
        }
        if (element instanceof JTableBindingInfo) {
            return JTABLE_BINDING_IMAGE;
        }
        if (element instanceof ColumnBindingInfo) {
            return JTABLE_COLUMN_BINDING_IMAGE;
        }
        if (element instanceof AutoBindingInfo) {
            return AUTO_BINDING_IMAGE;
        }
        Object object = element;
        if (object instanceof VirtualBindingInfo) {
            void binding;
            VirtualBindingInfo virtualBindingInfo = (VirtualBindingInfo)((Object)object);
            VirtualBindingInfo cfr_ignored_0 = (VirtualBindingInfo)((Object)object);
            switch (binding.getSwingType()) {
                case JListBinding: {
                    return JLIST_BINDING_IMAGE;
                }
                case JTableBinding: {
                    return JTABLE_BINDING_IMAGE;
                }
                case JComboBoxBinding: {
                    return JCOMBO_BOX_BINDING_IMAGE;
                }
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof VirtualBindingInfo) {
            return Display.getCurrent().getSystemColor(16);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

