/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import java.util.Map;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionFailException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionNotApplicableException;
import org.eclipse.wst.wsi.internal.core.analyzer.AssertionPassException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;

public class SSBP1003
extends AssertionProcess {
    protected final BaseMessageValidator validator;

    public SSBP1003(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            String httpHeader = entryContext.getMessageEntry().getHTTPHeaders();
            Map httpHeaderMap = HTTPUtils.getHttpHeaderTokens(httpHeader, ":");
            String contentType = (String)httpHeaderMap.get("Content-Type".toUpperCase());
            if (contentType == null) {
                throw new AssertionFailException("The Content-Type header is not present.");
            }
            contentType = contentType.trim();
            String charset = contentType.substring(contentType.indexOf(";") + 1, contentType.length());
            if (!(charset = charset.trim()).startsWith("charset")) {
                throw new AssertionFailException("Missing or bad \"charset\" attribute in the Content-Type header: " + charset);
            }
            String charsetValue = charset.substring(charset.indexOf("=") + 1, charset.length());
            if (charsetValue.startsWith("\"")) {
                charsetValue = charsetValue.substring(1, charsetValue.length() - 1);
            }
            if (!charsetValue.equalsIgnoreCase("utf-8") && !charsetValue.equalsIgnoreCase("utf-16")) {
                throw new AssertionFailException("The value of the \"charset\" attribute of the Content-Type header is " + contentType);
            }
            int idx = entryContext.getMessageEntry().getMessage().indexOf("<?xml");
            if (idx == -1) {
                throw new AssertionPassException();
            }
            int idx2 = entryContext.getMessageEntry().getMessage().indexOf("?>");
            if (idx2 == -1) {
                throw new AssertionPassException();
            }
            String xmlDeclaration = entryContext.getMessageEntry().getMessage().substring(idx, idx2 + "?>".length());
            idx = xmlDeclaration.indexOf("encoding");
            if (idx == -1) {
                if (charsetValue.equalsIgnoreCase("utf-8")) {
                    throw new AssertionPassException();
                }
                throw new AssertionFailException("There is no XML declaration and the charset value in the Content-Type header is not UTF-8.\nCharset value in the Content-Type header: " + charsetValue);
            }
            int idxQ = xmlDeclaration.indexOf(39, idx);
            int idxQQ = xmlDeclaration.indexOf(34, idx);
            int idxQuote = -1;
            int qouteCh = 0;
            if (idxQ == -1) {
                idxQuote = idxQQ;
                qouteCh = 34;
            } else if (idxQQ == -1) {
                idxQuote = idxQ;
                qouteCh = 39;
            } else if (idxQQ < idxQ) {
                idxQuote = idxQQ;
                qouteCh = 34;
            } else {
                idxQuote = idxQ;
                qouteCh = 39;
            }
            if (idxQuote == -1 || qouteCh == 0) {
                throw new AssertionPassException();
            }
            int idxLQoute = xmlDeclaration.indexOf(qouteCh, idxQuote + 1);
            if (idxLQoute == -1) {
                throw new AssertionPassException();
            }
            String xmlEncoding = xmlDeclaration.substring(idxQuote + 1, idxLQoute);
            if (charsetValue.equalsIgnoreCase(xmlEncoding)) {
                int bom = 0;
                bom = entryContext.getMessageEntry().getBOM();
                if (bom != 0 && (bom == 0xEFBBBF && !xmlEncoding.equalsIgnoreCase("utf-8") || bom == 65534 && !xmlEncoding.equalsIgnoreCase("utf-16") || bom == 65279 && !xmlEncoding.equalsIgnoreCase("utf-16"))) {
                    throw new AssertionFailException("The BOM and XML declaration do not match.");
                }
                throw new AssertionPassException();
            }
            throw new AssertionFailException("There is an XML declaration, but its encoding value does not match the charset value.\nCharset value in the Content-Type header: " + charsetValue + "\nEncoding in the XML declaration: " + xmlEncoding);
        }
        catch (AssertionPassException assertionPassException) {
            this.result = "passed";
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException afe) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(afe.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

