/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adapters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xsd.ui.internal.adapters.CategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.RedefineCategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDRedefineAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDSchemaAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDSchemaDirectiveAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.actions.SetInputToGraphView;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IADTObject;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ITreeElement;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDRedefineContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class XSDRedefineAdapter
extends XSDSchemaDirectiveAdapter {
    protected List types = null;
    protected List children;
    protected List allChildren;
    protected CategoryAdapter attributesCategory;
    protected CategoryAdapter typesCategory;
    protected CategoryAdapter groupsCategory;

    public ITreeElement[] getChildren() {
        XSDRedefine xsdRedefine = (XSDRedefine)this.getTarget();
        this.children = new ArrayList();
        if (this.attributesCategory != null) {
            List attributes = this.getCategoryChildren(1);
            List groups = this.getCategoryChildren(5);
            List types = this.getCategoryChildren(3);
            this.attributesCategory.setChildren(attributes);
            this.attributesCategory.setAllChildren(attributes);
            this.typesCategory.setChildren(types);
            this.typesCategory.setAllChildren(types);
            this.groupsCategory.setChildren(groups);
            this.groupsCategory.setAllChildren(groups);
        } else {
            this.createCategoryAdapters(xsdRedefine);
        }
        this.children.add(this.attributesCategory);
        this.children.add(this.typesCategory);
        this.children.add(this.groupsCategory);
        return this.children.toArray(new ITreeElement[0]);
    }

    public IADTObject getTopContainer() {
        return this;
    }

    public boolean isFocusAllowed() {
        return true;
    }

    private void createCategoryAdapters(XSDRedefine xsdRedefine) {
        List attributes = this.getCategoryChildren(1);
        List groups = this.getCategoryChildren(5);
        List types = this.getCategoryChildren(3);
        XSDEditorPlugin xsdEditorPlugin = XSDEditorPlugin.getDefault();
        this.attributesCategory = new RedefineCategoryAdapter(Messages._UI_GRAPH_REDEFINE_ATTRIBUTE_GROUPS, xsdEditorPlugin.getIconImage("obj16/attributesheader"), attributes, xsdRedefine, this, 1);
        this.attributesCategory.setAllChildren(attributes);
        this.registerListener(this.attributesCategory);
        this.typesCategory = new RedefineCategoryAdapter(Messages._UI_GRAPH_REDEFINE_TYPES, xsdEditorPlugin.getIconImage("obj16/typesheader"), types, xsdRedefine, this, 3);
        this.typesCategory.setAllChildren(types);
        this.registerListener(this.typesCategory);
        this.groupsCategory = new RedefineCategoryAdapter(Messages._UI_GRAPH_REDEFINE_GROUPS, xsdEditorPlugin.getIconImage("obj16/groupsheader"), groups, xsdRedefine, this, 5);
        this.groupsCategory.setAllChildren(groups);
        this.registerListener(this.groupsCategory);
    }

    public void notifyChanged(Notification msg) {
        if (this.children == null) {
            this.getChildren();
        }
        Object newValue = msg.getNewValue();
        Object oldValue = msg.getOldValue();
        if (XSDPackage.eINSTANCE.getXSDRedefine_Contents() == msg.getFeature()) {
            class CategoryNotification
            extends NotificationImpl {
                protected Object category;
                final /* synthetic */ XSDRedefineAdapter this$0;
                private final /* synthetic */ Notification val$msg;

                public CategoryNotification(XSDRedefineAdapter xSDRedefineAdapter, Object category, Notification notification) {
                    this.this$0 = xSDRedefineAdapter;
                    this.val$msg = notification;
                    super(notification.getEventType(), notification.getOldValue(), notification.getNewValue(), notification.getPosition());
                    this.category = category;
                }

                public Object getNotifier() {
                    return this.category;
                }

                public Object getFeature() {
                    return this.val$msg.getFeature();
                }
            }
            if (newValue instanceof XSDAttributeGroupDefinition || oldValue instanceof XSDAttributeGroupDefinition) {
                CategoryAdapter adapter = this.getCategory(1);
                Assert.isTrue((adapter != null ? 1 : 0) != 0);
                List list = this.getCategoryChildren(1);
                adapter.setChildren(list);
                adapter.setAllChildren(list);
                if (adapter.getModel() instanceof XSDSchemaAdapter) {
                    XSDSchemaAdapter schemaAdapter = (XSDSchemaAdapter)adapter.getModel();
                    schemaAdapter.notifyChanged(msg);
                }
                this.notifyListeners((Object)new CategoryNotification(this, adapter, msg), adapter.getText());
                return;
            }
            if (newValue instanceof XSDComplexTypeDefinition || newValue instanceof XSDSimpleTypeDefinition || oldValue instanceof XSDComplexTypeDefinition || oldValue instanceof XSDSimpleTypeDefinition) {
                CategoryAdapter adapter = this.getCategory(3);
                Assert.isTrue((adapter != null ? 1 : 0) != 0);
                List types = this.getCategoryChildren(3);
                adapter.setChildren(types);
                adapter.setAllChildren(types);
                if (adapter.getModel() instanceof XSDSchemaAdapter) {
                    XSDSchemaAdapter schemaAdapter = (XSDSchemaAdapter)adapter.getModel();
                    schemaAdapter.notifyChanged(msg);
                }
                this.notifyListeners((Object)new CategoryNotification(this, adapter, msg), adapter.getText());
                return;
            }
            if (newValue instanceof XSDModelGroupDefinition || oldValue instanceof XSDModelGroupDefinition) {
                CategoryAdapter adapter = this.getCategory(5);
                Assert.isTrue((adapter != null ? 1 : 0) != 0);
                List list = this.getCategoryChildren(5);
                adapter.setChildren(list);
                adapter.setAllChildren(list);
                if (adapter.getModel() instanceof XSDSchemaAdapter) {
                    XSDSchemaAdapter schemaAdapter = (XSDSchemaAdapter)adapter.getModel();
                    schemaAdapter.notifyChanged(msg);
                }
                this.notifyListeners((Object)new CategoryNotification(this, adapter, msg), adapter.getText());
                return;
            }
            if (msg.getFeature() == XSDPackage.eINSTANCE.getXSDSchema_Annotations()) {
                return;
            }
        }
        super.notifyChanged(msg);
    }

    private void updateCategories() {
        this.getChildren();
    }

    public CategoryAdapter getCategory(int category) {
        if (this.children == null) {
            this.updateCategories();
        }
        int length = this.children.size();
        CategoryAdapter adapter = null;
        int index = 0;
        while (index < length) {
            adapter = (CategoryAdapter)this.children.get(index);
            if (adapter.getGroupType() == category) break;
            ++index;
        }
        return adapter;
    }

    public String[] getActions(Object object) {
        ArrayList<String> actionIDs = new ArrayList<String>();
        actionIDs.add("org.eclipse.wst.xsd.ui.internal.editor.DeleteAction");
        actionIDs.add("org.eclipse.jface.action.Separator");
        actionIDs.add(SetInputToGraphView.ID);
        actionIDs.add("org.eclipse.jface.action.Separator");
        actionIDs.add("org.eclipse.wst.xsd.ui.internal.adt.actions.ShowPropertiesViewAction");
        return actionIDs.toArray(new String[0]);
    }

    public void propertyChanged(Object object, String property) {
        this.notifyListeners(object, property);
    }

    public Image getImage() {
        return XSDEditorPlugin.getXSDImage("icons/XSDRedefine.gif");
    }

    private List getCategoryChildren(int category) {
        ArrayList<XSDRedefineContent> list = new ArrayList<XSDRedefineContent>();
        XSDRedefine redefine = (XSDRedefine)this.target;
        Iterator iterator = redefine.getContents().iterator();
        while (iterator.hasNext()) {
            XSDRedefineContent redefineContent = (XSDRedefineContent)iterator.next();
            if (redefineContent instanceof XSDAttributeGroupDefinition && category == 1) {
                list.add(redefineContent);
                continue;
            }
            if (redefineContent instanceof XSDModelGroupDefinition && category == 5) {
                list.add(redefineContent);
                continue;
            }
            if (redefineContent instanceof XSDComplexTypeDefinition && category == 3) {
                list.add(redefineContent);
                continue;
            }
            if (!(redefineContent instanceof XSDSimpleTypeDefinition) || category != 3) continue;
            list.add(redefineContent);
        }
        ArrayList adapterList = new ArrayList();
        this.populateAdapterList(list, adapterList);
        return adapterList;
    }
}

