/*******************************************************************************
 * Copyright (c) 2018, 2020 Kichwa Coders Ltd and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Jonah Graham (Kichwa Coders) - initial API and implementation
 *******************************************************************************/
package org.eclipse.cdt.internal.ui.refactoring.rename;

import org.eclipse.core.resources.IResource;
import org.eclipse.ltk.ui.refactoring.resource.RenameResourceWizard;

public class CResourceRenameRefactoringWizard extends RenameResourceWizard {

	public CResourceRenameRefactoringWizard(IResource resource) {
		super(resource);
	}

	@Override
	protected void addUserInputPages() {
		addPage(new CResourceRenameRefactoringInputPage(getProcessor()));
	}

}
