/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.gist;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.github.core.Gist;
import org.eclipse.egit.github.core.GistFile;
import org.eclipse.egit.github.core.service.GistService;
import org.eclipse.mylyn.internal.github.core.GitHubException;
import org.eclipse.mylyn.internal.github.ui.GitHubUi;
import org.eclipse.mylyn.internal.github.ui.gist.GistConnectorUi;
import org.eclipse.mylyn.internal.github.ui.gist.GistNotificationPopup;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class CreateGistJob
extends Job {
    private String title;
    private String content;
    private GistService service;
    private boolean isPublic;
    private TaskRepository repository;

    public CreateGistJob(String name, String title, String content, GistService service, boolean isPublic, TaskRepository repository) {
        super(name);
        this.title = title;
        this.content = content;
        this.service = service;
        this.isPublic = isPublic;
        this.repository = repository;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            Gist gist = new Gist().setPublic(this.isPublic);
            gist.setDescription(this.title);
            GistFile file = new GistFile().setContent(this.content);
            gist.setFiles(Collections.singletonMap(this.title, file));
            Gist created = this.service.createGist(gist);
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.asyncExec(() -> {
                GistNotificationPopup popup = new GistNotificationPopup(display, created, this.title, this.repository);
                popup.create();
                popup.open();
            });
            TasksUiPlugin.getTaskJobFactory().createSynchronizeRepositoriesJob(GistConnectorUi.getRepositories()).schedule();
        }
        catch (IOException e) {
            GitHubUi.logError(GitHubException.wrap((IOException)e));
        }
        return Status.OK_STATUS;
    }
}

