/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupReorderLayer;
import org.eclipse.nebula.widgets.nattable.group.command.ReorderColumnsAndGroupsCommand;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommand;

public class ReorderColumnsAndGroupsCommandHandler
extends AbstractLayerCommandHandler<ReorderColumnsAndGroupsCommand> {
    private final ColumnGroupReorderLayer columnGroupReorderLayer;

    public ReorderColumnsAndGroupsCommandHandler(ColumnGroupReorderLayer columnGroupReorderLayer) {
        this.columnGroupReorderLayer = columnGroupReorderLayer;
    }

    @Override
    public Class<ReorderColumnsAndGroupsCommand> getCommandClass() {
        return ReorderColumnsAndGroupsCommand.class;
    }

    @Override
    protected boolean doCommand(ReorderColumnsAndGroupsCommand command) {
        IUniqueIndexLayer underlyingLayer = this.columnGroupReorderLayer.getUnderlyingLayer();
        ArrayList<String> groupsProcessed = new ArrayList<String>();
        List<Integer> fromColumnPositions = command.getFromColumnPositions();
        ArrayList<Integer> fromColumnPositionsWithGroupColumns = new ArrayList<Integer>();
        for (Integer fromColumnPosition : fromColumnPositions) {
            int fromColumnIndex = underlyingLayer.getColumnIndexByPosition(fromColumnPosition);
            ColumnGroupModel model = this.columnGroupReorderLayer.getModel();
            if (model.isPartOfAGroup(fromColumnIndex)) {
                String groupName = model.getColumnGroupByIndex(fromColumnIndex).getName();
                if (groupsProcessed.contains(groupName)) continue;
                groupsProcessed.add(groupName);
                fromColumnPositionsWithGroupColumns.addAll(this.columnGroupReorderLayer.getColumnGroupPositions(fromColumnIndex));
                continue;
            }
            fromColumnPositionsWithGroupColumns.add(fromColumnPosition);
        }
        return underlyingLayer.doCommand(new MultiColumnReorderCommand(this.columnGroupReorderLayer, fromColumnPositionsWithGroupColumns, command.getToColumnPosition(), command.isReorderToLeftEdge()));
    }
}

