/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.rulebased.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.types.rulebased.Activator;
import org.eclipse.papyrus.infra.types.rulebased.RuleConfiguration;
import org.eclipse.papyrus.infra.types.rulebased.core.DefaultRule;
import org.eclipse.papyrus.infra.types.rulebased.core.IRule;

public class RuleConfigurationTypeRegistry {
    private static RuleConfigurationTypeRegistry registry;
    protected Map<String, IRule<? extends RuleConfiguration>> invariantRuleConfigurationTypeToInvariantRule = null;

    public static synchronized RuleConfigurationTypeRegistry getInstance() {
        if (registry == null) {
            registry = new RuleConfigurationTypeRegistry();
            registry.init();
        }
        return registry;
    }

    protected void init() {
        IConfigurationElement[] elements;
        this.invariantRuleConfigurationTypeToInvariantRule = new HashMap<String, IRule<? extends RuleConfiguration>>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.types.rulebased.ruleKind");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String configurationClass = configurationElement.getAttribute("configurationClass");
            try {
                Object invariantRuleClass = configurationElement.createExecutableExtension("ruleClass");
                if (invariantRuleClass instanceof IRule) {
                    this.invariantRuleConfigurationTypeToInvariantRule.put(configurationClass, (IRule)invariantRuleClass);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            ++n2;
        }
    }

    public <T extends RuleConfiguration> IRule<? extends RuleConfiguration> getRule(T invariantRuleConfiguration) {
        String invariantRuleConfigurationType = invariantRuleConfiguration.eClass().getInstanceTypeName();
        IRule<? extends RuleConfiguration> invariantRule = this.invariantRuleConfigurationTypeToInvariantRule.get(invariantRuleConfigurationType);
        if (invariantRule != null) {
            invariantRule.init(invariantRuleConfiguration);
            return invariantRule;
        }
        return new DefaultRule();
    }
}

