/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.phps;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.php.internal.core.util.VersionUtils;
import org.eclipse.php.internal.debug.core.PHPExeUtil;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpProxyHandlersManager;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPExeVerifier;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPsSearchResultDialog;
import org.eclipse.php.internal.debug.ui.wizards.ClosableWizardDialog;
import org.eclipse.php.internal.debug.ui.wizards.PHPExeEditDialog;
import org.eclipse.php.internal.debug.ui.wizards.PHPExeWizard;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class InstalledPHPsBlock {
    private static final String[] PHP_CANDIDATE_BIN = new String[]{"php", "php-cli", "php-cgi", "php.exe", "php-cli.exe", "php-cgi.exe"};
    private Button fAddButton;
    private Composite fControl;
    private Button fEditButton;
    private TableViewer fPHPExeList;
    private final List<PHPexeItem> fPHPexes = new ArrayList<PHPexeItem>();
    private Button fRemoveButton;
    private Button fSearchButton;
    private Button fSetDefaultButton;

    public void createControl(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Font font = ancestor.getFont();
        parent.setFont(font);
        this.fControl = parent;
        Label tableLabel = new Label(parent, 0);
        tableLabel.setText(PHPDebugUIMessages.InstalledPHPsBlock_15);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        tableLabel.setLayoutData((Object)data);
        tableLabel.setFont(font);
        Composite tableComposite = new Composite(parent, 0);
        data = new GridData(1808);
        tableComposite.setLayoutData((Object)data);
        Table table = new Table(tableComposite, 67586);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fPHPExeList = new CheckboxTableViewer(table);
        this.fPHPExeList.setLabelProvider((IBaseLabelProvider)new PHPExeLabelProvider());
        this.fPHPExeList.setContentProvider((IContentProvider)new PHPsContentProvider());
        this.fPHPExeList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                InstalledPHPsBlock.this.enableButtons();
            }
        });
        this.fPHPExeList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (!InstalledPHPsBlock.this.fPHPExeList.getSelection().isEmpty()) {
                    InstalledPHPsBlock.this.editPHPexe();
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (InstalledPHPsBlock.this.fRemoveButton != null && !InstalledPHPsBlock.this.fRemoveButton.isDisposed() && !InstalledPHPsBlock.this.fRemoveButton.isEnabled()) {
                    return;
                }
                if (event.character == '\u007f' && event.stateMask == 0) {
                    InstalledPHPsBlock.this.removePHPexes();
                }
            }
        });
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(PHPDebugUIMessages.InstalledPHPsBlock_0);
        column1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledPHPsBlock.this.sortByName();
            }
        });
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(PHPDebugUIMessages.InstalledPHPsBlock_17);
        column2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledPHPsBlock.this.sortByDebugger();
            }
        });
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(PHPDebugUIMessages.InstalledPHPsBlock_18);
        column3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledPHPsBlock.this.sortByVersion();
            }
        });
        TableColumn column4 = new TableColumn(table, 0);
        column4.setText(PHPDebugUIMessages.InstalledPHPsBlock_1);
        column4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledPHPsBlock.this.sortByLocation();
            }
        });
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        PixelConverter pixelConverter = new PixelConverter(font);
        tableColumnLayout.setColumnData((Widget)column1, (ColumnLayoutData)new ColumnWeightData(20, pixelConverter.convertWidthInCharsToPixels(24)));
        tableColumnLayout.setColumnData((Widget)column2, (ColumnLayoutData)new ColumnWeightData(15, pixelConverter.convertWidthInCharsToPixels(18)));
        tableColumnLayout.setColumnData((Widget)column3, (ColumnLayoutData)new ColumnWeightData(10, pixelConverter.convertWidthInCharsToPixels(10)));
        tableColumnLayout.setColumnData((Widget)column4, (ColumnLayoutData)new ColumnWeightData(35, pixelConverter.convertWidthInCharsToPixels(28)));
        tableComposite.setLayout((Layout)tableColumnLayout);
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setFont(font);
        this.fAddButton = this.createPushButton(buttons, PHPDebugUIMessages.InstalledPHPsBlock_3);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledPHPsBlock.this.addPHPexe();
            }
        });
        this.fEditButton = this.createPushButton(buttons, PHPDebugUIMessages.InstalledPHPsBlock_4);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledPHPsBlock.this.editPHPexe();
            }
        });
        this.fRemoveButton = this.createPushButton(buttons, PHPDebugUIMessages.InstalledPHPsBlock_5);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledPHPsBlock.this.removePHPexes();
            }
        });
        this.fSetDefaultButton = this.createPushButton(buttons, PHPDebugUIMessages.InstalledPHPsBlock_setDefault);
        this.fSetDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPexeItem defaultItem = (PHPexeItem)((IStructuredSelection)InstalledPHPsBlock.this.fPHPExeList.getSelection()).getFirstElement();
                PHPexes.getInstance().setDefaultItem(defaultItem);
                InstalledPHPsBlock.this.commitChanges();
                InstalledPHPsBlock.this.setPHPs(PHPexes.getInstance().getAllItems());
            }
        });
        Label separator = new Label(buttons, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        this.fSearchButton = this.createPushButton(buttons, PHPDebugUIMessages.InstalledPHPsBlock_6);
        this.fSearchButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledPHPsBlock.this.search();
            }
        });
        this.fillWithWorkspacePHPs();
        this.sortByName();
        this.enableButtons();
    }

    public Control getControl() {
        return this.fControl;
    }

    public PHPexeItem[] getPHPs() {
        return this.fPHPexes.toArray(new PHPexeItem[this.fPHPexes.size()]);
    }

    public boolean isDuplicateName(String name) {
        int i = 0;
        while (i < this.fPHPexes.size()) {
            PHPexeItem phpExe = this.fPHPexes.get(i);
            if (phpExe.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void commitChanges() {
        PHPexes.getInstance().save();
    }

    public void removePHPs(PHPexeItem[] phpExes) {
        PHPexeItem[] pHPexeItemArray = phpExes;
        int n = phpExes.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem element = pHPexeItemArray[n2];
            this.fPHPexes.remove(element);
            PHPexes.getInstance().removeItem(element);
            ++n2;
        }
        this.fPHPExeList.refresh();
    }

    protected Button createPushButton(Composite parent, String label) {
        return SWTUtil.createPushButton((Composite)parent, (String)label, null);
    }

    protected void fillWithWorkspacePHPs() {
        PHPexeItem[] items = PHPexes.getInstance().getAllItems();
        this.setPHPs(items);
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    protected void search() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(PHPDebugUIMessages.InstalledPHPsBlock_9);
        dialog.setText(PHPDebugUIMessages.InstalledPHPsBlock_10);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        final File rootDir = new File(path);
        final ArrayList locations = new ArrayList();
        final ArrayList<PHPexeItem> found = new ArrayList<PHPexeItem>();
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(PHPDebugUIMessages.InstalledPHPsBlock_11, -1);
                InstalledPHPsBlock.this.search(rootDir, locations, monitor);
                if (!locations.isEmpty()) {
                    monitor.setTaskName(PHPDebugUIMessages.InstalledPHPsBlock_Processing_search_results);
                    Iterator iter2 = locations.iterator();
                    while (iter2.hasNext()) {
                        AbstractDebuggerConfiguration[] debuggers;
                        if (monitor.isCanceled()) break;
                        File location = (File)iter2.next();
                        PHPexeItem phpExe = new PHPexeItem(null, location, null, null, true);
                        if (phpExe.getName() == null) continue;
                        String nameCopy = new String(phpExe.getName());
                        monitor.subTask(MessageFormat.format(PHPDebugUIMessages.InstalledPHPsBlock_Fetching_php_exe_info, nameCopy));
                        List modules = PHPExeUtil.getModules((PHPexeItem)phpExe);
                        AbstractDebuggerConfiguration[] abstractDebuggerConfigurationArray = debuggers = PHPDebuggersRegistry.getDebuggersConfigurations();
                        int n = debuggers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AbstractDebuggerConfiguration debugger = abstractDebuggerConfigurationArray[n2];
                            for (PHPExeUtil.PHPModuleInfo m : modules) {
                                if (!m.getName().equalsIgnoreCase(debugger.getModuleId())) continue;
                                phpExe.setDebuggerID(debugger.getDebuggerId());
                                break;
                            }
                            ++n2;
                        }
                        if (phpExe.getDebuggerID() == null) {
                            phpExe.setDebuggerID("org.eclipse.php.debug.core.noneDebugger");
                        }
                        int i = 1;
                        block3: while (true) {
                            if (InstalledPHPsBlock.this.isDuplicateName(nameCopy)) {
                                nameCopy = String.valueOf(phpExe.getName()) + ' ' + '[' + i++ + ']';
                                continue;
                            }
                            for (PHPexeItem item : found) {
                                if (!nameCopy.equalsIgnoreCase(item.getName())) continue;
                                nameCopy = String.valueOf(phpExe.getName()) + ' ' + '[' + i++ + ']';
                                continue block3;
                            }
                            break;
                        }
                        phpExe.setName(nameCopy);
                        if (phpExe.getExecutable() == null) continue;
                        found.add(phpExe);
                    }
                }
                monitor.done();
            }
        };
        try {
            ProgressMonitorDialog progress = new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()){

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    shell.setText(PHPDebugUIMessages.InstalledPHPsBlock_PHP_executables_search);
                }
            };
            progress.run(true, true, r);
        }
        catch (InvocationTargetException e) {
            PHPDebugUIPlugin.log(e);
        }
        catch (InterruptedException e) {
            return;
        }
        if (!found.isEmpty()) {
            Comparator<PHPexeItem> sorter = new Comparator<PHPexeItem>(){

                @Override
                public int compare(PHPexeItem a, PHPexeItem b) {
                    return b.getVersion().compareTo(a.getVersion());
                }
            };
            Collections.sort(found, sorter);
            PHPsSearchResultDialog searchDialog = new PHPsSearchResultDialog(found, MessageFormat.format(PHPDebugUIMessages.InstalledPHPsBlock_Search_result_dialog_message, path));
            searchDialog.open();
            List<PHPexeItem> itemsToAdd = searchDialog.getPHPExecutables();
            for (PHPexeItem item : itemsToAdd) {
                this.fPHPexes.add(item);
                PHPexes.getInstance().addItem(item);
                PHPexes.getInstance().save();
                DBGpProxyHandlersManager.INSTANCE.registerHandler(item.getUniqueId());
                PHPExeVerifier.verify(PHPexes.getInstance().getAllItems());
            }
            this.fPHPExeList.refresh();
        } else {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)PHPDebugUIMessages.InstalledPHPsBlock_12, (String)MessageFormat.format(PHPDebugUIMessages.InstalledPHPsBlock_13, path));
        }
    }

    protected void search(File directory, List<File> found, IProgressMonitor monitor) {
        String[] names;
        if (monitor.isCanceled()) {
            return;
        }
        List<File> foundExecs = InstalledPHPsBlock.findPHPExecutable(directory);
        if (!foundExecs.isEmpty()) {
            found.addAll(foundExecs);
            monitor.setTaskName(MessageFormat.format(PHPDebugUIMessages.InstalledPHPsBlock_Searching_with_found, found.size()));
        }
        if ((names = directory.list()) == null) {
            return;
        }
        ArrayList<File> subDirs = new ArrayList<File>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            File file = new File(directory, element);
            if (file.isDirectory()) {
                try {
                    monitor.subTask(MessageFormat.format(PHPDebugUIMessages.InstalledPHPsBlock_14, file.getCanonicalPath()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (monitor.isCanceled()) {
                    return;
                }
                subDirs.add(file);
            }
            ++n2;
        }
        while (!subDirs.isEmpty()) {
            File subDir = (File)subDirs.remove(0);
            this.search(subDir, found, monitor);
            if (!monitor.isCanceled()) continue;
            return;
        }
    }

    protected void setPHPs(PHPexeItem[] phpExes) {
        this.fPHPexes.clear();
        PHPexeItem[] pHPexeItemArray = phpExes;
        int n = phpExes.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem element = pHPexeItemArray[n2];
            this.fPHPexes.add(element);
            ++n2;
        }
        this.fPHPExeList.setInput(this.fPHPexes);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                InstalledPHPsBlock.this.fPHPExeList.refresh();
            }
        });
    }

    private void addPHPexe() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        PHPexeItem phpExeItem = null;
        PHPExeWizard wizard = new PHPExeWizard(PHPexes.getInstance().getAllItems());
        ClosableWizardDialog dialog = new ClosableWizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 1) {
            monitor.setCanceled(true);
            return;
        }
        phpExeItem = (PHPexeItem)wizard.getRootFragment().getWizardModel().getObject("phpExe");
        this.fPHPexes.add(phpExeItem);
        PHPexes.getInstance().addItem(phpExeItem);
        this.fPHPExeList.refresh();
        this.commitChanges();
    }

    private void editPHPexe() {
        IStructuredSelection selection = (IStructuredSelection)this.fPHPExeList.getSelection();
        PHPexeItem phpExe = (PHPexeItem)selection.getFirstElement();
        if (phpExe == null) {
            return;
        }
        PHPExeEditDialog dialog = new PHPExeEditDialog(this.getShell(), phpExe, PHPexes.getInstance().getAllItems());
        if (dialog.open() != 0) {
            return;
        }
        this.fPHPExeList.refresh();
        this.commitChanges();
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fPHPExeList.getSelection();
        Object[] elements = selection.toArray();
        boolean canRemoveOrEdit = true;
        int i = 0;
        while (canRemoveOrEdit && i < elements.length) {
            PHPexeItem item = (PHPexeItem)elements[i];
            canRemoveOrEdit &= item.isEditable();
            ++i;
        }
        int selectionCount = selection.size();
        this.fRemoveButton.setEnabled(canRemoveOrEdit && selectionCount > 0);
        PHPexeItem selectedItem = (PHPexeItem)((IStructuredSelection)this.fPHPExeList.getSelection()).getFirstElement();
        this.fSetDefaultButton.setEnabled(selectionCount == 1 && selectedItem != null && !selectedItem.isDefault());
    }

    private void removePHPexes() {
        IStructuredSelection selection = (IStructuredSelection)this.fPHPExeList.getSelection();
        PHPexeItem[] phpExes = new PHPexeItem[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            phpExes[i] = (PHPexeItem)iter.next();
            ++i;
        }
        this.removePHPs(phpExes);
        this.commitChanges();
    }

    private void sortByLocation() {
        this.fPHPExeList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof PHPexeItem && e2 instanceof PHPexeItem) {
                    PHPexeItem left = (PHPexeItem)e1;
                    PHPexeItem right = (PHPexeItem)e2;
                    return left.getExecutable().getAbsolutePath().compareToIgnoreCase(right.getExecutable().getAbsolutePath());
                }
                return super.compare(viewer, e1, e2);
            }
        });
    }

    private void sortByDebugger() {
        this.fPHPExeList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof PHPexeItem && e2 instanceof PHPexeItem) {
                    PHPexeItem left = (PHPexeItem)e1;
                    PHPexeItem right = (PHPexeItem)e2;
                    String leftDebugger = PHPDebuggersRegistry.getDebuggerName((String)left.getDebuggerID());
                    String rightDebugger = PHPDebuggersRegistry.getDebuggerName((String)right.getDebuggerID());
                    return rightDebugger.compareToIgnoreCase(leftDebugger);
                }
                return super.compare(viewer, e1, e2);
            }
        });
    }

    private void sortByName() {
        this.fPHPExeList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof PHPexeItem && e2 instanceof PHPexeItem) {
                    PHPexeItem left = (PHPexeItem)e1;
                    PHPexeItem right = (PHPexeItem)e2;
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
    }

    private void sortByVersion() {
        this.fPHPExeList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof PHPexeItem && e2 instanceof PHPexeItem) {
                    String rightVersion;
                    PHPexeItem left = (PHPexeItem)e1;
                    PHPexeItem right = (PHPexeItem)e2;
                    String leftVersion = left.getVersion();
                    if (VersionUtils.greater((String)leftVersion, (String)(rightVersion = right.getVersion()), (int)3)) {
                        return 1;
                    }
                    if (VersionUtils.equal((String)leftVersion, (String)rightVersion, (int)3)) {
                        return 0;
                    }
                    return -1;
                }
                return super.compare(viewer, e1, e2);
            }
        });
    }

    private static List<File> findPHPExecutable(File phpLocation) {
        ArrayList<File> found = new ArrayList<File>(0);
        String[] stringArray = PHP_CANDIDATE_BIN;
        int n = PHP_CANDIDATE_BIN.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            File phpExecFile = new File(phpLocation, element);
            if (phpExecFile.exists() && !phpExecFile.isDirectory()) {
                found.add(phpExecFile);
            }
            ++n2;
        }
        return found;
    }

    class PHPExeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        PHPExeLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return PHPDebugUIImages.get("IMG_OBJ_PHP_EXE");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof PHPexeItem) {
                PHPexeItem phpExe = (PHPexeItem)element;
                switch (columnIndex) {
                    case 0: {
                        if (this.isDefault(element)) {
                            return String.valueOf(phpExe.getName()) + PHPDebugUIMessages.PHPsPreferencePage_WorkspaceDefault;
                        }
                        return phpExe.getName();
                    }
                    case 1: {
                        String debuggerName = PHPDebuggersRegistry.getDebuggerName((String)phpExe.getDebuggerID());
                        if (debuggerName == null) {
                            debuggerName = "";
                        }
                        return debuggerName;
                    }
                    case 2: {
                        String version = phpExe.getVersion();
                        if (version == null) {
                            return "";
                        }
                        return version;
                    }
                    case 3: {
                        File executable = phpExe.getExecutable();
                        if (executable == null) {
                            return "";
                        }
                        return executable.getAbsolutePath();
                    }
                }
            }
            return element.toString();
        }

        public Font getFont(Object element) {
            if (this.isDefault(element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }

        private boolean isDefault(Object element) {
            if (element instanceof PHPexeItem) {
                return ((PHPexeItem)element).isDefault();
            }
            return false;
        }
    }

    class PHPsContentProvider
    implements IStructuredContentProvider {
        PHPsContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object input) {
            return InstalledPHPsBlock.this.fPHPexes.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

