/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.cdt.launching;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate2;
import org.eclipse.cdt.launch.LaunchUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.te.tcf.launch.cdt.activator.Activator;
import org.eclipse.tcf.te.tcf.launch.cdt.interfaces.IRemoteTEConfigurationConstants;
import org.eclipse.tcf.te.tcf.launch.cdt.nls.Messages;
import org.eclipse.tcf.te.tcf.launch.cdt.utils.TEHelper;
import org.eclipse.tcf.te.tcf.launch.cdt.utils.TERunProcess;

public class TERunLaunchDelegate
extends AbstractCLaunchDelegate2 {
    public TERunLaunchDelegate() {
        super(false);
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IPath exePath = this.checkBinaryDetails(config);
        if (exePath != null) {
            String userId;
            boolean launchAsRemoteUser;
            IPath remotePrerunScriptPath;
            String arguments;
            String remoteExePath;
            IPeer peer;
            block32: {
                Activator.getDefault().initializeTE();
                peer = TEHelper.getCurrentConnection(config).getPeer();
                remoteExePath = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_PATH, "");
                arguments = this.getProgramArguments(config);
                String remoteLaunchCommand = remoteExePath.replaceAll("\\r", "");
                if (arguments != null && !arguments.equals("")) {
                    remoteLaunchCommand = String.valueOf(remoteLaunchCommand) + " " + arguments.replaceAll("\\r", " ").replaceAll("\\n", " ");
                }
                remotePrerunScriptPath = null;
                launchAsRemoteUser = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_LAUNCH_REMOTE_USER, false);
                userId = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_USER_ID, null);
                String prerunCommands = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_PRERUN_COMMANDS, null);
                if (prerunCommands != null && prerunCommands.trim().length() > 0 || launchAsRemoteUser && userId != null && userId.trim().length() > 0) {
                    IPath prerunScriptLocation;
                    String prerunScriptName;
                    block30: {
                        if (prerunCommands == null) {
                            prerunCommands = "";
                        }
                        SimpleDateFormat formatter = new SimpleDateFormat("HH-mm-ss-S", Locale.US);
                        String prerunScriptNamePreffix = formatter.format(Calendar.getInstance().getTime().getTime());
                        prerunScriptName = String.valueOf(prerunScriptNamePreffix) + "_" + exePath.toFile().getName() + ".sh";
                        IPath localTempLocation = Activator.getDefault().getStateLocation().append("prerun_commands_scripts");
                        if (!localTempLocation.toFile().exists()) {
                            localTempLocation.toFile().mkdirs();
                        }
                        if ((prerunScriptLocation = localTempLocation.append(prerunScriptName)).toFile().exists()) {
                            prerunScriptLocation.toFile().delete();
                        }
                        BufferedWriter writer = null;
                        try {
                            try {
                                writer = new BufferedWriter(new FileWriter(prerunScriptLocation.toFile()));
                                writer.write(NLS.bind((String)TEHelper.getPrerunTemplateContent(peer), (Object)prerunCommands.replaceAll("\\r", ""), (Object)remoteLaunchCommand));
                            }
                            catch (Exception e) {
                                this.abort(NLS.bind((String)Messages.TEGdbAbstractLaunchDelegate_prerunScriptCreationFailed, (Object)prerunScriptLocation.toString(), (Object)e.getLocalizedMessage()), e, 104);
                                if (writer != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block30;
                            }
                        }
                        catch (Throwable throwable) {
                            if (writer != null) {
                                try {
                                    writer.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    prerunScriptLocation.toFile().setExecutable(true, false);
                    remotePrerunScriptPath = new Path("/tmp").append(prerunScriptName);
                    try {
                        try {
                            TEHelper.remoteFileTransfer(peer, prerunScriptLocation.toString(), remotePrerunScriptPath.toString(), new SubProgressMonitor(monitor, 80));
                        }
                        catch (IOException e) {
                            this.abort(NLS.bind((String)Messages.TEGdbAbstractLaunchDelegate_prerunScriptTransferFailed, (Object)remotePrerunScriptPath.toString(), (Object)e.getLocalizedMessage()), e, 104);
                            prerunScriptLocation.toFile().delete();
                            break block32;
                        }
                    }
                    catch (Throwable throwable) {
                        prerunScriptLocation.toFile().delete();
                        throw throwable;
                    }
                    prerunScriptLocation.toFile().delete();
                }
            }
            monitor.setTaskName(Messages.TEGdbAbstractLaunchDelegate_downloading);
            boolean skipDownload = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, false);
            if (!skipDownload) {
                try {
                    TEHelper.remoteFileTransfer(peer, exePath.toString(), remoteExePath, new SubProgressMonitor(monitor, 80));
                }
                catch (IOException e) {
                    this.abort(NLS.bind((String)Messages.TEGdbAbstractLaunchDelegate_filetransferFailed, (Object)e.getLocalizedMessage()), e, 104);
                }
            }
            monitor.setTaskName(Messages.TEGdbAbstractLaunchDelegate_starting_debugger);
            Map env = config.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            if (remotePrerunScriptPath != null) {
                String launchArguments = "";
                if (launchAsRemoteUser && userId != null && userId.trim().length() > 0) {
                    launchArguments = "-u__ " + userId;
                }
                new TERunProcess(launch, remotePrerunScriptPath.toString(), launchArguments, env, this.renderProcessLabel(exePath.toString()), peer, new SubProgressMonitor(monitor, 20));
            } else {
                new TERunProcess(launch, remoteExePath, arguments, env, this.renderProcessLabel(exePath.toString()), peer, new SubProgressMonitor(monitor, 20));
            }
        }
    }

    protected IPath checkBinaryDetails(ILaunchConfiguration config) throws CoreException {
        ICProject project = this.verifyCProject(config);
        IPath exePath = org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.verifyProgramPath((ILaunchConfiguration)config, (ICProject)project);
        org.eclipse.cdt.dsf.gdb.launching.LaunchUtils.verifyBinary((ILaunchConfiguration)config, (IPath)exePath);
        return exePath;
    }

    protected String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        return LaunchUtils.getProgramArguments((ILaunchConfiguration)config);
    }

    protected String renderProcessLabel(String commandLine) {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(format, commandLine, timestamp);
    }

    protected String getPluginID() {
        return Activator.getUniqueIdentifier();
    }
}

