/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.Endpoint;
import org.mandas.docker.client.messages.swarm.JobStatus;
import org.mandas.docker.client.messages.swarm.Service;
import org.mandas.docker.client.messages.swarm.ServiceSpec;
import org.mandas.docker.client.messages.swarm.UpdateStatus;
import org.mandas.docker.client.messages.swarm.Version;

final class ImmutableService
implements Service {
    private final String id;
    private final Version version;
    private final Date createdAt;
    private final Date updatedAt;
    private final ServiceSpec spec;
    private final Endpoint endpoint;
    @Nullable
    private final UpdateStatus updateStatus;
    @Nullable
    private final JobStatus jobStatus;

    private ImmutableService(String id, Version version, Date createdAt, Date updatedAt, ServiceSpec spec, Endpoint endpoint, @Nullable UpdateStatus updateStatus, @Nullable JobStatus jobStatus) {
        this.id = id;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.spec = spec;
        this.endpoint = endpoint;
        this.updateStatus = updateStatus;
        this.jobStatus = jobStatus;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Version")
    public Version version() {
        return this.version;
    }

    @Override
    @JsonProperty(value="CreatedAt")
    public Date createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="UpdatedAt")
    public Date updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="Spec")
    public ServiceSpec spec() {
        return this.spec;
    }

    @Override
    @JsonProperty(value="Endpoint")
    public Endpoint endpoint() {
        return this.endpoint;
    }

    @Override
    @JsonProperty(value="UpdateStatus")
    @Nullable
    public UpdateStatus updateStatus() {
        return this.updateStatus;
    }

    @Override
    @JsonProperty(value="JobStatus")
    @Nullable
    public JobStatus jobStatus() {
        return this.jobStatus;
    }

    public final ImmutableService withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableService(newValue, this.version, this.createdAt, this.updatedAt, this.spec, this.endpoint, this.updateStatus, this.jobStatus);
    }

    public final ImmutableService withVersion(Version value) {
        if (this.version == value) {
            return this;
        }
        Version newValue = Objects.requireNonNull(value, "version");
        return new ImmutableService(this.id, newValue, this.createdAt, this.updatedAt, this.spec, this.endpoint, this.updateStatus, this.jobStatus);
    }

    public final ImmutableService withCreatedAt(Date value) {
        if (this.createdAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "createdAt");
        return new ImmutableService(this.id, this.version, newValue, this.updatedAt, this.spec, this.endpoint, this.updateStatus, this.jobStatus);
    }

    public final ImmutableService withUpdatedAt(Date value) {
        if (this.updatedAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "updatedAt");
        return new ImmutableService(this.id, this.version, this.createdAt, newValue, this.spec, this.endpoint, this.updateStatus, this.jobStatus);
    }

    public final ImmutableService withSpec(ServiceSpec value) {
        if (this.spec == value) {
            return this;
        }
        ServiceSpec newValue = Objects.requireNonNull(value, "spec");
        return new ImmutableService(this.id, this.version, this.createdAt, this.updatedAt, newValue, this.endpoint, this.updateStatus, this.jobStatus);
    }

    public final ImmutableService withEndpoint(Endpoint value) {
        if (this.endpoint == value) {
            return this;
        }
        Endpoint newValue = Objects.requireNonNull(value, "endpoint");
        return new ImmutableService(this.id, this.version, this.createdAt, this.updatedAt, this.spec, newValue, this.updateStatus, this.jobStatus);
    }

    public final ImmutableService withUpdateStatus(@Nullable UpdateStatus value) {
        if (this.updateStatus == value) {
            return this;
        }
        return new ImmutableService(this.id, this.version, this.createdAt, this.updatedAt, this.spec, this.endpoint, value, this.jobStatus);
    }

    public final ImmutableService withJobStatus(@Nullable JobStatus value) {
        if (this.jobStatus == value) {
            return this;
        }
        return new ImmutableService(this.id, this.version, this.createdAt, this.updatedAt, this.spec, this.endpoint, this.updateStatus, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableService && this.equalTo(0, (ImmutableService)another);
    }

    private boolean equalTo(int synthetic, ImmutableService another) {
        return this.id.equals(another.id) && this.version.equals(another.version) && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && this.spec.equals(another.spec) && this.endpoint.equals(another.endpoint) && Objects.equals(this.updateStatus, another.updateStatus) && Objects.equals(this.jobStatus, another.jobStatus);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.updatedAt.hashCode();
        h += (h << 5) + this.spec.hashCode();
        h += (h << 5) + this.endpoint.hashCode();
        h += (h << 5) + Objects.hashCode(this.updateStatus);
        h += (h << 5) + Objects.hashCode(this.jobStatus);
        return h;
    }

    public String toString() {
        return "Service{id=" + this.id + ", version=" + this.version + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", spec=" + this.spec + ", endpoint=" + this.endpoint + ", updateStatus=" + this.updateStatus + ", jobStatus=" + this.jobStatus + "}";
    }

    public static ImmutableService copyOf(Service instance) {
        if (instance instanceof ImmutableService) {
            return (ImmutableService)instance;
        }
        return ImmutableService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_UPDATED_AT = 8L;
        private static final long INIT_BIT_SPEC = 16L;
        private static final long INIT_BIT_ENDPOINT = 32L;
        private long initBits = 63L;
        private String id;
        private Version version;
        private Date createdAt;
        private Date updatedAt;
        private ServiceSpec spec;
        private Endpoint endpoint;
        private UpdateStatus updateStatus;
        private JobStatus jobStatus;

        private Builder() {
        }

        public final Builder from(Service instance) {
            JobStatus jobStatusValue;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.version(instance.version());
            this.createdAt(instance.createdAt());
            this.updatedAt(instance.updatedAt());
            this.spec(instance.spec());
            this.endpoint(instance.endpoint());
            UpdateStatus updateStatusValue = instance.updateStatus();
            if (updateStatusValue != null) {
                this.updateStatus(updateStatusValue);
            }
            if ((jobStatusValue = instance.jobStatus()) != null) {
                this.jobStatus(jobStatusValue);
            }
            return this;
        }

        @JsonProperty(value="ID")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Version")
        public final Builder version(Version version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="CreatedAt")
        public final Builder createdAt(Date createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="UpdatedAt")
        public final Builder updatedAt(Date updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Spec")
        public final Builder spec(ServiceSpec spec) {
            this.spec = Objects.requireNonNull(spec, "spec");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="Endpoint")
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = Objects.requireNonNull(endpoint, "endpoint");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="UpdateStatus")
        public final Builder updateStatus(@Nullable UpdateStatus updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @JsonProperty(value="JobStatus")
        public final Builder jobStatus(@Nullable JobStatus jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        public ImmutableService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableService(this.id, this.version, this.createdAt, this.updatedAt, this.spec, this.endpoint, this.updateStatus, this.jobStatus);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("spec");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("endpoint");
            }
            return "Cannot build Service, some of required attributes are not set " + attributes;
        }
    }

    static final class Criteria
    implements Service.Criteria {
        @Nullable
        private final String serviceId;
        @Nullable
        private final String serviceName;
        private final Map<String, String> labels;

        private Criteria(@Nullable String serviceId, @Nullable String serviceName, Map<String, String> labels) {
            this.serviceId = serviceId;
            this.serviceName = serviceName;
            this.labels = labels;
        }

        @Override
        @JsonProperty(value="serviceId")
        @Nullable
        public String serviceId() {
            return this.serviceId;
        }

        @Override
        @JsonProperty(value="serviceName")
        @Nullable
        public String serviceName() {
            return this.serviceName;
        }

        @Override
        @JsonProperty(value="labels")
        public Map<String, String> labels() {
            return this.labels;
        }

        public final Criteria withServiceId(@Nullable String value) {
            if (Objects.equals(this.serviceId, value)) {
                return this;
            }
            return new Criteria(value, this.serviceName, this.labels);
        }

        public final Criteria withServiceName(@Nullable String value) {
            if (Objects.equals(this.serviceName, value)) {
                return this;
            }
            return new Criteria(this.serviceId, value, this.labels);
        }

        public final Criteria withLabels(Map<String, ? extends String> entries) {
            if (this.labels == entries) {
                return this;
            }
            Map<String, String> newValue = ImmutableService.createUnmodifiableMap(true, false, entries);
            return new Criteria(this.serviceId, this.serviceName, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Criteria && this.equalTo(0, (Criteria)another);
        }

        private boolean equalTo(int synthetic, Criteria another) {
            return Objects.equals(this.serviceId, another.serviceId) && Objects.equals(this.serviceName, another.serviceName) && this.labels.equals(another.labels);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.serviceId);
            h += (h << 5) + Objects.hashCode(this.serviceName);
            h += (h << 5) + this.labels.hashCode();
            return h;
        }

        public String toString() {
            return "Criteria{serviceId=" + this.serviceId + ", serviceName=" + this.serviceName + ", labels=" + this.labels + "}";
        }

        public static Criteria copyOf(Service.Criteria instance) {
            if (instance instanceof Criteria) {
                return (Criteria)instance;
            }
            return Criteria.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder
        implements Service.Criteria.Builder {
            private String serviceId;
            private String serviceName;
            private Map<String, String> labels = new LinkedHashMap<String, String>();

            private Builder() {
            }

            public final Builder from(Service.Criteria instance) {
                String serviceNameValue;
                Objects.requireNonNull(instance, "instance");
                String serviceIdValue = instance.serviceId();
                if (serviceIdValue != null) {
                    this.serviceId(serviceIdValue);
                }
                if ((serviceNameValue = instance.serviceName()) != null) {
                    this.serviceName(serviceNameValue);
                }
                this.putAllLabels(instance.labels());
                return this;
            }

            @Override
            @JsonProperty(value="serviceId")
            public final Builder serviceId(@Nullable String serviceId) {
                this.serviceId = serviceId;
                return this;
            }

            @Override
            @JsonProperty(value="serviceName")
            public final Builder serviceName(@Nullable String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            @Override
            public final Builder addLabel(String key, String value) {
                this.labels.put(Objects.requireNonNull(key, "labels key"), Objects.requireNonNull(value, value == null ? "labels value for key: " + key : null));
                return this;
            }

            public final Builder addLabel(Map.Entry<String, ? extends String> entry) {
                String v;
                String k = entry.getKey();
                this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "labels value for key: " + k : null));
                return this;
            }

            @Override
            @JsonProperty(value="labels")
            public final Builder labels(Map<String, ? extends String> entries) {
                this.labels.clear();
                return this.putAllLabels(entries);
            }

            public final Builder putAllLabels(Map<String, ? extends String> entries) {
                for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                    String v;
                    String k = e.getKey();
                    this.labels.put(Objects.requireNonNull(k, "labels key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "labels value for key: " + k : null));
                }
                return this;
            }

            @Override
            public Criteria build() {
                return new Criteria(this.serviceId, this.serviceName, ImmutableService.createUnmodifiableMap(false, false, this.labels));
            }
        }
    }
}

