/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.baseloaders;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCRoutineLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCUserDefinedTypeLoader;
import org.eclipse.datatools.enablement.sybase.asa.JDBCASAPlugin;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseIndex;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseProcedure;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseProxyTable;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseRemoteProcedure;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseTempTable;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseTrigger;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseUserDefinedDataType;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseUserDefinedFunction;
import org.eclipse.datatools.enablement.sybase.asa.base.catalog.SybaseASACatalogBaseViewTable;
import org.eclipse.datatools.enablement.sybase.asa.baseloaders.TableASABaseLoader;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SQLScriptsProvider;
import org.eclipse.datatools.enablement.sybase.asa.catalog.SybaseASACatalogUtils;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseProxyTable;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseSchema;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.emf.common.util.EList;

public class SchemaASABaseLoader {
    protected ICatalogObject catalogObj;
    protected Schema schema;
    private SoftReference tableLoaderRef;
    private SoftReference routineLoaderRef;
    private SoftReference UDTLoaderRef;

    public SchemaASABaseLoader(Schema catalogSchema) {
        this.catalogObj = (ICatalogObject)catalogSchema;
        this.schema = catalogSchema;
    }

    public final void loadTables(EList tableConstainmentList) {
        try {
            boolean deliver = this.schema.eDeliver();
            this.schema.eSetDeliver(false);
            ArrayList existingTables = new ArrayList(tableConstainmentList.size());
            existingTables.addAll(tableConstainmentList);
            this.getTableLoader().clearTables((List)tableConstainmentList);
            this.getTableLoader().loadTables((List)tableConstainmentList, existingTables);
            this.schema.eSetDeliver(deliver);
        }
        catch (Exception e) {
            JDBCASAPlugin.getDefault().log(e);
        }
    }

    public final void loadRoutines(EList routineContainmentList) {
        try {
            boolean deliver = this.schema.eDeliver();
            this.schema.eSetDeliver(false);
            ArrayList existingRoutines = new ArrayList(routineContainmentList.size());
            existingRoutines.addAll(routineContainmentList);
            this.getRoutineLoader().clearRoutines((List)routineContainmentList);
            this.getRoutineLoader().loadRoutines((List)routineContainmentList, existingRoutines);
            this.schema.eSetDeliver(deliver);
        }
        catch (Exception e) {
            JDBCASAPlugin.getDefault().log(e);
        }
    }

    public final void loadUDTs(EList udtContainmentList) {
        try {
            boolean deliver = this.schema.eDeliver();
            this.schema.eSetDeliver(false);
            ArrayList existingUDTs = new ArrayList(udtContainmentList.size());
            existingUDTs.addAll(udtContainmentList);
            this.getUDTLoader().clearUDTs((List)udtContainmentList);
            this.getUDTLoader().loadUDTs((List)udtContainmentList, existingUDTs);
            this.schema.eSetDeliver(deliver);
        }
        catch (Exception e) {
            JDBCASAPlugin.getDefault().log(e);
        }
    }

    protected JDBCTableLoader createTableLoader() {
        return new ASABaseTableLoader(this.catalogObj);
    }

    private JDBCTableLoader getTableLoader() {
        if (this.tableLoaderRef == null || this.tableLoaderRef.get() == null) {
            this.tableLoaderRef = new SoftReference<JDBCTableLoader>(this.createTableLoader());
        }
        return (JDBCTableLoader)this.tableLoaderRef.get();
    }

    protected JDBCRoutineLoader createRoutineLoader() {
        return new ASABaseRoutineLoader(this.catalogObj);
    }

    private JDBCRoutineLoader getRoutineLoader() {
        if (this.routineLoaderRef == null || this.routineLoaderRef.get() == null) {
            this.routineLoaderRef = new SoftReference<JDBCRoutineLoader>(this.createRoutineLoader());
        }
        return (JDBCRoutineLoader)this.routineLoaderRef.get();
    }

    protected JDBCUserDefinedTypeLoader createUDTLoader() {
        return new ASABaseUDTLoader(this.catalogObj);
    }

    private JDBCUserDefinedTypeLoader getUDTLoader() {
        if (this.UDTLoaderRef == null || this.UDTLoaderRef.get() == null) {
            this.UDTLoaderRef = new SoftReference<JDBCUserDefinedTypeLoader>(this.createUDTLoader());
        }
        return (JDBCUserDefinedTypeLoader)this.UDTLoaderRef.get();
    }

    public final void batchLoadTriggers() {
        block8: {
            HashMap tableMap = new HashMap();
            HashMap trigMap = new HashMap();
            this.initTableMap(tableMap);
            Connection conn = this.catalogObj.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = conn.prepareStatement("SELECT TRIM(G.trigger_name) as trigger_name, TRIM(T.table_name) FROM SYS.SYSTRIGGER G JOIN SYS.SYSTABLE T ON T.table_id = G.table_id JOIN SYS.SYSUSERPERMS U ON U.user_id = T.creator WHERE G.foreign_key_id IS NULL AND U.user_name = ? ORDER BY 1");
                    stmt.setString(1, this.schema.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String triggerName;
                        String tableName = rs.getString(2);
                        ArrayList<String> triggers = (ArrayList<String>)trigMap.get(tableName);
                        if (triggers == null) {
                            triggers = new ArrayList<String>();
                            trigMap.put(tableName, triggers);
                        }
                        if ((triggerName = rs.getString(1)) == null) continue;
                        triggers.add(triggerName);
                    }
                    ((SybaseASABaseSchema)this.schema).getSuperTriggers().clear();
                    for (String tableName : trigMap.keySet()) {
                        List trigList = (List)trigMap.get(tableName);
                        TableASABaseLoader.IASABaseLoaderTable table = (TableASABaseLoader.IASABaseLoaderTable)tableMap.get(tableName);
                        if (table == null) continue;
                        this.loadTriggers(table, trigList);
                    }
                }
                catch (SQLException e) {
                    JDBCASAPlugin.getDefault().log(e);
                    SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                throw throwable;
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
    }

    private void initTableMap(Map tableMap) {
        EList tables = this.schema.getTables();
        for (Table table : tables) {
            if (!(table instanceof TableASABaseLoader.IASABaseLoaderTable)) continue;
            tableMap.put(table.getName(), table);
        }
    }

    private void loadTriggers(TableASABaseLoader.IASABaseLoaderTable table, List triggers) {
        Table t = (Table)table;
        boolean deliver = t.eDeliver();
        t.eSetDeliver(false);
        EList triggerContainmentList = table.getTriggerSuper();
        ArrayList existingTriggers = new ArrayList(triggerContainmentList.size());
        existingTriggers.addAll(triggerContainmentList);
        triggerContainmentList.clear();
        for (String triggerName : triggers) {
            SQLObject trigger = (SQLObject)SybaseASACatalogUtils.findElement(existingTriggers, triggerName);
            if (trigger == null) {
                trigger = this.createCatalogTrigger();
                trigger.setName(triggerName);
                triggerContainmentList.add(trigger);
                ((SybaseASABaseSchema)this.schema).getSuperTriggers().add((Object)trigger);
                continue;
            }
            triggerContainmentList.add(trigger);
            ((SybaseASABaseSchema)this.schema).getSuperTriggers().add((Object)trigger);
            ((ICatalogObject)trigger).refresh();
        }
        t.eSetDeliver(deliver);
    }

    protected Trigger createCatalogTrigger() {
        return new SybaseASACatalogBaseTrigger();
    }

    public final void batchLoadIndices() {
        block8: {
            HashMap tableMap = new HashMap();
            HashMap indexMap = new HashMap();
            this.initTableMap(tableMap);
            Connection conn = this.catalogObj.getConnection();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    SybaseASABaseDatabase db = (SybaseASABaseDatabase)this.catalogObj.getCatalogDatabase();
                    stmt = conn.prepareStatement(this.getBatchIndexQuerySQL(db));
                    stmt.setString(1, this.schema.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String indexName = rs.getString(1);
                        String tableName = rs.getString(2);
                        ArrayList<IndexWrapper> indices = (ArrayList<IndexWrapper>)indexMap.get(tableName);
                        if (indices == null) {
                            indices = new ArrayList<IndexWrapper>();
                            indexMap.put(tableName, indices);
                        }
                        if (indexName == null) continue;
                        IndexWrapper wrapper = this.initIndexWrapper(rs);
                        indices.add(wrapper);
                    }
                    ((SybaseASABaseSchema)this.schema).getSuperIndices().clear();
                    for (String tableName : indexMap.keySet()) {
                        List indexList = (List)indexMap.get(tableName);
                        TableASABaseLoader.IASABaseLoaderTable table = (TableASABaseLoader.IASABaseLoaderTable)tableMap.get(tableName);
                        if (table == null) continue;
                        this.loadIndices(table, indexList);
                    }
                }
                catch (SQLException e) {
                    JDBCASAPlugin.getDefault().log(e);
                    SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
                throw throwable;
            }
            SybaseASACatalogUtils.cleanupJDBCResouce(rs, stmt);
        }
    }

    public final void loadIndices(TableASABaseLoader.IASABaseLoaderTable table, List indexWrappers) {
        Table t = (Table)table;
        boolean deliver = t.eDeliver();
        t.eSetDeliver(false);
        EList indexContainmentList = table.getIndexSupper();
        ArrayList existingTriggers = new ArrayList(indexContainmentList.size());
        existingTriggers.addAll(indexContainmentList);
        indexContainmentList.clear();
        for (IndexWrapper wrapper : indexWrappers) {
            Index index = (Index)SybaseASACatalogUtils.findElement(existingTriggers, wrapper.indexName);
            if (index == null) {
                index = this.createCatalogIndex();
                index.setName(wrapper.indexName);
                indexContainmentList.add(index);
                ((SybaseASABaseSchema)this.schema).getSuperIndices().add((Object)index);
            } else {
                indexContainmentList.add(index);
                ((SybaseASABaseSchema)this.schema).getSuperIndices().add((Object)index);
                ((ICatalogObject)index).refresh();
            }
            index.setSystemGenerated(wrapper.isSysGen);
        }
        t.eSetDeliver(deliver);
    }

    protected String getBatchIndexQuerySQL(SybaseASABaseDatabase db) {
        return SQLScriptsProvider.getBatchQueryTableIndex((Database)db);
    }

    protected IndexWrapper initIndexWrapper(ResultSet rs) throws SQLException {
        SybaseASABaseDatabase db = (SybaseASABaseDatabase)this.catalogObj.getCatalogDatabase();
        String idxName = rs.getString(1);
        boolean isSysGen = false;
        if (db.isBaseOnASA10()) {
            int indexUnique = rs.getInt(3);
            int indexCategory = rs.getInt(4);
            switch (indexCategory) {
                case 1: 
                case 2: {
                    isSysGen = true;
                }
                case 3: {
                    isSysGen = indexUnique == 2;
                }
            }
        } else {
            String strUnique = rs.getString(3);
            isSysGen = strUnique.equals("U");
        }
        return new IndexWrapper(idxName, isSysGen);
    }

    protected Index createCatalogIndex() {
        return new SybaseASACatalogBaseIndex();
    }

    public static class ASABaseRoutineLoader
    extends JDBCRoutineLoader {
        public static final String REMOTE_SERVER = "REMOTE SERVER";

        public ASABaseRoutineLoader(ICatalogObject catalogObj) {
            super(catalogObj, null, (JDBCRoutineLoader.IRoutineFactory)new ASAUseDefinedFunctionFactory(), (JDBCRoutineLoader.IRoutineFactory)new ASAProcedureFactory());
        }

        protected ResultSet createResultSet() throws SQLException {
            Schema schema = this.getSchema();
            SybaseASABaseDatabase db = (SybaseASABaseDatabase)((ICatalogObject)schema).getCatalogDatabase();
            PreparedStatement stmt = this.getCatalogObject().getConnection().prepareStatement(SQLScriptsProvider.getQueryRoutines((Database)db));
            stmt.setString(1, schema.getName());
            return stmt.executeQuery();
        }

        protected void closeResultSet(ResultSet rs) {
            try {
                Statement stmt = rs.getStatement();
                super.closeResultSet(rs);
                stmt.close();
            }
            catch (SQLException sQLException) {}
        }

        public static class ASAProcedureFactory
        extends JDBCRoutineLoader.ProcedureFactory {
            public Routine createRoutine(ResultSet rs) throws SQLException {
                Object retVal = this.newRoutine();
                String remoteSrv = rs.getString(ASABaseRoutineLoader.REMOTE_SERVER);
                retVal = remoteSrv != null ? new SybaseASACatalogBaseRemoteProcedure() : new SybaseASACatalogBaseProcedure();
                this.initialize((Routine)retVal, rs);
                return retVal;
            }

            public void initialize(Routine routine, ResultSet rs) throws SQLException {
                routine.setName(rs.getString("PROCEDURE_NAME"));
            }
        }

        public static class ASAUseDefinedFunctionFactory
        extends JDBCRoutineLoader.ProcedureFactory {
            protected Routine newRoutine() {
                return new SybaseASACatalogBaseUserDefinedFunction();
            }

            public void initialize(Routine routine, ResultSet rs) throws SQLException {
                routine.setName(rs.getString("PROCEDURE_NAME"));
            }
        }
    }

    public static class ASABaseTableLoader
    extends JDBCTableLoader {
        public static final String BASE_TABLE = "BASE";
        public static final String PROXY_TABLE = "PROXY TABLE";
        public static final String TABLE_VIEW = "VIEW";
        public static final String GLOBAL_TEMP_TABLE = "GBL TEMP";

        public ASABaseTableLoader(ICatalogObject catalogObject) {
            super(catalogObject, null);
            this.initTableFacotaries();
        }

        protected void initTableFacotaries() {
            super.registerTableFactory(TABLE_VIEW, (JDBCTableLoader.ITableFactory)new ASABaseViewFactory());
            super.registerTableFactory(GLOBAL_TEMP_TABLE, (JDBCTableLoader.ITableFactory)new ASABaseGlobalTempTableFactory());
            super.registerTableFactory(PROXY_TABLE, (JDBCTableLoader.ITableFactory)new ASABaseProxyTableFactory());
        }

        protected ResultSet createResultSet() throws SQLException {
            Schema schema = this.getSchema();
            Connection conn = this.getCatalogObject().getConnection();
            PreparedStatement stmt = conn.prepareStatement("SELECT TRIM(T.table_name) as 'TABLE_NAME', if (T.existing_obj IS NOT NULL) THEN 'PROXY TABLE' ELSE  T.table_type  endif as 'TABLE_TYPE', T.existing_obj as 'EXISTING' FROM SYS.SYSTABLE T JOIN SYS.SYSUSERPERMS U ON U.user_id = T.creator where U.user_name = ? AND T.table_type<>'JVT' order by 1");
            stmt.setString(1, schema.getName());
            return stmt.executeQuery();
        }

        protected void closeResultSet(ResultSet rs) {
            try {
                Statement stmt = rs.getStatement();
                super.closeResultSet(rs);
                stmt.close();
            }
            catch (SQLException sQLException) {}
        }

        protected Table processRow(ResultSet rs) throws SQLException {
            String tableName = rs.getString("TABLE_NAME");
            if (tableName == null) {
                return null;
            }
            String tableType = rs.getString("TABLE_TYPE");
            JDBCTableLoader.ITableFactory tableFactory = this.getTableFactory(tableType != null ? tableType.trim() : tableType);
            Table table = tableFactory.createTable(rs);
            return table;
        }

        public static class ASABaseGlobalTempTableFactory
        extends JDBCTableLoader.TableFactory {
            protected Table newTable() {
                return new SybaseASACatalogBaseTempTable();
            }
        }

        public static class ASABaseProxyTableFactory
        extends JDBCTableLoader.TableFactory {
            protected Table newTable() {
                return new SybaseASACatalogBaseProxyTable();
            }

            public void initialize(Table table, ResultSet rs) throws SQLException {
                super.initialize(table, rs);
                String objectExisting = rs.getString("EXISTING");
                ((SybaseASABaseProxyTable)table).setExisting(objectExisting.equals("Y"));
            }
        }

        public static class ASABaseViewFactory
        extends JDBCTableLoader.TableFactory {
            protected Table newTable() {
                return new SybaseASACatalogBaseViewTable();
            }
        }
    }

    public static class ASABaseUDTLoader
    extends JDBCUserDefinedTypeLoader {
        public ASABaseUDTLoader(ICatalogObject catalogObj) {
            super(catalogObj, null, (JDBCUserDefinedTypeLoader.IUDTFactory)new ASAUDTFactory(RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(catalogObj instanceof Schema ? ((Schema)catalogObj).getCatalog().getDatabase() : null)), null, null);
        }

        protected ResultSet createResultSet() throws SQLException {
            Schema schema = this.getSchema();
            PreparedStatement stmt = this.getCatalogObject().getConnection().prepareStatement("select 2001 as 'DATA_TYPE', TRIM(type_name) as 'TYPE_NAME' from sys.sysusertype where creator=suser_id(?) and domain_id <> 25 ORDER BY 2");
            stmt.setString(1, schema.getName());
            return stmt.executeQuery();
        }

        protected void closeResultSet(ResultSet rs) {
            try {
                Statement stmt = rs.getStatement();
                super.closeResultSet(rs);
                stmt.close();
            }
            catch (SQLException sQLException) {}
        }

        public static class ASAUDTFactory
        extends JDBCUserDefinedTypeLoader.DistinctTypeFactory {
            public ASAUDTFactory(DatabaseDefinition databaseDefinition) {
                super(databaseDefinition);
            }

            protected UserDefinedType newUDT() {
                return new SybaseASACatalogBaseUserDefinedDataType();
            }

            public void initialize(UserDefinedType udt, ResultSet rs) throws SQLException {
                String udtName = rs.getString("TYPE_NAME");
                udt.setName(udtName);
            }
        }
    }

    public static class IndexWrapper {
        String indexName;
        boolean isSysGen;

        public IndexWrapper(String idxName, boolean isSysGen) {
            this.indexName = idxName;
            this.isSysGen = isSysGen;
        }
    }
}

