/*******************************************************************************
 * Copyright (c) 2000, 2019 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 * IBM - Initial API and implementation
 * Jesper Steen Moller - Enhancement 254677 - filter getters/setters
 *******************************************************************************/
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.osgi.util.NLS;

public class DebugUIMessages extends NLS {
	private static final String BUNDLE_NAME = "org.eclipse.jdt.internal.debug.ui.DebugUIMessages";//$NON-NLS-1$

	public static String ExceptionHandler_seeErrorLogMessage;

	public static String HeapWalkingPreferencePage_0;

	public static String HeapWalkingPreferencePage_1;

	public static String HeapWalkingPreferencePage_2;

	public static String HeapWalkingPreferencePage_3;

	public static String HeapWalkingPreferencePage_4;

	public static String HeapWalkingPreferencePage_5;

	public static String HeapWalkingPreferencePage_6;

	public static String ImageDescriptorRegistry_Allocating_image_for_wrong_display_1;

	public static String JavaDebugPreferencePage_21;

	public static String JavaDebugPreferencePage_22;

	public static String JavaDebugPreferencePage_23;

	public static String JavaDebugPreferencePage_24;

	public static String JavaDebugPreferencePage_25;

	public static String JavaDebugPreferencePage_26;

	public static String JavaDebugPreferencePage_27;

	public static String JavaDebugPreferencePage_SuspendOnRecurrencePolicy;

	public static String JavaDebugPreferencePage_SuspendOnRecurrencePolicy_Always;

	public static String JavaDebugPreferencePage_SuspendOnRecurrencePolicy_Unconfigured;

	public static String JavaDebugPreferencePage_SuspendOnRecurrencePolicy_OnlyOnce;

	public static String JavaDebugPreferencePage_description;
	public static String JavaDebugPreferencePage_Enable_hot_code_replace_1;
	public static String JavaDebugPreferencePage_Alert_me_when_hot_code_replace_fails_1;
	public static String JavaDebugPreferencePage_Alert_me_when_hot_code_replace_is_not_supported_1;
	public static String JavaDebugPreferencePage_Alert_me_when_obsolete_methods_remain_1;
	public static String JavaDebugPreferencePage_Display__hexadecimal_values__byte__short__char__int__long__3;
	public static String JavaDebugPreferencePage_Display__unsigned_values__byte__5;
	public static String JavaDebugPreferencePage_Display_ASCII__character_values__byte__short__int__long__4;
	public static String JavaDebugPreferencePage_Hot_Code_Replace_2;
	public static String JavaDebugPreferencePage_Suspend__execution_on_uncaught_exceptions_1;
	public static String JavaDebugPreferencePage_Suspend_Execution_1;
	public static String JavaDebugPreferencePage_Suspend_execution_on_co_mpilation_errors_1;
	public static String JavaDebugPreferencePage_Value_must_be_a_valid_integer_greater_than__0__ms_1;
	public static String JavaDebugPreferencePage_Replace_classfiles_containing_compilation_errors_1;
	public static String JavaDebugPreferencePage_ShowStepResult_1;
	public static String JavaDebugPreferencePage_ShowStepResult_local;
	public static String JavaDebugPreferencePage_ShowStepResult_remote;
	public static String JavaDebugPreferencePage_ShowStepTimeout_ms_1;
	public static String JavaDebugPreferencePage_Communication_1;
	public static String JavaDebugPreferencePage_Debugger__timeout__2;
	public static String JavaDebugPreferencePage__Launch_timeout__ms___1;
	public static String JavaDebugPreferencePage_14;
	public static String JavaDebugPreferencePage_19;
	public static String JavaDebugPreferencePage_0;
	public static String JavaDebugPreferencePage_20;
	public static String JavaDebugPreferencePage_28;

	public static String JavaDebugPreferencePage_advancedSourcelookup;
	public static String JavaDebugPreferencePage_listenToThreadNameChanges;

	public static String JavaDebugPreferencePage_only_include_exported_entries;
	public static String JavaDebugPreferencePage_filterUnrelatedBreakpoints;
	public static String JavaDebugPreferencePage_promptWhenDeletingCondidtionalBreakpoint;


	public static String JavaDetailFormattersManager_6;

	public static String JavaDetailFormattersManager_7;

	public static String JavaHotCodeReplaceListener_0;

	public static String JavaStepFilterPreferencePage_0;

	public static String JavaStepFilterPreferencePage_Filter_co_nstructors_19;
	public static String JavaStepFilterPreferencePage_Filter_s_ynthetic_methods__requires_VM_support__17;
	public static String JavaStepFilterPreferencePage_Filter_static__initializers_18;
	public static String JavaStepFilterPreferencePage_Filter_getters;
	public static String JavaStepFilterPreferencePage_Filter_setters;
	public static String JavaStepFilterPreferencePage_title;
	public static String JavaStepFilterPreferencePage_description;
	public static String JavaStepFilterPreferencePage_Remove_all_selected_step_filters_16;
	public static String JavaStepFilterPreferencePage_Select_a_package_to_filter_when_stepping_27;
	public static String JavaStepFilterPreferencePage_Select_a_type_to_filter_when_stepping_23;
	public static String JavaStepFilterPreferencePage__Remove_15;
	public static String JavaStepFilterPreferencePage_Add__Filter_9;
	public static String JavaStepFilterPreferencePage_Add__Package____13;
	public static String JavaStepFilterPreferencePage_Add__Type____11;
	public static String JavaStepFilterPreferencePage_Add_package_to_step_filters_24;
	public static String JavaStepFilterPreferencePage_Add_type_to_step_filters_20;
	public static String JavaStepFilterPreferencePage_Choose_a_Java_type_and_add_it_to_step_filters_12;
	public static String JavaStepFilterPreferencePage_Choose_a_package_and_add_it_to_step_filters_14;
	public static String JavaStepFilterPreferencePage_Could_not_open_package_selection_dialog_for_step_filters_25;
	public static String JavaStepFilterPreferencePage_Could_not_open_type_selection_dialog_for_step_filters_21;
	public static String JavaStepFilterPreferencePage_Defined_step_fi_lters__8;
	public static String JavaStepFilterPreferencePage_Key_in_the_name_of_a_new_step_filter_10;
	public static String JavaStepFilterPreferencePage__Select_All_1;
	public static String JavaStepFilterPreferencePage_Selects_all_step_filters_2;
	public static String JavaStepFilterPreferencePage_Deselect_All_3;
	public static String JavaStepFilterPreferencePage_Deselects_all_step_filters_4;

	public static String JDIDebugUIPlugin__0__contains_obsolete_methods_1;
	public static String JDIDebugUIPlugin__0__was_unable_to_replace_the_running_code_with_the_code_in_the_workspace__2;

    public static String JDIDebugUIPlugin_0;
	public static String JDIDebugUIPlugin_1;
	public static String JDIDebugUIPlugin_2;
	public static String JDIDebugUIPlugin_Error_1;
	public static String JDIDebugUIPlugin_Hot_code_replace_failed_1;
	public static String JDIDebugUIPlugin_Obsolete_methods_remain_1;
	public static String JDIDebugUIPlugin_Stepping_may_be_hazardous_1;
	public static String JDIDebugUIPlugin_The_target_VM_does_not_support_hot_code_replace_1;
	public static String JDIDebugUIPlugin_3;
    public static String JDIDebugUIPlugin_4;

	public static String JDIModelPresentation__No_explicit_return_value__30;
	public static String JDIModelPresentation__conditional__2;
	public static String JDIModelPresentation___may_be_out_of_synch__2;
	public static String JDIModelPresentation___out_of_synch__1;
	public static String JDIModelPresentation___scoped__1;
	public static String JDIModelPresentation__1____0__63;
	public static String JDIModelPresentation__disconnected__4;
	public static String JDIModelPresentation__not_responding__6;
	public static String JDIModelPresentation__garbage_collected_object__6;
	public static String JDIModelPresentation__obsolete_method_in__1;
	public static String JDIModelPresentation__terminated__2;

	public static String JDIModelPresentation_117;

	public static String JDIModelPresentation_118;
	public static String JDIModelPresentation_access_71;
	public static String JDIModelPresentation_access_and_modification_70;
	public static String JDIModelPresentation_caught_61;
	public static String JDIModelPresentation_caught_and_uncaught_60;
	public static String JDIModelPresentation_Compilation_error_1;
	public static String JDIModelPresentation_entry_and_exit;
	public static String JDIModelPresentation_entry;
	public static String JDIModelPresentation_exit;
	public static String JDIModelPresentation_hit_count__67;
	public static String JDIModelPresentation_line__65;
	public static String JDIModelPresentation_line__76;
	public static String JDIModelPresentation_local_variables_unavailable;
	public static String JDIModelPresentation_modification_72;
	public static String JDIModelPresentation_native_method;
	public static String JDIModelPresentation_not_available;
	public static String JDIModelPresentation_Suspend_VM;
	public static String JDIModelPresentation_target_suspended;
	public static String JDIModelPresentation_thread_filtered;
	public static String JDIModelPresentation_uncaught_62;

	// thread label keys are built programmatically

	public static String thread_terminated;
	public static String thread_evaluating;
	public static String thread_running;
	public static String thread_stepping;
	public static String thread_suspended;
	public static String thread_suspended_problem;
	public static String thread_suspended_fieldaccess;
	public static String thread_suspended_linebreakpoint;
	public static String thread_suspended_methodentry;
	public static String thread_suspended_exception;
	public static String thread_suspended_exception_uncaught;
	public static String thread_suspended_methodexit;
	public static String thread_suspended_fieldmodification;
	public static String thread_suspended_runtoline;
	public static String thread_suspended_classprepare;

	public static String thread_daemon_terminated;
	public static String thread_daemon_evaluating;
	public static String thread_daemon_running;
	public static String thread_daemon_stepping;
	public static String thread_daemon_suspended;
	public static String thread_daemon_suspended_problem;
	public static String thread_daemon_suspended_fieldaccess;
	public static String thread_daemon_suspended_linebreakpoint;
	public static String thread_daemon_suspended_methodentry;
	public static String thread_daemon_suspended_exception;
	public static String thread_daemon_suspended_exception_uncaught;
	public static String thread_daemon_suspended_methodexit;
	public static String thread_daemon_suspended_fieldmodification;
	public static String thread_daemon_suspended_runtoline;
	public static String thread_daemon_suspended_classprepare;

	public static String thread_system_terminated;
	public static String thread_system_evaluating;
	public static String thread_system_running;
	public static String thread_system_stepping;
	public static String thread_system_suspended;
	public static String thread_system_suspended_problem;
	public static String thread_system_suspended_fieldaccess;
	public static String thread_system_suspended_linebreakpoint;
	public static String thread_system_suspended_methodentry;
	public static String thread_system_suspended_exception;
	public static String thread_system_suspended_exception_uncaught;
	public static String thread_system_suspended_methodexit;
	public static String thread_system_suspended_fieldmodification;
	public static String thread_system_suspended_runtoline;
	public static String thread_system_suspended_classprepare;

	public static String thread_daemon_system_terminated;
	public static String thread_daemon_system_evaluating;
	public static String thread_daemon_system_running;
	public static String thread_daemon_system_stepping;
	public static String thread_daemon_system_suspended;
	public static String thread_daemon_system_suspended_problem;
	public static String thread_daemon_system_suspended_fieldaccess;
	public static String thread_daemon_system_suspended_linebreakpoint;
	public static String thread_daemon_system_suspended_methodentry;
	public static String thread_daemon_system_suspended_exception;
	public static String thread_daemon_system_suspended_exception_uncaught;
	public static String thread_daemon_system_suspended_methodexit;
	public static String thread_daemon_system_suspended_fieldmodification;
	public static String thread_daemon_system_suspended_runtoline;
	public static String thread_daemon_system_suspended_classprepare;
	public static String SuspendTimeoutHandler_suspend;
	public static String SuspendTimeoutHandler_timeout_occurred;
	public static String JDIDebugUIPlugin_Searching_1;
	public static String JDIModelPresentation_unknown_name__1;
	public static String JDIModelPresentation_unknown_type__2;
	public static String JDIModelPresentation_unknown_value__3;
	public static String JDIModelPresentation_unknown_declaring_type__4;
	public static String JDIModelPresentation_unknown_receiving_type__5;
	public static String JDIModelPresentation_unknown_method_name__6;
	public static String JDIModelPresentation__unknown_arguements___7;
	public static String JDIModelPresentation__unknown_line_number__8;
	public static String JDIModelPresentation_instance_1;
	public static String NoLineNumberAttributesStatusHandler_Java_Breakpoint_1;
	public static String NoLineNumberAttributesStatusHandler_2;

	public static String JavaVariableValueEditor_prompt_before_final_value_change_title;
	public static String JavaVariableValueEditor_prompt_before_final_value_change_message;
	public static String JavaVariableValueEditor_prompt_before_final_value_change_toggle_message;

	public static String JavaDetailFormattersPreferencePage_Add__Formatter____5;
	public static String JavaDetailFormattersPreferencePage_Allow_you_to_create_a_new_detail_formatter_6;
	public static String JavaDetailFormattersPreferencePage__Remove_7;
	public static String JavaDetailFormattersPreferencePage_0;
	public static String JavaDetailFormattersPreferencePage_1;
	public static String JavaDetailFormattersPreferencePage_2;
	public static String JavaDetailFormattersPreferencePage_3;
	public static String JavaDetailFormattersPreferencePage_4;
	public static String JavaDetailFormattersPreferencePage_Remove_all_selected_detail_formatters_8;
	public static String JavaDetailFormattersPreferencePage__Edit____9;
	public static String JavaDetailFormattersPreferencePage_Edit_the_selected_detail_formatter_10;
	public static String JavaDetailFormattersPreferencePage_Override_default___toString_____for_Variables_and_Expressions_view_details__1;
	public static String JavaDetailFormattersPreferencePage__Types_with_detail_formatters__2;
	public static String JavaDetailFormattersPreferencePage_Detail_formatter_code_snippet_defined_for_selected_type__3;

	public static String DetailFormatterDialog_Qualified_type__name__2;
	public static String DetailFormatterDialog_Qualified_type_name_must_not_be_empty__3;
	public static String DetailFormatterDialog_Select__type_4;
	public static String DetailFormatterDialog_Select_type_6;
	public static String DetailFormatterDialog_Could_not_open_type_selection_dialog_for_detail_formatters_7;
	public static String DetailFormatterDialog_Select_type_8;
	public static String DetailFormatterDialog_Select_type_9;
	public static String DetailFormatterDialog_Select_type_10;
	public static String DetailFormatterDialog_Select_a_type_to_format_when_displaying_its_detail_9;
	public static String DetailFormatterDialog_Edit_Detail_Formatter_1;
	public static String DetailFormatterDialog_Add_Detail_Formatter_2;
	public static String DetailFormatterDialog_Associated_code_must_not_be_empty_3;
	public static String DetailFormatterDialog_Detail_formatter__code_snippet__1;
	public static String DetailFormatterDialog_17;

	public static String No_type_with_the_given_name_found_in_the_workspace__1;
	public static String JavaDetailFormattersManager_Detail_formatter_error___1;
	public static String JavaDetailFormattersManager_An_exception_occurred___0__3;
	public static String DetailFormatterDialog__Enable_1;
	public static String DetailFormatterDialog_A_detail_formatter_is_already_defined_for_this_type_2;

	public static String JavaUISourceLocator_Select_Source_1;
	public static String JavaUISourceLocator__Select_the_source_that_corresponds_to__0__2;
	public static String JavaUISourceLocator__Matching_files__3;
	public static String JavaUISourceLocator__Location__4;

	public static String ConditionalBreakpointErrorDialog_Conditional_Breakpoint_Error_1;
	public static String ConditionalBreakpointErrorDialog__Edit_Condition_2;

	public static String JavaDebugOptionsManager_Conditional_breakpoint_encountered_runtime_exception__1;
	public static String JavaDebugOptionsManager_Conditional_breakpoint_has_compilation_error_s___2;
	public static String JavaDetailFormattersManager_null;
	public static String JavaDetailFormattersManager_no_suspended_threads;
	public static String JavaDetailFormattersManager__unknown_;
	public static String JavaLogicalStructuresPreferencePage_0;
	public static String JavaLogicalStructuresPreferencePage_1;
	public static String JavaLogicalStructuresPreferencePage_10;
	public static String JavaLogicalStructuresPreferencePage_11;
	public static String JavaLogicalStructuresPreferencePage_12;
	public static String JavaLogicalStructuresPreferencePage_2;
	public static String JavaLogicalStructuresPreferencePage_3;
	public static String JavaLogicalStructuresPreferencePage_4;
	public static String JavaLogicalStructuresPreferencePage_5;
	public static String JavaLogicalStructuresPreferencePage_6;
	public static String JavaLogicalStructuresPreferencePage_7;
	public static String JavaLogicalStructuresPreferencePage_8;
	public static String JavaLogicalStructuresPreferencePage_9;
	public static String JDIModelPresentation_no_suspended_threads;

	public static String JavaDebugOptionsManager_Breakpoint___1;
	public static String JavaDebugOptionsManager_Method_breakpoint___2;
	public static String JavaDebugOptionsManager_Watchpoint___3;
	public static String JavaDebugOptionsManager_0;

	public static String JavaDebugOptionsManager_exceptionRecurrence_dialogTitle;
	public static String JavaDebugOptionsManager_exceptionRecurrence_dialogMessage;
	public static String JavaDebugOptionsManager_skip_buttonLabel;
	public static String JavaDebugOptionsManager_suspend_buttonLabel;
	public static String JavaDebugOptionsManager_exceptionRecurrence_remember_decision;

	public static String JavaDebugOptionsManager_Line_breakpoint___4;

	public static String JavaBreakpointWorkbenchAdapterFactory_1;

	public static String HotCodeReplaceErrorDialog_0;
	public static String HotCodeReplaceErrorDialog_1;
	public static String HotCodeReplaceErrorDialog_2;
	public static String HotCodeReplaceErrorDialog_3;
	public static String HotCodeReplaceErrorDialog_5;
	public static String HotCodeReplaceErrorDialog_6;
	public static String HotCodeReplaceErrorDialog_7;
	public static String HotCodeReplaceErrorDialog_8;

	public static String CreateStepFilterDialog_2;
	public static String CreateStepFilterDialog_3;
	public static String CreateStepFilterDialog_4;
	public static String CreateStepFilterDialog_5;
	public static String TypeNameResolver_0;
	public static String JDIModelPresentation_116;
	public static String JDIModelPresentation_0;
	public static String JDIModelPresentation_1;
	public static String JDIModelPresentation_2;
	public static String JDIModelPresentation_3;
	public static String JDIModelPresentation_4;
	public static String JDIModelPresentation_5;
	public static String JDIModelPresentation_6;
	public static String JDIModelPresentation_7;
	public static String NoLineNumberAttributesStatusHandler_3;
	public static String EditLogicalStructureDialog_0;
	public static String EditLogicalStructureDialog_1;
	public static String EditLogicalStructureDialog_2;
	public static String EditLogicalStructureDialog_3;
	public static String EditLogicalStructureDialog_4;
	public static String EditLogicalStructureDialog_5;
	public static String EditLogicalStructureDialog_7;
	public static String EditLogicalStructureDialog_8;
	public static String EditLogicalStructureDialog_9;
	public static String EditLogicalStructureDialog_10;
	public static String EditLogicalStructureDialog_11;
	public static String EditLogicalStructureDialog_12;
	public static String EditLogicalStructureDialog_13;
	public static String EditLogicalStructureDialog_14;
	public static String EditLogicalStructureDialog_15;
	public static String EditLogicalStructureDialog_16;
	public static String EditLogicalStructureDialog_17;
	public static String EditLogicalStructureDialog_18;
	public static String EditLogicalStructureDialog_19;
	public static String EditLogicalStructureDialog_20;
	public static String EditLogicalStructureDialog_21;
	public static String EditLogicalStructureDialog_22;
	public static String EditLogicalStructureDialog_23;
	public static String EditLogicalStructureDialog_24;
	public static String EditLogicalStructureDialog_25;
	public static String EditLogicalStructureDialog_26;
	public static String EditLogicalStructureDialog_27;
	public static String EditLogicalStructureDialog_28;
	public static String EditLogicalStructureDialog_29;
	public static String EditLogicalStructureDialog_30;
	public static String EditLogicalStructureDialog_31;

	static {
		// load message values from bundle file
		NLS.initializeMessages(BUNDLE_NAME, DebugUIMessages.class);
	}


	public static String EditLogicalStructureDialog_32;

	public static String EditLogicalStructureDialog_33;


	public static String JavaPrimitivesPreferencePage_0;

	public static String JavaPrimitivesPreferencePage_1;

	public static String JavaStepFilterPreferencePage__Use_step_filters;

	public static String JavaVariableLabelProvider_0;

	public static String JavaVariableContentAssistDescription_Keystroke;
}
