/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.pom;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.search.util.ArtifactInfo;
import org.eclipse.m2e.core.ui.internal.search.util.Packaging;
import org.eclipse.m2e.core.ui.internal.search.util.SearchEngine;
import org.eclipse.m2e.core.ui.internal.util.XmlUtils;
import org.eclipse.m2e.editor.MavenEditorImages;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.mojo.MojoParameter;
import org.eclipse.m2e.editor.mojo.MojoParameterMetadataProvider;
import org.eclipse.m2e.editor.pom.PomTemplate;
import org.eclipse.m2e.editor.pom.PomTemplateContextUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class PomTemplateContext
extends Enum<PomTemplateContext> {
    public static final /* enum */ PomTemplateContext UNKNOWN = new PomTemplateContext("unknown");
    public static final /* enum */ PomTemplateContext DOCUMENT = new PomTemplateContext("#document");
    public static final /* enum */ PomTemplateContext PROJECT = new PomTemplateContext("project");
    public static final /* enum */ PomTemplateContext BUILD = new PomTemplateContext("build");
    public static final /* enum */ PomTemplateContext PARENT = new PomTemplateContext("parent");
    public static final /* enum */ PomTemplateContext RELATIVE_PATH = new PomTemplateContext("relativePath");
    public static final /* enum */ PomTemplateContext DEPENDENCIES = new PomTemplateContext("dependencies");
    public static final /* enum */ PomTemplateContext DEPENDENCY_MANAGEMENT = new PomTemplateContext("dependencyManagement");
    public static final /* enum */ PomTemplateContext EXCLUSIONS = new PomTemplateContext("exclusions");
    public static final /* enum */ PomTemplateContext PLUGINS = new PomTemplateContext("plugins");
    public static final /* enum */ PomTemplateContext PLUGIN = new PomTemplateContext("plugin");
    public static final /* enum */ PomTemplateContext PLUGIN_MANAGEMENT = new PomTemplateContext("pluginManagement");
    public static final /* enum */ PomTemplateContext EXECUTIONS = new PomTemplateContext("executions");
    public static final /* enum */ PomTemplateContext PROFILES = new PomTemplateContext("profiles");
    public static final /* enum */ PomTemplateContext PROFILE = new PomTemplateContext("profile");
    public static final /* enum */ PomTemplateContext REPOSITORIES = new PomTemplateContext("repositories");
    public static final /* enum */ PomTemplateContext PROPERTIES = new PomTemplateContext("properties"){

        @Override
        protected void addTemplates(MavenProject project, IProject eclipsePrj, Collection<Template> templates, Node currentNode, String prefix) {
            Properties props;
            HashSet<String> currentNodeProps = new HashSet<String>();
            NodeList nodes = currentNode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                currentNodeProps.add(nodes.item(i).getNodeName());
                ++i;
            }
            if (project != null && (props = project.getProperties()) != null) {
                for (Map.Entry<Object, Object> e : props.entrySet()) {
                    String name = e.getKey().toString();
                    String value = e.getValue().toString();
                    if (currentNodeProps.contains(name) || !name.startsWith(prefix)) continue;
                    String template = "<" + name + ">${" + value + "}</" + name + ">";
                    String desc = NLS.bind((String)Messages.PomTemplateContext_property_override, (Object)value);
                    templates.add(new PomTemplate(name, desc, this.getContextTypeId(), template, false).image(MavenEditorImages.IMG_PROPERTY).relevance(2000));
                }
            }
        }
    };
    public static final /* enum */ PomTemplateContext CONFIGURATION = new PomTemplateContext("configuration"){

        @Override
        public boolean handlesSubtree() {
            return true;
        }

        @Override
        protected void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) throws CoreException {
            Node goalsNode;
            String groupId;
            ArrayList<String> pathElements = new ArrayList<String>();
            String configImpl = null;
            Element configNode = (Element)node;
            while (configNode != null && !this.getNodeName().equals(configNode.getNodeName())) {
                String impl = configNode.getAttribute("implementation");
                if (impl != null && !impl.trim().isEmpty()) {
                    configImpl = impl;
                }
                if (configImpl == null) {
                    pathElements.add(configNode.getNodeName());
                }
                configNode = (Element)configNode.getParentNode();
            }
            if (configNode == null) {
                return;
            }
            Collections.reverse(pathElements);
            String[] configPath = pathElements.toArray(new String[pathElements.size()]);
            Node configContainer = null;
            Node pluginSubNode = configNode;
            String containerName = pluginSubNode.getParentNode().getNodeName();
            if ("execution".equals(containerName) || "reportSet".equals(containerName)) {
                configContainer = pluginSubNode.getParentNode();
                pluginSubNode = configContainer.getParentNode();
            }
            if ((groupId = this.getGroupId(pluginSubNode)) == null) {
                groupId = "org.apache.maven.plugins";
            }
            String artifactId = 2.getArtifactId(pluginSubNode);
            String version = 2.extractVersion(project, eclipseprj, 2.getVersion(pluginSubNode), groupId, artifactId, EXTRACT_STRATEGY_PLUGIN | EXTRACT_STRATEGY_SEARCH);
            if (version == null) {
                return;
            }
            HashSet<String> usedMojos = new HashSet<String>();
            if ("execution".equals(containerName) && (goalsNode = 2.getChildWithName(configContainer, "goals")) != null) {
                NodeList children = goalsNode.getChildNodes();
                int l = children.getLength();
                int i = 0;
                while (i < l) {
                    String goal;
                    Node goalNode = children.item(i);
                    if ("goal".equals(goalNode.getNodeName()) && (goal = XmlUtils.getTextValue((Node)goalNode)) != null && !goal.isEmpty()) {
                        usedMojos.add(goal);
                    }
                    ++i;
                }
            }
            ArtifactKey pluginKey = new ArtifactKey(groupId, artifactId, version, null);
            MojoParameterMetadataProvider prov = new MojoParameterMetadataProvider();
            MojoParameter result = configImpl != null ? prov.getClassConfiguration(pluginKey, configImpl) : (usedMojos.isEmpty() ? prov.getMojoConfiguration(pluginKey) : prov.getMojoConfiguration(pluginKey, usedMojos));
            MojoParameter param = result.getContainer(configPath);
            if (param != null) {
                boolean containsFiles;
                MojoParameter nestedParam;
                List<MojoParameter> nestedParameters = param.getNestedParameters();
                for (MojoParameter parameter : nestedParameters) {
                    String description;
                    String defaultValue;
                    String name = parameter.getName();
                    if (!name.startsWith(prefix)) continue;
                    Object text = NLS.bind((String)Messages.PomTemplateContext_param, (Object)parameter.isRequired(), (Object)parameter.getType());
                    String expression = parameter.getExpression();
                    if (expression != null) {
                        text = (String)text + NLS.bind((String)Messages.PomTemplateContext_param_expr, (Object)expression);
                    }
                    if ((defaultValue = parameter.getDefaultValue()) != null) {
                        text = (String)text + NLS.bind((String)Messages.PomTemplateContext_param_def, (Object)defaultValue);
                    }
                    if ((description = parameter.getDescription()) != null) {
                        String desc = description.trim();
                        text = (String)text + (String)(desc.startsWith("<p>") ? desc : "<br>" + desc);
                    }
                    proposals.add(new PomTemplate(name, (String)text, this.getContextTypeId(), "<" + name + ">${cursor}</" + name + ">", false).image(MavenEditorImages.IMG_PARAMETER).relevance(1900));
                }
                if (param.isMap() && prefix != null && !prefix.trim().isEmpty()) {
                    proposals.add(new PomTemplate(NLS.bind((String)Messages.PomTemplateContext_insertParameter, (Object)prefix), "", this.getContextTypeId(), "<" + prefix + ">${cursor}</" + prefix + ">", true).image(MavenEditorImages.IMG_PARAMETER).relevance(1500));
                }
                if (nestedParameters.size() == 1 && (nestedParam = nestedParameters.get(0)).isMultiple()) {
                    boolean containsFiles2;
                    boolean bl = containsFiles2 = File.class.getSimpleName().equals(nestedParam.getType()) || PomTemplateContext.fromNodeName(nestedParam.getName()).handlesFiles();
                    if (containsFiles2) {
                        this.addFileTemplates(project, eclipseprj, proposals, node, prefix, param.getName().toLowerCase().endsWith("directory"), nestedParam.getName());
                    }
                }
                boolean bl = containsFiles = File.class.getSimpleName().equals(param.getType()) || PomTemplateContext.fromNodeName(param.getName()).handlesFiles();
                if (containsFiles) {
                    this.addFileTemplates(project, eclipseprj, proposals, node, prefix, param.getName().toLowerCase().endsWith("directory"), null);
                }
            }
        }
    };
    public static final /* enum */ PomTemplateContext GROUP_ID = new PomTemplateContext("groupId"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) {
            for (String groupId : 3.getSearchEngine(eclipseprj).findGroupIds(prefix, this.getPackaging(node), this.getContainingArtifact(node))) {
                this.checkAndAdd(proposals, prefix, groupId);
            }
        }
    };
    public static final /* enum */ PomTemplateContext ARTIFACT_ID = new PomTemplateContext("artifactId"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) {
            String groupId = this.getGroupId(node);
            if ((groupId == null || groupId.trim().length() == 0) && "plugin".equals(node.getParentNode().getNodeName())) {
                groupId = "org.apache.maven.plugins";
            }
            if (groupId != null) {
                for (String artifactId : 4.getSearchEngine(eclipseprj).findArtifactIds(groupId, prefix, this.getPackaging(node), this.getContainingArtifact(node))) {
                    this.checkAndAdd(proposals, prefix, artifactId, groupId + ":" + artifactId);
                }
            }
        }
    };
    public static final /* enum */ PomTemplateContext VERSION = new PomTemplateContext("version"){

        /*
         * WARNING - void declaration
         */
        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) {
            String groupId = this.getGroupId(node);
            if ((groupId == null || groupId.trim().length() == 0) && "plugin".equals(node.getParentNode().getNodeName())) {
                groupId = "org.apache.maven.plugins";
            }
            String artifactId = 5.getArtifactId(node);
            if (groupId != null && artifactId != null) {
                for (String version : 5.getSearchEngine(eclipseprj).findVersions(groupId, artifactId, prefix, this.getPackaging(node))) {
                    this.checkAndAdd(proposals, prefix, version, groupId + ":" + artifactId + ":" + version);
                }
            }
            if ("dependency".equals(node.getParentNode().getNodeName())) {
                ArrayList<String> keys = new ArrayList<String>();
                String contextTypeId = this.getContextTypeId();
                MavenProject mvn = project;
                if (mvn != null) {
                    Properties props;
                    if (groupId != null && groupId.equals(mvn.getGroupId())) {
                        proposals.add(new Template("${project.version}", Messages.PomTemplateContext_project_version_hint, contextTypeId, "$${project.version}", false));
                    }
                    if ((props = mvn.getProperties()) != null) {
                        for (Object object : props.keySet()) {
                            if (!object.toString().endsWith(".version") && !object.toString().endsWith("Version")) continue;
                            keys.add(object.toString());
                        }
                        Collections.sort(keys);
                        if (!keys.isEmpty()) {
                            for (String string : keys) {
                                String expr = "${" + string + "}";
                                proposals.add(new Template(expr, Messages.PomTemplateContext_expression_description, contextTypeId, "$" + expr, false));
                            }
                        }
                    }
                } else {
                    Element root = node.getOwnerDocument().getDocumentElement();
                    if (root != null && "project".equals(root.getNodeName())) {
                        void var12_20;
                        Element parEl;
                        String string = XmlUtils.getTextValue((Node)XmlUtils.findChild((Element)root, (String)"groupId"));
                        if (string == null && (parEl = XmlUtils.findChild((Element)root, (String)"parent")) != null) {
                            String string2 = XmlUtils.getTextValue((Node)XmlUtils.findChild((Element)parEl, (String)"groupId"));
                        }
                        if (groupId != null && groupId.equals(var12_20)) {
                            proposals.add(new Template("${project.version}", Messages.PomTemplateContext_project_version_hint, contextTypeId, "$${project.version}", false));
                        }
                    }
                }
            }
        }
    };
    public static final /* enum */ PomTemplateContext CLASSIFIER = new PomTemplateContext("classifier"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) {
            String groupId = this.getGroupId(node);
            String artifactId = 6.getArtifactId(node);
            String version = 6.getVersion(node);
            if (groupId != null && artifactId != null && version != null) {
                for (String classifier : 6.getSearchEngine(eclipseprj).findClassifiers(groupId, artifactId, version, prefix, this.getPackaging(node))) {
                    this.checkAndAdd(proposals, prefix, classifier, groupId + ":" + artifactId + ":" + version + ":" + classifier);
                }
            }
        }
    };
    public static final /* enum */ PomTemplateContext TYPE = new PomTemplateContext("type"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) {
            String groupId = this.getGroupId(node);
            String artifactId = 7.getArtifactId(node);
            String version = 7.getVersion(node);
            if (groupId != null && artifactId != null && version != null) {
                for (String type : 7.getSearchEngine(eclipseprj).findTypes(groupId, artifactId, version, prefix, this.getPackaging(node))) {
                    this.checkAndAdd(proposals, prefix, type, groupId + ":" + artifactId + ":" + version + ":" + type);
                }
            }
        }
    };
    public static final /* enum */ PomTemplateContext PACKAGING = new PomTemplateContext("packaging"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) {
            this.checkAndAdd(proposals, prefix, "pom");
            this.checkAndAdd(proposals, prefix, "jar");
            this.checkAndAdd(proposals, prefix, "war");
            this.checkAndAdd(proposals, prefix, "ear");
            this.checkAndAdd(proposals, prefix, "ejb");
            this.checkAndAdd(proposals, prefix, "maven-plugin");
            this.checkAndAdd(proposals, prefix, "maven-archetype");
        }
    };
    public static final /* enum */ PomTemplateContext SCOPE = new PomTemplateContext("scope"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) {
            this.checkAndAdd(proposals, prefix, "compile");
            this.checkAndAdd(proposals, prefix, "test");
            this.checkAndAdd(proposals, prefix, "provided");
            this.checkAndAdd(proposals, prefix, "runtime");
            this.checkAndAdd(proposals, prefix, "system");
            if (9.getAncestor(node, "dependency", "dependencies", "dependencyManagement") != null) {
                this.checkAndAdd(proposals, prefix, "import");
            }
        }
    };
    public static final /* enum */ PomTemplateContext SYSTEM_PATH = new PomTemplateContext("systemPath");
    public static final /* enum */ PomTemplateContext PHASE = new PomTemplateContext("phase"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) {
            this.checkAndAdd(proposals, prefix, "pre-clean", Messages.PomTemplateContext_preclean);
            this.checkAndAdd(proposals, prefix, "clean", Messages.PomTemplateContext_clean);
            this.checkAndAdd(proposals, prefix, "post-clean", Messages.PomTemplateContext_postclean);
            this.checkAndAdd(proposals, prefix, "validate", Messages.PomTemplateContext_validate);
            this.checkAndAdd(proposals, prefix, "generate-sources", Messages.PomTemplateContext_generatesources);
            this.checkAndAdd(proposals, prefix, "process-sources", Messages.PomTemplateContext_processsources);
            this.checkAndAdd(proposals, prefix, "generate-resources", Messages.PomTemplateContext_generateresources);
            this.checkAndAdd(proposals, prefix, "process-resources", Messages.PomTemplateContext_processresources);
            this.checkAndAdd(proposals, prefix, "compile", Messages.PomTemplateContext_compile);
            this.checkAndAdd(proposals, prefix, "process-classes", Messages.PomTemplateContext_processclasses);
            this.checkAndAdd(proposals, prefix, "generate-test-sources", Messages.PomTemplateContext_generatetestsources);
            this.checkAndAdd(proposals, prefix, "process-test-sources", Messages.PomTemplateContext_processtestsources);
            this.checkAndAdd(proposals, prefix, "generate-test-resources", Messages.PomTemplateContext_generatetestresources);
            this.checkAndAdd(proposals, prefix, "process-test-resources", Messages.PomTemplateContext_processtestresources);
            this.checkAndAdd(proposals, prefix, "test-compile", Messages.PomTemplateContext_testcompile);
            this.checkAndAdd(proposals, prefix, "process-test-classes", Messages.PomTemplateContext_processtestclasses);
            this.checkAndAdd(proposals, prefix, "test", Messages.PomTemplateContext_test);
            this.checkAndAdd(proposals, prefix, "prepare-package", Messages.PomTemplateContext_preparepackage);
            this.checkAndAdd(proposals, prefix, "package", Messages.PomTemplateContext_package);
            this.checkAndAdd(proposals, prefix, "pre-integration-test", Messages.PomTemplateContext_preintegrationtest);
            this.checkAndAdd(proposals, prefix, "integration-test", Messages.PomTemplateContext_integrationtest);
            this.checkAndAdd(proposals, prefix, "post-integration-test", Messages.PomTemplateContext_postintegrationtest);
            this.checkAndAdd(proposals, prefix, "verify", Messages.PomTemplateContext_verify);
            this.checkAndAdd(proposals, prefix, "install", Messages.PomTemplateContext_install);
            this.checkAndAdd(proposals, prefix, "deploy", Messages.PomTemplateContext_deploy);
            this.checkAndAdd(proposals, prefix, "pre-site", Messages.PomTemplateContext_presite);
            this.checkAndAdd(proposals, prefix, "site", Messages.PomTemplateContext_site);
            this.checkAndAdd(proposals, prefix, "post-site", Messages.PomTemplateContext_postsite);
            this.checkAndAdd(proposals, prefix, "site-deploy", Messages.PomTemplateContext_sitedeploy);
        }
    };
    public static final /* enum */ PomTemplateContext GOAL = new PomTemplateContext("goal"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) {
            List mojos;
            if (!"goals".equals(node.getParentNode().getNodeName())) {
                return;
            }
            if (!"execution".equals((node = node.getParentNode()).getParentNode().getNodeName())) {
                return;
            }
            if (!"executions".equals((node = node.getParentNode()).getParentNode().getNodeName())) {
                return;
            }
            String groupId = this.getGroupId(node = node.getParentNode());
            if (groupId == null) {
                groupId = "org.apache.maven.plugins";
            }
            String artifactId = 11.getArtifactId(node);
            String version = 11.extractVersion(project, eclipseprj, 11.getVersion(node), groupId, artifactId, EXTRACT_STRATEGY_PLUGIN | EXTRACT_STRATEGY_SEARCH);
            if (version == null) {
                return;
            }
            PluginDescriptor descriptor = PomTemplateContextUtil.INSTANCE.getPluginDescriptor(groupId, artifactId, version);
            if (descriptor != null && (mojos = descriptor.getMojos()) != null) {
                for (MojoDescriptor mojo : mojos) {
                    this.checkAndAdd(proposals, prefix, mojo.getGoal(), mojo.getDescription());
                }
            }
        }
    };
    public static final /* enum */ PomTemplateContext MODULES = new PomTemplateContext("modules"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) {
            this.addModuleTemplates(project, eclipseprj, proposals, node, prefix, true);
        }
    };
    public static final /* enum */ PomTemplateContext MODULE = new PomTemplateContext("module"){

        @Override
        public void addTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix) {
            this.addModuleTemplates(project, eclipseprj, proposals, node, prefix, false);
        }
    };
    public static final /* enum */ PomTemplateContext SOURCEDIRECTORY = new PomTemplateContext("sourceDirectory", "file");
    public static final /* enum */ PomTemplateContext SCRIPTSOURCEDIRECTORY = new PomTemplateContext("scriptSourceDirectory", "file");
    public static final /* enum */ PomTemplateContext TESTSOURCEDIRECTORY = new PomTemplateContext("testSourceDirectory", "file");
    public static final /* enum */ PomTemplateContext OUTPUTDIRECTORY = new PomTemplateContext("outputDirectory", "file");
    public static final /* enum */ PomTemplateContext TESTOUTPUTDIRECTORY = new PomTemplateContext("testOutputDirectory", "file");
    public static final /* enum */ PomTemplateContext DIRECTORY = new PomTemplateContext("directory", "file");
    public static final /* enum */ PomTemplateContext FILTER = new PomTemplateContext("filter", "file");
    public static final /* enum */ PomTemplateContext LICENSES = new PomTemplateContext("licenses");
    private static final Logger log;
    private static final String PREFIX = "org.eclipse.m2e.editor.xml.templates.contextType.";
    private final String nodeName;
    private final String contextSuffix;
    private static SearchEngine searchEngineForTests;
    static int EXTRACT_STRATEGY_PLUGIN;
    static int EXTRACT_STRATEGY_DEPENDENCY;
    static int EXTRACT_STRATEGY_SEARCH;
    private static final /* synthetic */ PomTemplateContext[] ENUM$VALUES;

    static {
        ENUM$VALUES = new PomTemplateContext[]{UNKNOWN, DOCUMENT, PROJECT, BUILD, PARENT, RELATIVE_PATH, DEPENDENCIES, DEPENDENCY_MANAGEMENT, EXCLUSIONS, PLUGINS, PLUGIN, PLUGIN_MANAGEMENT, EXECUTIONS, PROFILES, PROFILE, REPOSITORIES, PROPERTIES, CONFIGURATION, GROUP_ID, ARTIFACT_ID, VERSION, CLASSIFIER, TYPE, PACKAGING, SCOPE, SYSTEM_PATH, PHASE, GOAL, MODULES, MODULE, SOURCEDIRECTORY, SCRIPTSOURCEDIRECTORY, TESTSOURCEDIRECTORY, OUTPUTDIRECTORY, TESTOUTPUTDIRECTORY, DIRECTORY, FILTER, LICENSES};
        log = LoggerFactory.getLogger(PomTemplateContext.class);
        EXTRACT_STRATEGY_PLUGIN = 1;
        EXTRACT_STRATEGY_DEPENDENCY = 2;
        EXTRACT_STRATEGY_SEARCH = 4;
    }

    private PomTemplateContext(String nodeName) {
        this(nodeName, nodeName);
    }

    private PomTemplateContext(String nodeName, String contextSuffix) {
        this.nodeName = nodeName;
        this.contextSuffix = contextSuffix;
    }

    public boolean handlesSubtree() {
        return false;
    }

    public boolean handlesFiles() {
        return "file".equals(this.contextSuffix);
    }

    public Template[] getTemplates(MavenProject project, IProject eclipsePrj, Node node, String prefix) {
        ArrayList<Template> templates = new ArrayList<Template>();
        try {
            this.addTemplates(project, eclipsePrj, templates, node, prefix);
        }
        catch (CoreException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return templates.toArray(new Template[templates.size()]);
    }

    protected void addTemplates(MavenProject project, IProject eclipsePrj, Collection<Template> templates, Node currentNode, String prefix) throws CoreException {
        if (this.handlesFiles()) {
            this.addFileTemplates(project, eclipsePrj, templates, currentNode, prefix, this.name().toLowerCase().endsWith("directory"), null);
        }
    }

    protected FileProposalContext getFileProposalContext(MavenProject project, IProject eclipsePrj, String prefix) {
        Object prefixPath;
        if (project == null && eclipsePrj == null) {
            return null;
        }
        File projectDir = project != null ? project.getFile().getParentFile() : new File(eclipsePrj.getLocationURI());
        int lastSep = prefix.lastIndexOf(47);
        if (lastSep != -1) {
            prefixPath = prefix.substring(0, lastSep) + "/";
            prefix = prefix.substring(lastSep + 1);
        } else {
            prefixPath = "";
        }
        String interpolated = PomTemplateContext.simpleInterpolate(project, (String)prefixPath);
        Object parentPath = interpolated == null ? prefixPath : interpolated;
        File parentDir = !new File((String)parentPath).isAbsolute() ? new File(projectDir, (String)parentPath) : new File((String)parentPath);
        if (!parentDir.isDirectory()) {
            return null;
        }
        return new FileProposalContext(projectDir, parentDir, (String)prefixPath, prefix);
    }

    protected void addFileTemplates(MavenProject project, IProject eclipsePrj, Collection<Template> templates, Node currentNode, String prefix, boolean dirsOnly, String wrapperNode) {
        FileProposalContext pctx = this.getFileProposalContext(project, eclipsePrj, prefix);
        if (pctx == null) {
            return;
        }
        List<File> files = Arrays.asList(pctx.parentDir.listFiles());
        Collections.sort(files, Comparator.comparingInt(r -> r.isDirectory() ? 0 : 1).thenComparing(Comparator.comparing(File::getName)));
        int rel = 4000;
        for (File f : files) {
            if (!f.getName().startsWith(pctx.prefix)) continue;
            String value = pctx.prefixPath + f.getName();
            Object template = value;
            boolean retrigger = false;
            if (f.isDirectory()) {
                if (this.hasContents(f, dirsOnly)) {
                    template = (String)template + "/";
                    retrigger = true;
                }
            } else if (dirsOnly) continue;
            template = ((String)template).replace("$", "$$");
            if (wrapperNode != null) {
                template = "<" + wrapperNode + ">" + (String)template + "${cursor}</" + wrapperNode + ">";
            }
            templates.add(new PomTemplate(f.getName(), "", this.getContextTypeId(), (String)template, false).image(PomTemplateContext.getFileIcon(f)).matchValue(value).relevance(rel--).retriggerOnApply(retrigger));
        }
    }

    private boolean hasContents(File f, final boolean dirsOnly) {
        final boolean[] res = new boolean[1];
        final Path thisPath = f.toPath();
        try {
            Files.walkFileTree(thisPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (thisPath.equals(dir)) {
                        return FileVisitResult.CONTINUE;
                    }
                    res[0] = true;
                    return FileVisitResult.TERMINATE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (dirsOnly) {
                        return FileVisitResult.CONTINUE;
                    }
                    res[0] = true;
                    return FileVisitResult.TERMINATE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res[0];
    }

    protected void addModuleTemplates(MavenProject project, IProject eclipseprj, Collection<Template> proposals, Node node, String prefix, boolean wrap) {
        if (project == null) {
            return;
        }
        final FileProposalContext pctx = this.getFileProposalContext(project, eclipseprj, prefix);
        if (pctx == null) {
            return;
        }
        final HashSet<String> existings = new HashSet<String>();
        Node moduleNode = node;
        if (moduleNode != null) {
            Node modulesNode = "modules".equals(moduleNode.getLocalName()) ? moduleNode : moduleNode.getParentNode();
            while (modulesNode != null) {
                for (Element el : XmlUtils.findChilds((Element)((Element)modulesNode), (String)"module")) {
                    String val;
                    if (el == moduleNode || (val = XmlUtils.getTextValue((Node)el)) == null) continue;
                    existings.add(val);
                }
                Node profileProjectNode = PomTemplateContext.getAncestor(modulesNode, "profile", "profiles", "project");
                modulesNode = profileProjectNode != null ? PomTemplateContext.getChildWithName(profileProjectNode, "modules") : null;
            }
        }
        final TreeSet subProjects = new TreeSet();
        try {
            final Path projectPath = pctx.projectDir.toPath().toRealPath(new LinkOption[0]);
            final Path parentPath = pctx.parentDir.toPath().toRealPath(new LinkOption[0]);
            SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){
                boolean submodulesSearch;
                boolean submodulesFound;
                Path submodulesSearchBase;

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (this.submodulesSearch && this.submodulesFound) {
                        return FileVisitResult.SKIP_SIBLINGS;
                    }
                    String name = dir.getFileName().toString();
                    if (name.startsWith(".")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (parentPath.equals(dir)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (projectPath.equals(dir) && pctx.prefixPath.startsWith("../")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (projectPath.startsWith(dir)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (Arrays.asList("src", "target", "bin").contains(name) && dir.resolve("../pom.xml").toFile().exists()) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (dir.resolve("pom.xml").toFile().exists()) {
                        if (this.submodulesSearch) {
                            this.submodulesFound = true;
                            return FileVisitResult.SKIP_SIBLINGS;
                        }
                        String path = projectPath.relativize(dir).toString().replace('\\', '/');
                        if (!existings.contains(path)) {
                            subProjects.add(path);
                        }
                        this.submodulesSearch = true;
                        this.submodulesSearchBase = dir;
                        this.submodulesFound = false;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) {
                    if (this.submodulesSearch && dir.equals(this.submodulesSearchBase)) {
                        if (this.submodulesFound) {
                            String path = projectPath.relativize(dir).toString().replace('\\', '/');
                            subProjects.add(path + "/");
                        }
                        this.submodulesSearch = false;
                        this.submodulesSearchBase = null;
                        this.submodulesFound = false;
                    }
                    return FileVisitResult.CONTINUE;
                }
            };
            Files.walkFileTree(parentPath, EnumSet.of(FileVisitOption.FOLLOW_LINKS), 5, (FileVisitor<? super Path>)visitor);
        }
        catch (IOException projectPath) {
            // empty catch block
        }
        subProjects.removeAll(existings);
        int moduleRel = 8000;
        int submoduleRel = 4000;
        for (String path : subProjects) {
            int rel;
            String description;
            Image image;
            if (!path.startsWith(prefix)) continue;
            String value = path;
            Object template = value;
            template = ((String)template).replace("$", "$$");
            boolean retrigger = false;
            if (path.endsWith("/")) {
                image = MavenEditorImages.IMG_DISCOVERY;
                description = NLS.bind((String)Messages.PomTemplateContext_submodules, (Object)path);
                rel = submoduleRel--;
                retrigger = true;
            } else {
                image = PomTemplateContext.getFileIcon(new File(pctx.projectDir, path));
                description = NLS.bind((String)Messages.PomTemplateContext_module, (Object)path);
                rel = moduleRel--;
            }
            if (wrap) {
                template = "<module>" + (String)template + "${cursor}</module>";
            }
            proposals.add(new PomTemplate(value, description, this.getContextTypeId(), (String)template, false).image(image).relevance(rel).retriggerOnApply(retrigger));
        }
    }

    protected static Image getFileIcon(File f) {
        IContainer res;
        IWorkspaceRoot wroot = ResourcesPlugin.getWorkspace().getRoot();
        Object[] resources = f.isDirectory() ? wroot.findContainersForLocationURI(f.toURI()) : wroot.findFilesForLocationURI(f.toURI());
        IContainer iContainer = res = resources.length > 0 ? resources[0] : null;
        if (res != null) {
            IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)res.getAdapter(IWorkbenchAdapter.class);
            if (wbAdapter == null) {
                return null;
            }
            ImageDescriptor id = wbAdapter.getImageDescriptor((Object)res);
            return id != null ? MavenEditorImages.getImage(id) : null;
        }
        if (f.isDirectory()) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }

    protected String getNodeName() {
        return this.nodeName;
    }

    public String getContextTypeId() {
        return PREFIX + this.contextSuffix;
    }

    public static PomTemplateContext fromId(String contextTypeId) {
        PomTemplateContext[] pomTemplateContextArray = PomTemplateContext.values();
        int n = pomTemplateContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            PomTemplateContext context = pomTemplateContextArray[n2];
            if (context.getContextTypeId().equals(contextTypeId)) {
                return context;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    public static PomTemplateContext fromNodeName(String idSuffix) {
        PomTemplateContext[] pomTemplateContextArray = PomTemplateContext.values();
        int n = pomTemplateContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            PomTemplateContext context = pomTemplateContextArray[n2];
            if (context.getNodeName().equals(idSuffix)) {
                return context;
            }
            ++n2;
        }
        return UNKNOWN;
    }

    public static PomTemplateContext fromNode(Node node) {
        PomTemplateContext context;
        PomTemplateContext ancestorContext = context = PomTemplateContext.fromNodeName(node.getNodeName());
        while (!ancestorContext.handlesSubtree() && node != null) {
            ancestorContext = PomTemplateContext.fromNodeName(node.getNodeName());
            node = node.getParentNode();
        }
        if (ancestorContext.handlesSubtree()) {
            context = ancestorContext;
        }
        return context;
    }

    protected static SearchEngine getSearchEngine(IProject project) {
        if (searchEngineForTests != null) {
            return searchEngineForTests;
        }
        return M2EUIPluginActivator.getDefault().getSearchEngine(project);
    }

    public static void setSearchEngineForTests(SearchEngine _searchEngineForTests) {
        searchEngineForTests = _searchEngineForTests;
    }

    protected ArtifactInfo getContainingArtifact(Node currentNode) {
        if (this.isExclusion(currentNode)) {
            Node node = currentNode.getParentNode().getParentNode();
            return this.getArtifactInfo(node);
        }
        return null;
    }

    private ArtifactInfo getArtifactInfo(Node node) {
        return new ArtifactInfo(this.getGroupId(node), PomTemplateContext.getArtifactId(node), PomTemplateContext.getVersion(node), PomTemplateContext.getSiblingTextValue(node, "classifier"), PomTemplateContext.getSiblingTextValue(node, "type"));
    }

    protected Packaging getPackaging(Node currentNode) {
        if (this.isPlugin(currentNode)) {
            return Packaging.PLUGIN;
        }
        if (this.isParent(currentNode)) {
            return Packaging.POM;
        }
        return Packaging.ALL;
    }

    private boolean isPlugin(Node currentNode) {
        return "plugin".equals(currentNode.getParentNode().getNodeName());
    }

    private boolean isExclusion(Node currentNode) {
        return "exclusion".equals(currentNode.getParentNode().getNodeName());
    }

    private boolean isParent(Node currentNode) {
        return "parent".equals(currentNode.getParentNode().getNodeName());
    }

    protected String getGroupId(Node currentNode) {
        return PomTemplateContext.getSiblingTextValue(currentNode, "groupId");
    }

    protected void checkAndAdd(Collection<Template> proposals, String prefix, String name) {
        this.checkAndAdd(proposals, prefix, name, name);
    }

    protected void checkAndAdd(Collection<Template> proposals, String prefix, String name, String description) {
        this.checkAndAdd(proposals, prefix, name, name, -1);
    }

    protected void checkAndAdd(Collection<Template> proposals, String prefix, String name, String description, int rel) {
        if (name.startsWith(prefix)) {
            proposals.add(new PomTemplate(name, description, this.getContextTypeId(), name, false).relevance(rel));
        }
    }

    static String extractVersion(MavenProject mp, IProject project, String version, String groupId, String artifactId, int strategy) {
        assert (mp != null);
        if ((version = PomTemplateContext.simpleInterpolate(mp, version)) == null) {
            Packaging pack = Packaging.ALL;
            if ((strategy & EXTRACT_STRATEGY_PLUGIN) != 0) {
                version = PomTemplateContext.searchPM(mp, groupId, artifactId);
                pack = Packaging.PLUGIN;
            }
            if ((strategy & EXTRACT_STRATEGY_DEPENDENCY) != 0) {
                version = PomTemplateContext.searchDM(mp, groupId, artifactId);
            }
            if (version == null && (strategy & EXTRACT_STRATEGY_SEARCH) != 0) {
                Collection versions = PomTemplateContext.getSearchEngine(project).findVersions(groupId, artifactId, "", pack);
                if (versions.isEmpty()) {
                    return null;
                }
                version = (String)versions.iterator().next();
            }
        }
        return version;
    }

    public static String simpleInterpolate(MavenProject project, String text) {
        if (text != null && text.contains("${")) {
            if (project == null) {
                return null;
            }
            Properties props = project.getProperties();
            RegexBasedInterpolator inter = new RegexBasedInterpolator();
            if (props != null) {
                inter.addValueSource((ValueSource)new PropertiesBasedValueSource(props));
            }
            inter.addValueSource((ValueSource)new PrefixedObjectValueSource(Arrays.asList("pom.", "project."), (Object)project.getModel(), false));
            try {
                text = inter.interpolate(text);
            }
            catch (InterpolationException e) {
                text = null;
            }
        }
        return text;
    }

    static String searchPM(MavenProject project, String groupId, String artifactId) {
        if (project == null) {
            return null;
        }
        String version = null;
        String id = Plugin.constructKey((String)groupId, (String)artifactId);
        PluginManagement pm = project.getPluginManagement();
        if (pm != null) {
            for (Plugin pl : pm.getPlugins()) {
                if (!id.equals(pl.getKey())) continue;
                version = pl.getVersion();
                break;
            }
        }
        return version;
    }

    static String searchDM(MavenProject project, String groupId, String artifactId) {
        if (project == null) {
            return null;
        }
        String version = null;
        String id = groupId + ":" + artifactId + ":";
        DependencyManagement dm = project.getDependencyManagement();
        if (dm != null) {
            for (Dependency dep : dm.getDependencies()) {
                if (!dep.getManagementKey().startsWith(id)) continue;
                version = dep.getVersion();
                break;
            }
        }
        return version;
    }

    protected static String getArtifactId(Node currentNode) {
        return PomTemplateContext.getSiblingTextValue(currentNode, "artifactId");
    }

    protected static String getVersion(Node currentNode) {
        return PomTemplateContext.getSiblingTextValue(currentNode, "version");
    }

    private static String getSiblingTextValue(Node sibling, String name) {
        Node node = PomTemplateContext.getSiblingWithName(sibling, name);
        return XmlUtils.getTextValue((Node)node);
    }

    private static Node getSiblingWithName(Node node, String name) {
        return PomTemplateContext.getChildWithName(node.getParentNode(), name);
    }

    protected static Node getChildWithName(Node node, String name) {
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (name.equals(nodeList.item(i).getNodeName())) {
                return nodeList.item(i);
            }
            ++i;
        }
        return null;
    }

    public static Node getAncestor(Node node, String ... names) {
        int i = 0;
        while (i < names.length) {
            Node parent = node.getParentNode();
            if (parent == null || !names[i].equals(parent.getNodeName())) {
                return null;
            }
            node = parent;
            ++i;
        }
        return i == names.length ? node : null;
    }

    public static PomTemplateContext[] values() {
        PomTemplateContext[] pomTemplateContextArray = ENUM$VALUES;
        int n = pomTemplateContextArray.length;
        PomTemplateContext[] pomTemplateContextArray2 = new PomTemplateContext[n];
        System.arraycopy(ENUM$VALUES, 0, pomTemplateContextArray2, 0, n);
        return pomTemplateContextArray2;
    }

    public static PomTemplateContext valueOf(String string) {
        return Enum.valueOf(PomTemplateContext.class, string);
    }

    private static class FileProposalContext {
        final File projectDir;
        final File parentDir;
        final String prefixPath;
        final String prefix;

        FileProposalContext(File projectDir, File parentDir, String prefixPath, String prefix) {
            this.projectDir = projectDir;
            this.parentDir = parentDir;
            this.prefixPath = prefixPath;
            this.prefix = prefix;
        }
    }
}

